/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.alfresco.encoding.CharactersetFinder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCharactersetFinder
implements CharactersetFinder {
    private static Log logger = LogFactory.getLog(AbstractCharactersetFinder.class);
    private static boolean isDebugEnabled = logger.isDebugEnabled();
    private int bufferSize = 8192;

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public final Charset detectCharset(InputStream is) {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("The InputStream must support marks.  Wrap the stream in a BufferedInputStream.");
        }
        try {
            int bufferSize = this.getBufferSize();
            if (bufferSize < 0) {
                throw new RuntimeException("The required buffer size may not be negative: " + bufferSize);
            }
            is.mark(bufferSize);
            byte[] buffer = new byte[bufferSize];
            int read = is.read(buffer);
            if (read > -1 && read < buffer.length) {
                byte[] copyBuffer = new byte[read];
                System.arraycopy(buffer, 0, copyBuffer, 0, read);
                buffer = copyBuffer;
            }
            Charset charset = this.detectCharset(buffer);
            return charset;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IOException while attempting to detect charset encoding.", e);
        }
        finally {
            try {
                is.reset();
            }
            catch (Throwable ee) {}
        }
    }

    public final Charset detectCharset(byte[] buffer) {
        try {
            Charset charset = this.detectCharsetImpl(buffer);
            if (isDebugEnabled) {
                if (charset == null) {
                    logger.debug((Object)("\nFailed to identify stream character set: \n   Guessed 'chars': " + buffer));
                } else {
                    logger.debug((Object)("\nIdentified character set from stream:\n   Charset:        " + charset + "\n" + "   Detected chars: " + new String(buffer, charset.name())));
                }
            }
            return charset;
        }
        catch (Throwable e) {
            logger.error((Object)"IOException while attempting to detect charset encoding.", e);
            return null;
        }
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected abstract Charset detectCharsetImpl(byte[] var1) throws Exception;
}

