/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import org.alfresco.encryption.DefaultEncryptionUtils;
import org.alfresco.encryption.DefaultEncryptor;
import org.alfresco.encryption.EncryptionUtils;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.KeystoreKeyProvider;
import org.alfresco.encryption.MACUtils;
import org.alfresco.httpclient.MD5EncryptionParameters;

public class EncryptionService {
    protected KeyStoreParameters keyStoreParameters;
    protected MD5EncryptionParameters encryptionParameters;
    protected KeyResourceLoader keyResourceLoader;
    protected String alfrescoHost;
    protected int alfrescoPort;
    protected KeystoreKeyProvider keyProvider;
    protected DefaultEncryptor encryptor;
    protected MACUtils macUtils;
    protected DefaultEncryptionUtils encryptionUtils;

    public EncryptionService(String alfrescoHost, int alfrescoPort, KeyResourceLoader keyResourceLoader, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters) {
        this.keyStoreParameters = keyStoreParameters;
        this.encryptionParameters = encryptionParameters;
        this.alfrescoHost = alfrescoHost;
        this.alfrescoHost = alfrescoHost;
        this.keyResourceLoader = keyResourceLoader;
        this.setup();
    }

    public MD5EncryptionParameters getEncryptionParameters() {
        return this.encryptionParameters;
    }

    public KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public MACUtils getMacUtils() {
        return this.macUtils;
    }

    public EncryptionUtils getEncryptionUtils() {
        return this.encryptionUtils;
    }

    protected void setup() {
        this.setupKeyProvider();
        this.setupEncryptor();
        this.setupMacUtils();
        this.setupEncryptionUtils();
    }

    protected void setupEncryptionUtils() {
        this.encryptionUtils = new DefaultEncryptionUtils();
        this.encryptionUtils.setEncryptor(this.getEncryptor());
        this.encryptionUtils.setMacUtils(this.getMacUtils());
        this.encryptionUtils.setMessageTimeout(this.encryptionParameters.getMessageTimeout());
        this.encryptionUtils.setRemoteIP(this.alfrescoHost);
    }

    protected void setupKeyProvider() {
        this.keyProvider = new KeystoreKeyProvider(this.keyStoreParameters, this.keyResourceLoader);
    }

    protected void setupMacUtils() {
        this.macUtils = new MACUtils();
        this.macUtils.setKeyProvider(this.getKeyProvider());
        this.macUtils.setMacAlgorithm(this.encryptionParameters.getMacAlgorithm());
    }

    protected void setupEncryptor() {
        this.encryptor = new DefaultEncryptor();
        this.encryptor.setKeyProvider(this.getKeyProvider());
        this.encryptor.setCipherAlgorithm(this.encryptionParameters.getCipherAlgorithm());
        this.encryptor.init();
    }
}

