/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private String method;
    private String uri;
    private Map<String, String> args;
    private Map<String, String> headers;
    private byte[] body;
    private String encoding = "UTF-8";
    private String contentType;

    public Request(Request req) {
        this.method = req.method;
        this.uri = req.uri;
        this.args = req.args;
        this.headers = req.headers;
        this.body = req.body;
        this.encoding = req.encoding;
        this.contentType = req.contentType;
    }

    public Request(String method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFullUri() {
        String fullUri;
        String string = fullUri = this.uri == null ? "" : this.uri;
        if (this.args != null && this.args.size() > 0) {
            int prefix = this.uri.indexOf(63) == -1 ? 63 : 38;
            for (Map.Entry<String, String> arg : this.args.entrySet()) {
                fullUri = fullUri + (char)prefix + arg.getKey() + "=" + (arg.getValue() == null ? "" : arg.getValue());
                prefix = 38;
            }
        }
        return fullUri;
    }

    public Request setArgs(Map<String, String> args) {
        this.args = args;
        return this;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public Request setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Request setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Request setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Request setType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getType() {
        return this.contentType;
    }
}

