/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfresco.ibatis.HierarchicalXMLConfigBuilder;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalSqlSessionFactoryBean
extends SqlSessionFactoryBean {
    private HierarchicalResourceLoader resourceLoader;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Resource configLocation;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private boolean useLocalCaches = false;

    public void setResourceLoader(HierarchicalResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, "resourceLoader", (Object)this.resourceLoader);
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
        this.sqlSessionFactory.getConfiguration().buildAllStatements();
    }

    public void setUseLocalCaches(boolean useLocalCaches) {
        this.useLocalCaches = useLocalCaches;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        Configuration configuration;
        if (this.configLocation != null) {
            try {
                HierarchicalXMLConfigBuilder xmlConfigBuilder = new HierarchicalXMLConfigBuilder(this.resourceLoader, this.configLocation.getInputStream(), null, this.configurationProperties, this.useLocalCaches);
                configuration = xmlConfigBuilder.parse();
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
            }
            finally {
                ErrorContext.instance().reset();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsed configuration file: '" + this.configLocation + "'"));
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Property 'configLocation' not specified, using default MyBatis Configuration");
            }
            configuration = new Configuration();
        }
        if (this.transactionFactory == null) {
            this.transactionFactory = new SpringManagedTransactionFactory(this.dataSource);
        }
        Environment environment = new Environment(this.environment, this.transactionFactory, this.dataSource);
        configuration.setEnvironment(environment);
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            HashMap sqlFragments = new HashMap();
            for (Resource mapperLocation : this.mapperLocations) {
                if (mapperLocation == null) continue;
                String path = mapperLocation instanceof ClassPathResource ? ((ClassPathResource)mapperLocation).getPath() : mapperLocation.toString();
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), configuration, path, sqlFragments);
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                }
                finally {
                    ErrorContext.instance().reset();
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Parsed mapper file: '" + mapperLocation + "'"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Property 'mapperLocations' was not specified, only MyBatis mapper files specified in the config xml were loaded");
        }
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }
}

