/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISPropertyId;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.dictionary.CMISRelationshipTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISAbstractDictionaryService
extends AbstractLifecycleBean
implements CMISDictionaryService,
DictionaryListener {
    protected static final Log logger = LogFactory.getLog(CMISAbstractDictionaryService.class);
    private DictionaryDAO dictionaryDAO;
    protected CMISMapping cmisMapping;
    protected DictionaryService dictionaryService;
    protected TenantService tenantService;
    private Map<String, DictionaryRegistry> registryMap = new ConcurrentHashMap<String, DictionaryRegistry>(4);

    public void setCMISMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    private DictionaryRegistry getRegistry() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        DictionaryRegistry registry = this.registryMap.get(tenantDomain);
        if (registry == null) {
            this.init();
            registry = this.registryMap.get(tenantDomain);
        }
        return registry;
    }

    @Override
    public CMISTypeDefinition findType(CMISTypeId typeId) {
        return this.getRegistry().objectDefsByTypeId.get(typeId);
    }

    @Override
    public CMISTypeDefinition findType(String typeId) {
        CMISTypeId cmisTypeId = this.cmisMapping.getCmisTypeId(typeId);
        return this.findType(cmisTypeId);
    }

    @Override
    public CMISTypeDefinition findTypeForClass(QName clazz, CMISScope ... matchingScopes) {
        CMISTypeDefinition matchingTypeDef;
        boolean scopeByRelationship = false;
        for (CMISScope scope : matchingScopes) {
            if (scope != CMISScope.RELATIONSHIP) continue;
            scopeByRelationship = true;
            break;
        }
        CMISTypeDefinition typeDef = null;
        if (scopeByRelationship) {
            typeDef = this.getRegistry().assocDefsByQName.get(clazz);
        } else {
            typeDef = this.getRegistry().typeDefsByQName.get(clazz);
            if (typeDef == null) {
                typeDef = this.getRegistry().assocDefsByQName.get(clazz);
            }
        }
        CMISTypeDefinition cMISTypeDefinition = matchingTypeDef = matchingScopes.length == 0 ? typeDef : null;
        if (typeDef != null) {
            for (CMISScope scope : matchingScopes) {
                if (typeDef.getTypeId().getScope() != scope) continue;
                matchingTypeDef = typeDef;
                break;
            }
        }
        return matchingTypeDef;
    }

    @Override
    public CMISTypeDefinition findTypeByQueryName(String queryName) {
        CMISTypeDefinition typeDef = this.getRegistry().typeDefsByQueryName.get(queryName.toLowerCase());
        return typeDef;
    }

    @Override
    public CMISPropertyDefinition findPropertyByQueryName(String queryName) {
        CMISPropertyDefinition propertyDef = this.getRegistry().propDefsByQueryName.get(queryName.toLowerCase());
        return propertyDef;
    }

    @Override
    public Collection<CMISTypeDefinition> getBaseTypes() {
        return Collections.unmodifiableCollection(this.getRegistry().baseTypes);
    }

    @Override
    public Collection<CMISTypeDefinition> getAllTypes() {
        return Collections.unmodifiableCollection(this.getRegistry().typeDefsByTypeId.values());
    }

    @Override
    public CMISPropertyDefinition findProperty(QName property, CMISTypeDefinition matchingType) {
        CMISPropertyDefinition propDef = this.getRegistry().propDefsByQName.get(property);
        return this.getProperty(propDef, matchingType);
    }

    @Override
    public CMISPropertyDefinition findProperty(String property, CMISTypeDefinition matchingType) {
        CMISPropertyDefinition propDef = this.getRegistry().propDefsById.get(property.toLowerCase());
        return this.getProperty(propDef, matchingType);
    }

    private CMISPropertyDefinition getProperty(CMISPropertyDefinition property, CMISTypeDefinition matchingType) {
        Map<String, CMISPropertyDefinition> props;
        boolean isMatchingType;
        boolean bl = isMatchingType = matchingType == null;
        if (property != null && matchingType != null && (props = matchingType.getPropertyDefinitions()).containsKey(property.getPropertyId().getId())) {
            isMatchingType = true;
        }
        return isMatchingType ? property : null;
    }

    @Override
    public CMISDataTypeEnum findDataType(QName dataType) {
        return this.cmisMapping.getDataType(dataType);
    }

    protected abstract void createDefinitions(DictionaryRegistry var1);

    private void init() {
        DictionaryRegistry registry = new DictionaryRegistry();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating type definitions...");
        }
        this.createDefinitions(registry);
        for (CMISAbstractTypeDefinition objectTypeDef : registry.objectDefsByTypeId.values()) {
            Map<String, CMISPropertyDefinition> propDefs = objectTypeDef.createProperties(this.cmisMapping, this.dictionaryService);
            for (CMISPropertyDefinition propDef : propDefs.values()) {
                registry.registerPropertyDefinition(propDef);
            }
            objectTypeDef.createSubTypes(this.cmisMapping, this.dictionaryService);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Linking type definitions...");
        }
        for (CMISAbstractTypeDefinition objectTypeDef : registry.objectDefsByTypeId.values()) {
            objectTypeDef.resolveDependencies(registry);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resolving type inheritance...");
        }
        TreeMap<Integer, ArrayList<CMISAbstractTypeDefinition>> order = new TreeMap<Integer, ArrayList<CMISAbstractTypeDefinition>>();
        for (CMISAbstractTypeDefinition typeDef : registry.objectDefsByTypeId.values()) {
            int depth = 0;
            for (CMISAbstractTypeDefinition parent = typeDef.getInternalParentType(); parent != null; parent = parent.getInternalParentType()) {
                ++depth;
            }
            ArrayList<CMISAbstractTypeDefinition> classes = (ArrayList<CMISAbstractTypeDefinition>)order.get(depth);
            if (classes == null) {
                classes = new ArrayList<CMISAbstractTypeDefinition>();
                order.put(depth, classes);
            }
            classes.add(typeDef);
        }
        for (int depth = 0; depth < order.size(); ++depth) {
            for (CMISAbstractTypeDefinition typeDef : (List)order.get(depth)) {
                typeDef.resolveInheritance(registry);
            }
        }
        for (CMISAbstractTypeDefinition typeDef : registry.objectDefsByTypeId.values()) {
            typeDef.assertComplete();
        }
        for (CMISAbstractTypeDefinition typeDef : registry.objectDefsByTypeId.values()) {
            if (!typeDef.isPublic() || typeDef.getParentType() != null) continue;
            registry.baseTypes.add(typeDef);
        }
        this.registryMap.put(this.tenantService.getCurrentUserDomain(), registry);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Initialized CMIS Dictionary. Types:" + registry.typeDefsByTypeId.size() + ", Base Types:" + registry.baseTypes.size() + ", Properties:" + registry.propDefsByPropId.size()));
        }
    }

    public void onDictionaryInit() {
    }

    public void afterDictionaryInit() {
        this.init();
    }

    public void afterDictionaryDestroy() {
        this.registryMap.remove(this.tenantService.getCurrentUserDomain());
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.afterDictionaryInit();
        this.dictionaryDAO.register((DictionaryListener)this);
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    class DictionaryRegistry {
        Map<QName, CMISAbstractTypeDefinition> typeDefsByQName = new HashMap<QName, CMISAbstractTypeDefinition>();
        Map<QName, CMISAbstractTypeDefinition> assocDefsByQName = new HashMap<QName, CMISAbstractTypeDefinition>();
        Map<CMISTypeId, CMISAbstractTypeDefinition> objectDefsByTypeId = new HashMap<CMISTypeId, CMISAbstractTypeDefinition>();
        Map<CMISTypeId, CMISTypeDefinition> typeDefsByTypeId = new HashMap<CMISTypeId, CMISTypeDefinition>();
        Map<String, CMISTypeDefinition> typeDefsByQueryName = new HashMap<String, CMISTypeDefinition>();
        List<CMISTypeDefinition> baseTypes = new ArrayList<CMISTypeDefinition>();
        Map<String, CMISPropertyDefinition> propDefsById = new HashMap<String, CMISPropertyDefinition>();
        Map<QName, CMISPropertyDefinition> propDefsByQName = new HashMap<QName, CMISPropertyDefinition>();
        Map<CMISPropertyId, CMISPropertyDefinition> propDefsByPropId = new HashMap<CMISPropertyId, CMISPropertyDefinition>();
        Map<String, CMISPropertyDefinition> propDefsByQueryName = new HashMap<String, CMISPropertyDefinition>();

        DictionaryRegistry() {
        }

        public void registerTypeDefinition(CMISAbstractTypeDefinition typeDef) {
            CMISTypeDefinition existingTypeDef = this.objectDefsByTypeId.get(typeDef.getTypeId());
            if (existingTypeDef != null) {
                throw new AlfrescoRuntimeException("Type " + typeDef.getTypeId() + " already registered");
            }
            this.objectDefsByTypeId.put(typeDef.getTypeId(), typeDef);
            if (typeDef.isPublic()) {
                QName typeQName = typeDef.getTypeId().getQName();
                if (typeQName != null) {
                    if (typeDef instanceof CMISRelationshipTypeDefinition) {
                        this.assocDefsByQName.put(typeQName, typeDef);
                    } else {
                        this.typeDefsByQName.put(typeQName, typeDef);
                    }
                }
                this.typeDefsByTypeId.put(typeDef.getTypeId(), typeDef);
                this.typeDefsByQueryName.put(typeDef.getQueryName().toLowerCase(), typeDef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered type " + typeDef.getTypeId() + " (scope=" + (Object)((Object)typeDef.getTypeId().getScope()) + ", public=" + typeDef.isPublic() + ")"));
                logger.debug((Object)(" QName: " + typeDef.getTypeId().getQName()));
                logger.debug((Object)(" Table: " + typeDef.getQueryName()));
                logger.debug((Object)(" Action Evaluators: " + typeDef.getActionEvaluators().size()));
            }
        }

        public void registerPropertyDefinition(CMISPropertyDefinition propDef) {
            CMISPropertyDefinition existingPropDef = this.propDefsByPropId.get(propDef.getPropertyId());
            if (existingPropDef != null) {
                throw new AlfrescoRuntimeException("Property " + propDef.getPropertyId() + " of " + propDef.getOwningType().getTypeId() + " already registered by type " + existingPropDef.getOwningType().getTypeId());
            }
            this.propDefsByPropId.put(propDef.getPropertyId(), propDef);
            this.propDefsByQName.put(propDef.getPropertyId().getQName(), propDef);
            this.propDefsById.put(propDef.getPropertyId().getId().toLowerCase(), propDef);
            this.propDefsByQueryName.put(propDef.getQueryName().toLowerCase(), propDef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered property " + propDef.getPropertyId().getId()));
                logger.debug((Object)(" QName: " + propDef.getPropertyId().getQName()));
                logger.debug((Object)(" Id: " + propDef.getPropertyId().getId()));
                logger.debug((Object)(" Owning Type: " + propDef.getOwningType().getTypeId()));
                logger.debug((Object)(" Property Accessor: " + propDef.getPropertyAccessor() + " , mappedProperty=" + propDef.getPropertyAccessor().getMappedProperty()));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DictionaryRegistry[");
            builder.append("Types=").append(this.typeDefsByTypeId.size()).append(", ");
            builder.append("Base Types=").append(this.baseTypes.size()).append(", ");
            builder.append("Properties=").append(this.propDefsByPropId.size());
            builder.append("]");
            return builder.toString();
        }
    }
}

