/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

public class CMISDocumentTypeDefinition
extends CMISAbstractTypeDefinition {
    private static final long serialVersionUID = -7209732754962781522L;
    protected boolean fileable;
    protected CMISContentStreamAllowedEnum contentStreamAllowed;

    public CMISDocumentTypeDefinition(CMISMapping cmisMapping, CMISTypeId typeId, ClassDefinition cmisClassDef) {
        this.isPublic = true;
        this.cmisClassDef = cmisClassDef;
        this.objectTypeId = typeId;
        this.displayName = cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId.getId();
        this.description = cmisClassDef.getDescription() != null ? cmisClassDef.getDescription() : this.displayName;
        QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
        if (typeId == CMISDictionaryModel.DOCUMENT_TYPE_ID) {
            this.objectTypeQueryName = typeId.getId();
            if (parentQName != null) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.OBJECT, parentQName);
            }
        } else {
            this.objectTypeQueryName = ISO9075.encodeSQL((String)cmisMapping.buildPrefixEncodedString(typeId.getQName()));
            if (cmisMapping.isValidCmisDocument(parentQName)) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.DOCUMENT, parentQName);
            }
        }
        this.creatable = true;
        this.queryable = true;
        this.fullTextIndexed = true;
        this.controllablePolicy = false;
        this.controllableACL = true;
        this.includedInSuperTypeQuery = cmisClassDef.getIncludedInSuperTypeQuery();
        this.actionEvaluators = cmisMapping.getActionEvaluators(this.objectTypeId.getScope());
        this.fileable = true;
        this.contentStreamAllowed = CMISContentStreamAllowedEnum.ALLOWED;
    }

    public boolean isFileable() {
        return this.fileable;
    }

    public boolean isVersionable() {
        return true;
    }

    public CMISContentStreamAllowedEnum getContentStreamAllowed() {
        return this.contentStreamAllowed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISDocumentTypeDefinition[");
        builder.append("Id=").append(this.getTypeId().getId()).append(", ");
        builder.append("Namespace=").append(this.getTypeId().getLocalNamespace()).append(", ");
        builder.append("LocalName=").append(this.getTypeId().getLocalName()).append(", ");
        builder.append("QueryName=").append(this.getQueryName()).append(", ");
        builder.append("DisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("ParentId=").append(this.getParentType() == null ? "<none>" : this.getParentType().getTypeId()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("Creatable=").append(this.isCreatable()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("FullTextIndexed=").append(this.isFullTextIndexed()).append(", ");
        builder.append("IncludedInSuperTypeQuery=").append(this.isIncludedInSuperTypeQuery()).append(", ");
        builder.append("ControllablePolicy=").append(this.isControllablePolicy()).append(", ");
        builder.append("ControllableACL=").append(this.isControllableACL()).append(", ");
        builder.append("Fileable=").append(this.isFileable()).append(", ");
        builder.append("Versionable=").append(this.isVersionable()).append(", ");
        builder.append("ContentStreamAllowed=").append((Object)this.getContentStreamAllowed()).append(", ");
        builder.append("SubTypes=").append(this.getSubTypes(false).size()).append(", ");
        builder.append("Properties=").append(this.getPropertyDefinitions().size());
        builder.append("]");
        return builder.toString();
    }
}

