/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.cmis.CMISActionEvaluator;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISPropertyId;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.cmis.mapping.BaseTypeIdProperty;
import org.alfresco.cmis.mapping.CanCheckOutActionEvaluator;
import org.alfresco.cmis.mapping.CheckinCommentProperty;
import org.alfresco.cmis.mapping.ContentStreamIdProperty;
import org.alfresco.cmis.mapping.ContentStreamLengthProperty;
import org.alfresco.cmis.mapping.ContentStreamMimetypeProperty;
import org.alfresco.cmis.mapping.DirectProperty;
import org.alfresco.cmis.mapping.FixedValueActionEvaluator;
import org.alfresco.cmis.mapping.FixedValueProperty;
import org.alfresco.cmis.mapping.IsImmutableProperty;
import org.alfresco.cmis.mapping.IsLatestMajorVersionProperty;
import org.alfresco.cmis.mapping.IsLatestVersionProperty;
import org.alfresco.cmis.mapping.IsMajorVersionProperty;
import org.alfresco.cmis.mapping.IsVersionSeriesCheckedOutProperty;
import org.alfresco.cmis.mapping.ObjectIdProperty;
import org.alfresco.cmis.mapping.ObjectTypeIdProperty;
import org.alfresco.cmis.mapping.ParentActionEvaluator;
import org.alfresco.cmis.mapping.ParentProperty;
import org.alfresco.cmis.mapping.PathProperty;
import org.alfresco.cmis.mapping.PermissionActionEvaluator;
import org.alfresco.cmis.mapping.RootActionEvaluator;
import org.alfresco.cmis.mapping.SourceIdProperty;
import org.alfresco.cmis.mapping.TargetIdProperty;
import org.alfresco.cmis.mapping.VersionLabelProperty;
import org.alfresco.cmis.mapping.VersionSeriesCheckedOutByProperty;
import org.alfresco.cmis.mapping.VersionSeriesCheckedOutIdProperty;
import org.alfresco.cmis.mapping.VersionSeriesIdProperty;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISAccessControlFormatEnum;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISMapping
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog(CMISMapping.class);
    public static String CMIS_MODEL_NS = "cmis";
    public static String CMIS_MODEL_URI = "http://www.alfresco.org/model/cmis/1.0/cs01";
    public static String CMIS_EXT_NS = "cmisext";
    public static String CMIS_EXT_URI = "http://www.alfresco.org/model/cmis/1.0/cs01ext";
    public static String CMIS_MODEL_NAME = "cmismodel";
    public static QName CMIS_MODEL_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)CMIS_MODEL_NAME);
    public static QName CMIS_DATATYPE_ID = QName.createQName((String)CMIS_MODEL_URI, (String)"id");
    public static QName CMIS_DATATYPE_URI = QName.createQName((String)CMIS_MODEL_URI, (String)"uri");
    public static QName CMIS_DATATYPE_XML = QName.createQName((String)CMIS_MODEL_URI, (String)"xml");
    public static QName CMIS_DATATYPE_HTML = QName.createQName((String)CMIS_MODEL_URI, (String)"html");
    public static QName OBJECT_QNAME = QName.createQName((String)CMIS_EXT_URI, (String)"object");
    public static QName FILESYSTEM_OBJECT_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)"filesystemobject");
    public static QName DOCUMENT_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)"document");
    public static QName FOLDER_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)"folder");
    public static QName RELATIONSHIP_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)"relationship");
    public static QName POLICY_QNAME = QName.createQName((String)CMIS_MODEL_URI, (String)"policy");
    public static CMISTypeId OBJECT_TYPE_ID = new CMISTypeId(CMISScope.OBJECT, OBJECT_QNAME, CMIS_MODEL_NS + ":" + OBJECT_QNAME.getLocalName(), OBJECT_QNAME);
    public static CMISTypeId FILESYSTEM_OBJECT_TYPE_ID = new CMISTypeId(CMISScope.OBJECT, FILESYSTEM_OBJECT_QNAME, CMIS_MODEL_NS + ":" + FILESYSTEM_OBJECT_QNAME.getLocalName(), FILESYSTEM_OBJECT_QNAME);
    private ServiceRegistry serviceRegistry;
    private CMISServices cmisService;
    private Map<QName, CMISTypeId> mapAlfrescoQNameToTypeId = new HashMap<QName, CMISTypeId>();
    private Map<QName, QName> mapCmisQNameToAlfrescoQName = new HashMap<QName, QName>();
    private Map<QName, QName> mapAlfrescoQNameToCmisQName = new HashMap<QName, QName>();
    private Map<QName, CMISDataTypeEnum> mapAlfrescoToCmisDataType = new HashMap<QName, CMISDataTypeEnum>();
    private Map<String, AbstractProperty> propertyAccessors = new HashMap<String, AbstractProperty>();
    private Map<CMISScope, Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>>> actionEvaluators = new HashMap<CMISScope, Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>>>();

    public void afterPropertiesSet() throws Exception {
        this.mapAlfrescoQNameToTypeId.put(OBJECT_QNAME, OBJECT_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(FILESYSTEM_OBJECT_QNAME, FILESYSTEM_OBJECT_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(DOCUMENT_QNAME, CMISDictionaryModel.DOCUMENT_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(FOLDER_QNAME, CMISDictionaryModel.FOLDER_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(RELATIONSHIP_QNAME, CMISDictionaryModel.RELATIONSHIP_TYPE_ID);
        this.mapAlfrescoQNameToTypeId.put(POLICY_QNAME, CMISDictionaryModel.POLICY_TYPE_ID);
        this.mapAlfrescoQNameToCmisQName.put(ContentModel.TYPE_CONTENT, DOCUMENT_QNAME);
        this.mapAlfrescoQNameToCmisQName.put(ContentModel.TYPE_FOLDER, FOLDER_QNAME);
        this.mapCmisQNameToAlfrescoQName.put(DOCUMENT_QNAME, ContentModel.TYPE_CONTENT);
        this.mapCmisQNameToAlfrescoQName.put(FOLDER_QNAME, ContentModel.TYPE_FOLDER);
        this.mapCmisQNameToAlfrescoQName.put(RELATIONSHIP_QNAME, null);
        this.mapCmisQNameToAlfrescoQName.put(POLICY_QNAME, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ANY, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ENCRYPTED, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.ASSOC_REF, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.BOOLEAN, CMISDataTypeEnum.BOOLEAN);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CATEGORY, CMISDataTypeEnum.ID);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CHILD_ASSOC_REF, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.CONTENT, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DATE, CMISDataTypeEnum.DATETIME);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DATETIME, CMISDataTypeEnum.DATETIME);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.DOUBLE, CMISDataTypeEnum.DECIMAL);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.FLOAT, CMISDataTypeEnum.DECIMAL);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.INT, CMISDataTypeEnum.INTEGER);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.LOCALE, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.PERIOD, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.LONG, CMISDataTypeEnum.INTEGER);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.MLTEXT, CMISDataTypeEnum.STRING);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.NODE_REF, CMISDataTypeEnum.ID);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.PATH, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.QNAME, null);
        this.mapAlfrescoToCmisDataType.put(DataTypeDefinition.TEXT, CMISDataTypeEnum.STRING);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_ID, CMISDataTypeEnum.ID);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_URI, CMISDataTypeEnum.URI);
        this.mapAlfrescoToCmisDataType.put(CMIS_DATATYPE_HTML, CMISDataTypeEnum.HTML);
        this.registerPropertyAccessor(new ObjectIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new ObjectTypeIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new BaseTypeIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:createdBy", ContentModel.PROP_CREATOR));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:creationDate", ContentModel.PROP_CREATED));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:lastModifiedBy", ContentModel.PROP_MODIFIER));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:lastModificationDate", ContentModel.PROP_MODIFIED));
        this.registerPropertyAccessor(new FixedValueProperty(this.serviceRegistry, "cmis:changeToken", null));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:name", ContentModel.PROP_NAME){

            public Serializable getValue(AssociationRef assocRef) {
                return assocRef.toString();
            }
        });
        this.registerPropertyAccessor(new IsImmutableProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new IsLatestVersionProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new IsMajorVersionProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new IsLatestMajorVersionProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new VersionLabelProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new VersionSeriesIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new IsVersionSeriesCheckedOutProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new VersionSeriesCheckedOutByProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new VersionSeriesCheckedOutIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new CheckinCommentProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new ContentStreamLengthProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new ContentStreamMimetypeProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new ContentStreamIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, "cmis:contentStreamFileName", ContentModel.PROP_NAME));
        this.registerPropertyAccessor(new ParentProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new PathProperty(this.serviceRegistry, this.cmisService));
        this.registerPropertyAccessor(new FixedValueProperty(this.serviceRegistry, "cmis:allowedChildObjectTypeIds", null));
        this.registerPropertyAccessor(new SourceIdProperty(this.serviceRegistry));
        this.registerPropertyAccessor(new TargetIdProperty(this.serviceRegistry));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_OBJECT, "DeleteNode"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_UPDATE_PROPERTIES, "WriteProperties"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_PROPERTIES, "ReadProperties"));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_RELATIONSHIPS, true));
        this.registerEvaluator(CMISScope.DOCUMENT, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_PARENTS, "ReadPermissions")));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_MOVE_OBJECT, "DeleteNode"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_CONTENT_STREAM, "WriteProperties", "WriteContent"));
        this.registerEvaluator(CMISScope.DOCUMENT, new CanCheckOutActionEvaluator(this.serviceRegistry));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CANCEL_CHECKOUT, "CancelCheckOut"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CHECKIN, "CheckIn"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_SET_CONTENT_STREAM, "WriteContent"));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_ALL_VERSIONS, true));
        this.registerEvaluator(CMISScope.DOCUMENT, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_ADD_OBJECT_TO_FOLDER, "LinkChildren")));
        this.registerEvaluator(CMISScope.DOCUMENT, new ParentActionEvaluator(new FixedValueActionEvaluator<NodeRef>(this.serviceRegistry, CMISAllowedActionEnum.CAN_REMOVE_OBJECT_FROM_FOLDER, true)));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_CONTENT_STREAM, "ReadContent"));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_POLICY, false));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_APPLIED_POLICIES, true));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_REMOVE_POLICY, false));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CREATE_RELATIONSHIP, true));
        this.registerEvaluator(CMISScope.DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_RENDITIONS, true));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_ACL, "ReadPermissions"));
        this.registerEvaluator(CMISScope.DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_ACL, "ChangePermissions"));
        this.registerEvaluator(CMISScope.FOLDER, new RootActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_UPDATE_PROPERTIES, "WriteProperties"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_FOLDER_TREE, "ReadChildren"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_PROPERTIES, "ReadProperties"));
        this.registerEvaluator(CMISScope.FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_RELATIONSHIPS, true));
        this.registerEvaluator(CMISScope.FOLDER, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_PARENTS, "ReadPermissions")));
        this.registerEvaluator(CMISScope.FOLDER, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_FOLDER_PARENT, "ReadPermissions")));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_DESCENDANTS, "ReadChildren"));
        this.registerEvaluator(CMISScope.FOLDER, new RootActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_MOVE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(CMISScope.FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_POLICY, false));
        this.registerEvaluator(CMISScope.FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_APPLIED_POLICIES, true));
        this.registerEvaluator(CMISScope.FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_REMOVE_POLICY, false));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_CHILDREN, "ReadChildren"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CREATE_DOCUMENT, "CreateChildren"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CREATE_FOLDER, "CreateChildren"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_CREATE_RELATIONSHIP, "CreateAssociations"));
        this.registerEvaluator(CMISScope.FOLDER, new RootActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_TREE, "DeleteNode"), false));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_ACL, "ReadPermissions"));
        this.registerEvaluator(CMISScope.FOLDER, new PermissionActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_ACL, "ChangePermissions"));
        this.registerEvaluator(CMISScope.RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_OBJECT, true));
        this.registerEvaluator(CMISScope.RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_UPDATE_PROPERTIES, false));
        this.registerEvaluator(CMISScope.RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_PROPERTIES, true));
        this.registerEvaluator(CMISScope.RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_ACL, false));
        this.registerEvaluator(CMISScope.RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_ACL, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_DELETE_OBJECT, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_UPDATE_PROPERTIES, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_PROPERTIES, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_PARENTS, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_MOVE_OBJECT, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_ADD_OBJECT_TO_FOLDER, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_REMOVE_OBJECT_FROM_FOLDER, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_OBJECT_RELATIONSHIPS, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_GET_ACL, false));
        this.registerEvaluator(CMISScope.POLICY, new FixedValueActionEvaluator(this.serviceRegistry, CMISAllowedActionEnum.CAN_APPLY_ACL, false));
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setCMISService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    NamespaceService getNamespaceService() {
        return this.serviceRegistry.getNamespaceService();
    }

    public CMISTypeId getCmisTypeId(String typeId) {
        if (typeId.equalsIgnoreCase(CMISDictionaryModel.DOCUMENT_TYPE_ID.getId())) {
            return CMISDictionaryModel.DOCUMENT_TYPE_ID;
        }
        if (typeId.equalsIgnoreCase(CMISDictionaryModel.FOLDER_TYPE_ID.getId())) {
            return CMISDictionaryModel.FOLDER_TYPE_ID;
        }
        if (typeId.equalsIgnoreCase(CMISDictionaryModel.RELATIONSHIP_TYPE_ID.getId())) {
            return CMISDictionaryModel.RELATIONSHIP_TYPE_ID;
        }
        if (typeId.equalsIgnoreCase(CMISDictionaryModel.POLICY_TYPE_ID.getId())) {
            return CMISDictionaryModel.POLICY_TYPE_ID;
        }
        if (typeId.equalsIgnoreCase(OBJECT_TYPE_ID.getId())) {
            return OBJECT_TYPE_ID;
        }
        if (typeId.equalsIgnoreCase(FILESYSTEM_OBJECT_TYPE_ID.getId())) {
            return FILESYSTEM_OBJECT_TYPE_ID;
        }
        if (typeId.length() < 4 || typeId.charAt(1) != ':') {
            throw new AlfrescoRuntimeException("Malformed type id '" + typeId + "'");
        }
        CMISScope scope = (CMISScope)CMISScope.FACTORY.fromLabel(typeId.substring(0, 1));
        if (scope == null) {
            throw new AlfrescoRuntimeException("Malformed type id '" + typeId + "'; discriminator " + typeId.charAt(0) + " unknown");
        }
        QName typeQName = QName.createQName((String)typeId.substring(2), (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
        return new CMISTypeId(scope, typeQName, typeId, typeQName);
    }

    public CMISTypeId getCmisTypeId(CMISScope scope, QName typeQName) {
        CMISTypeId typeId = this.mapAlfrescoQNameToTypeId.get(typeQName);
        if (typeId == null) {
            String typeIdStr = scope.getLabel() + ":" + typeQName.toPrefixString((NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
            return new CMISTypeId(scope, typeQName, typeIdStr, typeQName);
        }
        return typeId;
    }

    public CMISTypeId getCmisTypeId(QName classQName) {
        if (classQName.equals((Object)ContentModel.TYPE_CONTENT)) {
            return this.getCmisTypeId(CMISScope.DOCUMENT, classQName);
        }
        if (classQName.equals((Object)ContentModel.TYPE_FOLDER)) {
            return this.getCmisTypeId(CMISScope.FOLDER, classQName);
        }
        if (classQName.equals((Object)RELATIONSHIP_QNAME)) {
            return this.getCmisTypeId(CMISScope.RELATIONSHIP, classQName);
        }
        if (classQName.equals((Object)POLICY_QNAME)) {
            return this.getCmisTypeId(CMISScope.POLICY, classQName);
        }
        if (classQName.equals((Object)OBJECT_QNAME)) {
            return this.getCmisTypeId(CMISScope.OBJECT, classQName);
        }
        if (classQName.equals((Object)FILESYSTEM_OBJECT_QNAME)) {
            return this.getCmisTypeId(CMISScope.OBJECT, classQName);
        }
        if (this.isValidCmisDocument(classQName)) {
            return this.getCmisTypeId(CMISScope.DOCUMENT, classQName);
        }
        if (this.isValidCmisFolder(classQName)) {
            return this.getCmisTypeId(CMISScope.FOLDER, classQName);
        }
        if (this.isValidCmisPolicy(classQName)) {
            return this.getCmisTypeId(CMISScope.POLICY, classQName);
        }
        if (this.isValidCmisRelationship(classQName)) {
            return this.getCmisTypeId(CMISScope.RELATIONSHIP, classQName);
        }
        return null;
    }

    public String buildPrefixEncodedString(QName qname) {
        return qname.toPrefixString((NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
    }

    public boolean isValidCmisDocumentOrFolder(QName typeQName) {
        return this.isValidCmisFolder(typeQName) || this.isValidCmisDocument(typeQName);
    }

    public boolean isValidCmisFolder(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals((Object)FOLDER_QNAME)) {
            return true;
        }
        if (this.serviceRegistry.getDictionaryService().isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            return !typeQName.equals((Object)ContentModel.TYPE_FOLDER);
        }
        return false;
    }

    public boolean isValidCmisDocument(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals((Object)DOCUMENT_QNAME)) {
            return true;
        }
        if (this.serviceRegistry.getDictionaryService().isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            return !typeQName.equals((Object)ContentModel.TYPE_CONTENT);
        }
        return false;
    }

    public boolean isValidCmisPolicy(QName typeQName) {
        if (typeQName == null) {
            return false;
        }
        if (typeQName.equals((Object)POLICY_QNAME)) {
            return true;
        }
        AspectDefinition aspectDef = this.serviceRegistry.getDictionaryService().getAspect(typeQName);
        if (aspectDef == null) {
            return false;
        }
        return !aspectDef.getName().equals((Object)ContentModel.ASPECT_VERSIONABLE) && !aspectDef.getName().equals((Object)ContentModel.ASPECT_AUDITABLE) && !aspectDef.getName().equals((Object)ContentModel.ASPECT_REFERENCEABLE);
    }

    public boolean isValidCmisRelationship(QName associationQName) {
        if (associationQName == null) {
            return false;
        }
        if (associationQName.equals((Object)RELATIONSHIP_QNAME)) {
            return true;
        }
        AssociationDefinition associationDefinition = this.serviceRegistry.getDictionaryService().getAssociation(associationQName);
        if (associationDefinition == null) {
            return false;
        }
        return !associationDefinition.isChild();
    }

    public QName getCmisType(QName typeQName) {
        QName mapped = this.mapAlfrescoQNameToCmisQName.get(typeQName);
        if (mapped != null) {
            return mapped;
        }
        return typeQName;
    }

    public boolean isRemappedType(QName typeQName) {
        return this.mapAlfrescoQNameToCmisQName.containsKey(typeQName);
    }

    public QName getAlfrescoType(QName cmisTypeQName) {
        QName mapped = this.mapCmisQNameToAlfrescoQName.get(cmisTypeQName);
        if (mapped != null) {
            return mapped;
        }
        return cmisTypeQName;
    }

    public CMISDataTypeEnum getDataType(DataTypeDefinition datatype) {
        return this.getDataType(datatype.getName());
    }

    public CMISDataTypeEnum getDataType(QName dataType) {
        return this.mapAlfrescoToCmisDataType.get(dataType);
    }

    public QName getPropertyQName(String cmisPropertyName) {
        QName cmisPropertyQName = QName.createQName((String)CMIS_MODEL_URI, (String)cmisPropertyName);
        if (this.serviceRegistry.getDictionaryService().getProperty(cmisPropertyQName) != null) {
            return cmisPropertyQName;
        }
        int split = cmisPropertyName.indexOf(95);
        if (split == -1) {
            for (QName qname : this.serviceRegistry.getDictionaryService().getAllProperties(null)) {
                if (!qname.getNamespaceURI().equals(CMIS_MODEL_URI) || !qname.getLocalName().equalsIgnoreCase(cmisPropertyName)) continue;
                return qname;
            }
            return null;
        }
        String prefix = cmisPropertyName.substring(0, split);
        String localName = cmisPropertyName.substring(split + 1);
        QName propertyQName = QName.createQName((String)prefix.toLowerCase(), (String)localName.toLowerCase(), (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
        if (this.serviceRegistry.getDictionaryService().getProperty(propertyQName) != null) {
            return propertyQName;
        }
        for (String test : this.serviceRegistry.getNamespaceService().getPrefixes()) {
            if (!test.equalsIgnoreCase(prefix)) continue;
            prefix = test;
            break;
        }
        String uri = this.serviceRegistry.getNamespaceService().getNamespaceURI(prefix);
        for (QName qname : this.serviceRegistry.getDictionaryService().getAllProperties(null)) {
            if (!qname.getNamespaceURI().equals(uri) || !qname.getLocalName().equalsIgnoreCase(localName)) continue;
            return qname;
        }
        return null;
    }

    public String getCmisPropertyId(QName propertyQName) {
        return propertyQName.toPrefixString((NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
    }

    public AbstractProperty getPropertyAccessor(CMISPropertyId propertyId) {
        AbstractProperty propertyAccessor = this.propertyAccessors.get(propertyId.getId());
        if (propertyAccessor == null) {
            QName propertyQName = propertyId.getQName();
            if (propertyQName == null) {
                throw new AlfrescoRuntimeException("Can't get property accessor for property id " + propertyId.getId() + " due to unknown property QName");
            }
            propertyAccessor = new DirectProperty(this.serviceRegistry, propertyId.getId(), propertyQName);
        }
        return propertyAccessor;
    }

    private void registerPropertyAccessor(AbstractProperty propertyAccessor) {
        this.propertyAccessors.put(propertyAccessor.getName(), propertyAccessor);
    }

    public Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>> getActionEvaluators(CMISScope scope) {
        Map<CMISAllowedActionEnum, CMISActionEvaluator<Object>> evaluators = this.actionEvaluators.get((Object)scope);
        if (evaluators == null) {
            evaluators = Collections.emptyMap();
        }
        return evaluators;
    }

    private void registerEvaluator(CMISScope scope, CMISActionEvaluator<? extends Object> evaluator) {
        Map<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>> evaluators = this.actionEvaluators.get((Object)scope);
        if (evaluators == null) {
            evaluators = new LinkedHashMap<CMISAllowedActionEnum, CMISActionEvaluator<? extends Object>>();
            this.actionEvaluators.put(scope, evaluators);
        }
        if (evaluators.get((Object)evaluator.getAction()) != null) {
            throw new AlfrescoRuntimeException("Already registered Action Evaluator " + (Object)((Object)evaluator.getAction()) + " for scope " + (Object)((Object)scope));
        }
        evaluators.put(evaluator.getAction(), evaluator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered Action Evaluator: scope=" + (Object)((Object)scope) + ", evaluator=" + evaluator));
        }
    }

    public Collection<Pair<String, Boolean>> getReportedPermissions(String permission, Set<String> permissions, boolean hasFull, boolean isDirect, CMISAccessControlFormatEnum format) {
        ArrayList<Pair<String, Boolean>> answer = new ArrayList<Pair<String, Boolean>>(20);
        if (hasFull) {
            answer.add(new Pair((Object)"cmis:read", (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:all", (Object)false));
        }
        for (String perm : permissions) {
            if ("Read".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:read", (Object)false));
            } else if ("Write".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)false));
            } else if ("All".equals(perm)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:read", (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:all", (Object)false));
            }
            if (!hasFull) continue;
            answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:read", (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)false));
            answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:all", (Object)false));
        }
        if (format == CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS) {
            if ("Read".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:read", (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else if ("Write".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else if ("All".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:all", (Object)false));
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            } else {
                answer.add((Pair<String, Boolean>)new Pair((Object)permission, (Object)isDirect));
            }
        } else if (format == CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS) {
            if ("Read".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:read", (Object)isDirect));
            } else if ("Write".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:write", (Object)isDirect));
            } else if ("All".equals(permission)) {
                answer.add((Pair<String, Boolean>)new Pair((Object)"cmis:all", (Object)isDirect));
            }
        }
        return answer;
    }

    public String getSetPermission(String permission) {
        if (permission.equals("cmis:read")) {
            return "Read";
        }
        if (permission.equals("cmis:write")) {
            return "Write";
        }
        if (permission.equals("cmis:all")) {
            return "All";
        }
        return permission;
    }
}

