/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.mapping.BaseCMISTest;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionType;

public class CMISPropertyServiceTest
extends BaseCMISTest {
    public void testBasicFolder() throws Exception {
        NodeRef folder = this.fileFolderService.create(this.cmisService.getDefaultRootNodeRef(), "BaseFolder", ContentModel.TYPE_FOLDER).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(folder);
        CMISPropertyServiceTest.assertEquals((Object)folder.toString(), (Object)properties.get("cmis:objectId"));
        CMISPropertyServiceTest.assertEquals((Object)CMISDictionaryModel.FOLDER_TYPE_ID.getId(), (Object)properties.get("cmis:objectTypeId"));
        CMISPropertyServiceTest.assertEquals((Object)CMISDictionaryModel.FOLDER_TYPE_ID.getId(), (Object)properties.get("cmis:baseTypeId"));
        CMISPropertyServiceTest.assertEquals((Object)this.authenticationComponent.getCurrentUserName(), (Object)properties.get("cmis:createdBy"));
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)this.authenticationComponent.getCurrentUserName(), (Object)properties.get("cmis:lastModifiedBy"));
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)"BaseFolder", (Object)properties.get("cmis:name"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:isImmutable"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:isLatestVersion"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:isMajorVersion"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:isLatestMajorVersion"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:versionSeriesId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:isVersionSeriesCheckedOut"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:versionSeriesCheckedOutBy"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:versionSeriesCheckedOutId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:checkinComment"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:contentStreamLength"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:contentStreamMimeType"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:contentStreamFileName"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:contentStreamId"));
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getDefaultRootNodeRef().toString(), (Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
    }

    public void testBasicDocument() throws Exception {
        NodeRef content = this.fileFolderService.create(this.rootNodeRef, "BaseContent", ContentModel.TYPE_CONTENT).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
    }

    public void testContentProperties() throws Exception {
        NodeRef content = this.fileFolderService.create(this.rootNodeRef, "BaseContent", ContentModel.TYPE_CONTENT).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        ContentData contentData = new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK);
        this.nodeService.setProperty(content, ContentModel.PROP_CONTENT, (Serializable)contentData);
        ContentWriter writer = this.serviceRegistry.getContentService().getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent("The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
        long size = writer.getSize();
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)size);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"text/plain");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:contentStreamId"));
    }

    public void testLock() throws Exception {
        NodeRef content = this.fileFolderService.create(this.rootNodeRef, "BaseContent", ContentModel.TYPE_CONTENT).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        this.serviceRegistry.getLockService().lock(content, LockType.READ_ONLY_LOCK);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        this.serviceRegistry.getLockService().unlock(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
    }

    public void testCheckOut() throws Exception {
        NodeRef content = this.fileFolderService.create(this.rootNodeRef, "BaseContent", ContentModel.TYPE_CONTENT).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        NodeRef pwc = this.serviceRegistry.getCheckOutCheckInService().checkout(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        properties = this.cmisService.getProperties(pwc);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        this.serviceRegistry.getCheckOutCheckInService().cancelCheckout(pwc);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        pwc = this.serviceRegistry.getCheckOutCheckInService().checkout(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        properties = this.cmisService.getProperties(pwc);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        this.serviceRegistry.getCheckOutCheckInService().checkin(pwc, null);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
    }

    public void testVersioning() throws Exception {
        NodeRef content = this.fileFolderService.create(this.rootNodeRef, "BaseContent", ContentModel.TYPE_CONTENT).getNodeRef();
        Map<String, Serializable> properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        this.nodeService.addAspect(content, ContentModel.ASPECT_VERSIONABLE, null);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        NodeRef pwc = this.serviceRegistry.getCheckOutCheckInService().checkout(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        properties = this.cmisService.getProperties(pwc);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        this.serviceRegistry.getCheckOutCheckInService().cancelCheckout(pwc);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        pwc = this.serviceRegistry.getCheckOutCheckInService().checkout(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        properties = this.cmisService.getProperties(pwc);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"Meep"));
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        this.serviceRegistry.getCheckOutCheckInService().checkin(pwc, versionProperties);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionLabel"), (Object)"1.0");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        pwc = this.serviceRegistry.getCheckOutCheckInService().checkout(content);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionLabel"), (Object)"1.0");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        properties = this.cmisService.getProperties(pwc);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:versionLabel"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), (Object)pwc.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:checkinComment"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent (Working Copy)");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
        versionProperties = new HashMap();
        versionProperties.put("description", (Serializable)((Object)"Woof"));
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
        this.serviceRegistry.getCheckOutCheckInService().checkin(pwc, versionProperties);
        properties = this.cmisService.getProperties(content);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:objectTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:baseTypeId"), (Object)CMISDictionaryModel.DOCUMENT_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)properties.get("cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:name"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isImmutable"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestVersion"), (Object)true);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isLatestMajorVersion"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionLabel"), (Object)"1.1");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesId"), (Object)content.toString());
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:isVersionSeriesCheckedOut"), (Object)false);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutBy"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:versionSeriesCheckedOutId"), null);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamLength"), (Object)0L);
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamMimeType"), (Object)"");
        CMISPropertyServiceTest.assertEquals((Object)properties.get("cmis:contentStreamFileName"), (Object)"BaseContent");
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:parentId"));
        CMISPropertyServiceTest.assertNull((Object)properties.get("cmis:allowedChildObjectTypeIds"));
    }

    public void testSinglePropertyFolderAccess() throws Exception {
        NodeRef folder = this.fileFolderService.create(this.rootNodeRef, "BaseFolder", ContentModel.TYPE_FOLDER).getNodeRef();
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:objectId"), (Object)folder.toString());
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:objectTypeId"), (Object)CMISDictionaryModel.FOLDER_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:baseTypeId"), (Object)CMISDictionaryModel.FOLDER_TYPE_ID.getId());
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:createdBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)this.cmisService.getProperty(folder, "cmis:creationDate"));
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:lastModifiedBy"), (Object)this.authenticationComponent.getCurrentUserName());
        CMISPropertyServiceTest.assertNotNull((Object)this.cmisService.getProperty(folder, "cmis:lastModificationDate"));
        CMISPropertyServiceTest.assertNull((Object)this.cmisService.getProperty(folder, "cmis:changeToken"));
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:name"), (Object)"BaseFolder");
        try {
            this.cmisService.getProperty(folder, "cmis:isImmutable");
            this.cmisService.getProperty(folder, "cmis:isLatestVersion");
            this.cmisService.getProperty(folder, "cmis:isMajorVersion");
            this.cmisService.getProperty(folder, "cmis:isLatestMajorVersion");
            this.cmisService.getProperty(folder, "cmis:versionLabel");
            this.cmisService.getProperty(folder, "cmis:versionSeriesId");
            this.cmisService.getProperty(folder, "cmis:isVersionSeriesCheckedOut");
            this.cmisService.getProperty(folder, "cmis:versionSeriesCheckedOutBy");
            this.cmisService.getProperty(folder, "cmis:versionSeriesCheckedOutId");
            this.cmisService.getProperty(folder, "cmis:checkinComment");
            this.cmisService.getProperty(folder, "cmis:contentStreamLength");
            this.cmisService.getProperty(folder, "cmis:contentStreamMimeType");
            this.cmisService.getProperty(folder, "cmis:contentStreamFileName");
            this.cmisService.getProperty(folder, "cmis:contentStreamId");
            CMISPropertyServiceTest.fail((String)"Failed to catch invalid property on type folder");
        }
        catch (CMISInvalidArgumentException cMISInvalidArgumentException) {
            // empty catch block
        }
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:parentId"), (Object)this.rootNodeRef.toString());
        CMISPropertyServiceTest.assertNull((Object)this.cmisService.getProperty(folder, "cmis:allowedChildObjectTypeIds"));
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:name".toUpperCase()), (Object)"BaseFolder");
        CMISPropertyServiceTest.assertEquals((Object)this.cmisService.getProperty(folder, "cmis:name".toLowerCase()), (Object)"BaseFolder");
    }
}

