/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.encryption.AlfrescoKeyStoreImpl;
import org.alfresco.encryption.DefaultEncryptor;
import org.alfresco.encryption.EncryptionKeysRegistryImpl;
import org.alfresco.encryption.InvalidKeystoreException;
import org.alfresco.encryption.KeyMap;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreChecker;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.KeystoreKeyProvider;
import org.alfresco.encryption.MissingKeyException;
import org.alfresco.encryption.ReEncryptor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionTests
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/encryption/reencryption_model.xml";
    private static int NUM_PROPERTIES = 500;
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static QName NODE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/reencryption_test/1.0", (String)"base");
    private static QName PROP = QName.createQName((String)"http://www.alfresco.org/test/reencryption_test/1.0", (String)"prop1");
    private NodeRef rootNodeRef;
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private MetadataEncryptor metadataEncryptor;
    private ReEncryptor reEncryptor;
    private String cipherAlgorithm = "DESede/CBC/PKCS5Padding";
    private KeyStoreParameters backupKeyStoreParameters;
    private AlfrescoKeyStoreImpl mainKeyStore;
    private KeyResourceLoader keyResourceLoader;
    private EncryptionKeysRegistryImpl encryptionKeysRegistry;
    private KeyStoreChecker keyStoreChecker;
    private DefaultEncryptor mainEncryptor;
    private DefaultEncryptor backupEncryptor;
    private AuthenticationComponent authenticationComponent;
    private DictionaryDAO dictionaryDAO;
    private TenantService tenantService;
    private String keyAlgorithm;
    private KeyMap newKeys = new KeyMap();
    private List<NodeRef> before = new ArrayList<NodeRef>();
    private List<NodeRef> after = new ArrayList<NodeRef>();
    private UserTransaction tx;

    public void setUp() throws Exception {
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.metadataEncryptor = (MetadataEncryptor)ctx.getBean("metadataEncryptor");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.keyResourceLoader = (KeyResourceLoader)ctx.getBean("springKeyResourceLoader");
        this.reEncryptor = (ReEncryptor)ctx.getBean("reEncryptor");
        this.backupKeyStoreParameters = (KeyStoreParameters)ctx.getBean("backupKeyStoreParameters");
        this.keyStoreChecker = (KeyStoreChecker)ctx.getBean("keyStoreChecker");
        this.encryptionKeysRegistry = (EncryptionKeysRegistryImpl)ctx.getBean("encryptionKeysRegistry");
        this.mainKeyStore = (AlfrescoKeyStoreImpl)ctx.getBean("keyStore");
        this.mainEncryptor = (DefaultEncryptor)ctx.getBean("mainEncryptor");
        this.backupEncryptor = (DefaultEncryptor)ctx.getBean("backupEncryptor");
        this.reEncryptor.setSplitTxns(false);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.tx = this.transactionService.getUserTransaction();
        this.tx.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "ReEncryptor_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.keyAlgorithm = "DESede";
        this.newKeys.setKey("metadata", this.generateSecretKey(this.keyAlgorithm));
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTenantService(this.tenantService);
        bootstrap.bootstrap();
    }

    protected KeyProvider getKeyProvider(KeyStoreParameters keyStoreParameters) {
        KeystoreKeyProvider backupKeyProvider = new KeystoreKeyProvider(keyStoreParameters, this.keyResourceLoader);
        return backupKeyProvider;
    }

    public void setBackupKeyStoreParameters(KeyStoreParameters backupKeyStoreParameters) {
        this.backupKeyStoreParameters = backupKeyStoreParameters;
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    protected KeyProvider getKeyProvider(final KeyMap keys) {
        KeyProvider keyProvider = new KeyProvider(){

            public Key getKey(String keyAlias) {
                return keys.getCachedKey(keyAlias).getKey();
            }
        };
        return keyProvider;
    }

    protected void createEncryptedProperties(List<NodeRef> nodes) {
        for (int i = 0; i < NUM_PROPERTIES; ++i) {
            NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"assoc1"), NODE_TYPE).getChildRef();
            nodes.add(nodeRef);
            Map<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(PROP, (Serializable)((Object)nodeRef.toString()));
            props = this.metadataEncryptor.encrypt(props);
            this.nodeService.setProperties(nodeRef, props);
        }
    }

    public byte[] generateKeyData() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(System.currentTimeMillis());
        byte[] bytes = new byte[24];
        random.nextBytes(bytes);
        return bytes;
    }

    protected Key generateSecretKey(String keyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        DESedeKeySpec keySpec = new DESedeKeySpec(this.generateKeyData());
        SecretKeyFactory kf = SecretKeyFactory.getInstance(keyAlgorithm);
        SecretKey secretKey = kf.generateSecret(keySpec);
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReEncrypt() {
        KeyProvider backupKeyProvider = this.backupEncryptor.getKeyProvider();
        KeyProvider mainKeyProvider = this.mainEncryptor.getKeyProvider();
        try {
            Map<QName, Serializable> props;
            this.createEncryptedProperties(this.before);
            KeyProvider newKeyProvider = this.getKeyProvider(this.newKeys);
            this.backupEncryptor.setKeyProvider(this.mainEncryptor.getKeyProvider());
            this.mainEncryptor.setKeyProvider(newKeyProvider);
            this.createEncryptedProperties(this.after);
            long start = System.currentTimeMillis();
            System.out.println(this.reEncryptor.reEncrypt() + " properties re-encrypted");
            System.out.println("Re-encrypted " + NUM_PROPERTIES * 2 + " properties in " + (System.currentTimeMillis() - start) + "ms");
            for (NodeRef nodeRef : this.before) {
                props = this.nodeService.getProperties(nodeRef);
                props = this.metadataEncryptor.decrypt(props);
                EncryptionTests.assertNotNull((String)"", props.get(PROP));
                EncryptionTests.assertEquals((String)"", (Object)nodeRef.toString(), (Object)props.get(PROP));
            }
            for (NodeRef nodeRef : this.after) {
                props = this.nodeService.getProperties(nodeRef);
                props = this.metadataEncryptor.decrypt(props);
                EncryptionTests.assertNotNull((String)"", (Object)props.get(PROP));
                EncryptionTests.assertEquals((String)"", (Object)nodeRef.toString(), (Object)props.get(PROP));
            }
        }
        catch (MissingKeyException e) {
            EncryptionTests.fail((String)e.getMessage());
        }
        catch (AlfrescoRuntimeException e) {
            if (e.getCause() instanceof InvalidKeyException) {
                e.printStackTrace();
                EncryptionTests.fail();
            }
        }
        finally {
            this.backupEncryptor.setKeyProvider(backupKeyProvider);
            this.mainEncryptor.setKeyProvider(mainKeyProvider);
        }
    }

    public void testBootstrapReEncrypt() {
        try {
            this.backupKeyStoreParameters.setLocation("");
            this.mainKeyStore.reload();
            this.reEncryptor.bootstrapReEncrypt();
            EncryptionTests.fail((String)"Should have caught missing backup key store");
        }
        catch (MissingKeyException e) {
            System.out.println("Successfully caught missing key exception");
        }
        catch (InvalidKeystoreException e) {
            EncryptionTests.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    protected void testChangeKeysImpl(boolean cacheCiphers) throws Throwable {
        Pair pair = null;
        DefaultEncryptor encryptor = null;
        Key secretKey1 = null;
        Key secretKey2 = null;
        String test = "hello world";
        final KeyMap keys = new KeyMap();
        byte[] decrypted = null;
        String test1 = null;
        secretKey1 = this.generateSecretKey("DESede");
        keys.setKey("test", secretKey1);
        KeyProvider keyProvider = new KeyProvider(){

            public Key getKey(String keyAlias) {
                return keys.getCachedKey(keyAlias).getKey();
            }
        };
        encryptor = new DefaultEncryptor();
        encryptor.setCipherAlgorithm("DESede/CBC/PKCS5Padding");
        encryptor.setCipherProvider(null);
        encryptor.setKeyProvider(keyProvider);
        encryptor.setCacheCiphers(cacheCiphers);
        pair = encryptor.encrypt("test", null, test.getBytes("UTF-8"));
        decrypted = encryptor.decrypt("test", (AlgorithmParameters)pair.getSecond(), (byte[])pair.getFirst());
        test1 = new String(decrypted, "UTF-8");
        EncryptionTests.assertEquals((String)"Expected encrypt,decrypt to end up with the original value", (String)test, (String)test1);
        System.out.println("1:" + new String(decrypted, "UTF-8"));
        secretKey2 = this.generateSecretKey("DESede");
        keys.setKey("test", secretKey2);
        EncryptionTests.assertNotNull((Object)encryptor);
        EncryptionTests.assertNotNull((Object)pair);
        try {
            decrypted = encryptor.decrypt("test", (AlgorithmParameters)pair.getSecond(), (byte[])pair.getFirst());
            test1 = new String(decrypted, "UTF-8");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
    }

    public void testChangeKeys() throws Throwable {
        this.testChangeKeysImpl(false);
    }

    public void testChangeKeysCachedCiphers() throws Throwable {
        this.testChangeKeysImpl(true);
    }

    public void testFailedEncryptionWithCachedCiphers() throws Throwable {
        Pair pair = null;
        DefaultEncryptor encryptor = null;
        Key secretKey1 = null;
        Key secretKey2 = null;
        String test = "hello world";
        final KeyMap keys = new KeyMap();
        byte[] decrypted = null;
        String test1 = null;
        secretKey1 = this.generateSecretKey("DESede");
        keys.setKey("test", secretKey1);
        KeyProvider keyProvider = new KeyProvider(){

            public Key getKey(String keyAlias) {
                return keys.getCachedKey(keyAlias).getKey();
            }
        };
        encryptor = new DefaultEncryptor();
        encryptor.setCipherAlgorithm("DESede/CBC/PKCS5Padding");
        encryptor.setCipherProvider(null);
        encryptor.setKeyProvider(keyProvider);
        encryptor.setCacheCiphers(true);
        pair = encryptor.encrypt("test", null, test.getBytes("UTF-8"));
        secretKey2 = this.generateSecretKey("DESede");
        keys.setKey("test", secretKey2);
        EncryptionTests.assertNotNull((Object)encryptor);
        EncryptionTests.assertNotNull((Object)pair);
        try {
            decrypted = encryptor.decrypt("test", (AlgorithmParameters)pair.getSecond(), (byte[])pair.getFirst());
            test1 = new String(decrypted, "UTF-8");
            EncryptionTests.fail((String)"Decryption should have failed");
        }
        catch (AlfrescoRuntimeException e) {
            // empty catch block
        }
        keys.setKey("test", secretKey1);
        try {
            decrypted = encryptor.decrypt("test", (AlgorithmParameters)pair.getSecond(), (byte[])pair.getFirst());
            test1 = new String(decrypted, "UTF-8");
        }
        catch (AlfrescoRuntimeException e) {
            EncryptionTests.fail((String)"Expected decryption to work ok");
        }
    }
}

