/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.config.ServerConfigurationBean;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

public class MultiTenantShareMapper
implements ShareMapper,
ConfigurationListener,
InitializingBean {
    private ServerConfiguration m_config;
    private FilesystemsConfigSection m_filesysConfig;
    private AlfrescoConfigSection m_alfrescoConfig;
    private String m_tenantShareName;
    private String m_rootPath;
    private String m_storeName;
    private Hashtable<String, SharedDeviceList> m_tenantShareLists;
    private QuotaManager m_quotaManager;
    private boolean m_debug;

    public void setServerConfiguration(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setTenantShareName(String shareName) {
        this.m_tenantShareName = shareName;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.m_quotaManager = quotaManager;
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setServerConfiguration(config);
        ConfigElement tenantShareName = params.getChild("TenantShareName");
        if (tenantShareName != null) {
            if (tenantShareName.getValue() != null && tenantShareName.getValue().length() > 0) {
                this.setTenantShareName(tenantShareName.getValue());
            } else {
                throw new InvalidConfigurationException("Invalid tenant share name");
            }
        }
        if (params.getChild("debug") != null) {
            this.setDebug(true);
        }
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        this.m_alfrescoConfig = (AlfrescoConfigSection)this.m_config.getConfigSection("Alfresco");
        if (this.m_filesysConfig == null || this.m_alfrescoConfig == null) {
            this.m_config.addListener((ConfigurationListener)this);
        }
        if (this.m_filesysConfig != null) {
            this.findContentShareDetails();
        }
        this.m_tenantShareLists = new Hashtable();
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public SharedDevice findShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        if (this.m_alfrescoConfig.getTenantService().isEnabled() && this.m_alfrescoConfig.getTenantService().isTenantUser() && typ != 3) {
            return this.findTenantShare(host, name, typ, sess, create);
        }
        SharedDevice share = this.m_filesysConfig.getShares().findShare(name, typ, false);
        if (share == null) {
            share = this.m_filesysConfig.getShares().findShare(name, typ, true);
        }
        if (share != null && share.getContext() != null && !share.getContext().isAvailable()) {
            share = null;
        }
        return share;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
            if (!this.hasDebug()) continue;
            Debug.println((String)("Deleted dynamic share " + shr));
        }
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (this.m_filesysConfig == null) {
            return null;
        }
        if (this.m_alfrescoConfig.getTenantService().isEnabled() && this.m_alfrescoConfig.getTenantService().isTenantUser()) {
            return this.getTenantShareList(host, sess, allShares);
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    public void closeMapper() {
    }

    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        if (id == 0x10000001) {
            if (newVal instanceof FilesystemsConfigSection) {
                this.m_filesysConfig = (FilesystemsConfigSection)newVal;
            } else if (newVal instanceof AlfrescoConfigSection) {
                this.m_alfrescoConfig = (AlfrescoConfigSection)((Object)newVal);
            }
            return 1;
        }
        if (this.m_rootPath == null) {
            this.findContentShareDetails();
        }
        return 0;
    }

    private final SharedDevice findTenantShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDeviceList shareList = this.getTenantShareList(host, sess, true);
        if (shareList == null) {
            return null;
        }
        return shareList.findShare(name, typ, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SharedDeviceList getTenantShareList(String host, SrvSession sess, boolean allShares) {
        String tenantDomain = this.m_alfrescoConfig.getTenantService().getCurrentUserDomain();
        SharedDeviceList shareList = null;
        Hashtable<String, SharedDeviceList> hashtable = this.m_tenantShareLists;
        synchronized (hashtable) {
            shareList = this.m_tenantShareLists.get(tenantDomain);
            if (shareList == null) {
                shareList = new SharedDeviceList();
                shareList.addShare((SharedDevice)this.createTenantShare());
                this.m_tenantShareLists.put(tenantDomain, shareList);
            }
        }
        return shareList;
    }

    private final DiskSharedDevice createTenantShare() {
        StoreRef storeRef = new StoreRef(this.m_storeName);
        NodeRef rootNodeRef = new NodeRef(storeRef.getProtocol(), storeRef.getIdentifier(), "dummy");
        rootNodeRef = this.m_alfrescoConfig.getTenantService().getRootNode(this.m_alfrescoConfig.getNodeService(), this.m_alfrescoConfig.getSearchService(), this.m_alfrescoConfig.getNamespaceService(), this.m_rootPath, rootNodeRef);
        DiskInterface diskDrv = this.m_alfrescoConfig.getRepoDiskInterface();
        ContentContext diskCtx = new ContentContext(this.m_tenantShareName, "", this.m_rootPath, rootNodeRef);
        if (this.m_quotaManager != null) {
            diskCtx.setQuotaManager(this.m_quotaManager);
        }
        if (!(this.m_config instanceof ServerConfigurationBean)) {
            throw new AlfrescoRuntimeException("configuration error, unknown configuration bean");
        }
        ServerConfigurationBean config = (ServerConfigurationBean)this.m_config;
        config.initialiseRuntimeContext(diskCtx);
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        return new DiskSharedDevice(this.m_tenantShareName, (DeviceInterface)diskDrv, (DiskDeviceContext)diskCtx);
    }

    private final void findContentShareDetails() {
        if (this.m_filesysConfig == null) {
            return;
        }
        SharedDeviceList shareList = this.m_filesysConfig.getShares();
        Enumeration shareEnum = shareList.enumerateShares();
        while (shareEnum.hasMoreElements()) {
            SharedDevice share = (SharedDevice)shareEnum.nextElement();
            if (!(share.getContext() instanceof ContentContext)) continue;
            ContentContext ctx = (ContentContext)share.getContext();
            this.m_rootPath = ctx.getRootPath();
            this.m_storeName = ctx.getStoreName();
            if (this.m_tenantShareName != null) continue;
            this.m_tenantShareName = ctx.getDeviceName();
        }
    }
}

