/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionTable;
import org.alfresco.filesys.alfresco.PseudoFileOverlay;
import org.alfresco.jlan.server.filesys.pseudo.MemoryPseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.util.WildCard;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PseudoFileOverlayImpl
implements PseudoFileOverlay {
    private SysAdminParams sysAdminParams;
    private AlfrescoContext context;
    private NodeService nodeService;
    private static final Log logger = LogFactory.getLog(PseudoFileOverlayImpl.class);
    PseudoFileList pl = new PseudoFileList();

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.getNodeService());
        PropertyCheck.mandatory((Object)this, (String)"context", (Object)((Object)this.context));
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
        DesktopActionTable actions = this.context.getDesktopActions();
        if (actions != null) {
            Enumeration<String> actionNames = actions.enumerateActionNames();
            while (actionNames.hasMoreElements()) {
                String name = actionNames.nextElement();
                DesktopAction action = actions.getAction(name);
                if (!action.hasPseudoFile()) continue;
                PseudoFile file = action.getPseudoFile();
                this.pl.addFile(file);
            }
        }
    }

    private PseudoFile generateAlfrescoURLShortcut(NodeRef nodeRef) {
        if (this.context.isAlfrescoURLEnabled()) {
            StringBuilder urlStr = new StringBuilder();
            urlStr.append("[InternetShortcut]\r\n");
            urlStr.append("URL=");
            urlStr.append(this.getAlfrescoURLPrefix());
            urlStr.append("navigate/browse/workspace/SpacesStore/");
            urlStr.append(nodeRef.getId());
            urlStr.append("\r\n");
            byte[] urlData = urlStr.toString().getBytes();
            MemoryPseudoFile urlFile = new MemoryPseudoFile(this.context.getURLFileName(), urlData);
            return urlFile;
        }
        return null;
    }

    private String getSiteForNode(NodeRef nodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get site for node:" + nodeRef));
        }
        boolean isInDocLibrary = false;
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        while (parent != null && !this.nodeService.getType(parent).equals((Object)SiteModel.TYPE_SITE)) {
            String parentName = (String)((Object)this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
            if (parentName.equalsIgnoreCase("documentlibrary")) {
                isInDocLibrary = true;
            }
            parent = this.nodeService.getPrimaryParent(parent).getParentRef();
        }
        if (parent == null) {
            logger.debug((Object)"folder is not in a site");
            return null;
        }
        if (isInDocLibrary && this.nodeService.getType(parent).equals((Object)SiteModel.TYPE_SITE)) {
            String siteName = (String)((Object)this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("got a site:" + siteName));
            }
            return siteName;
        }
        logger.debug((Object)"folder is not in doc library");
        return null;
    }

    private PseudoFile generateShareURLShortcut(NodeRef nodeRef) {
        String site;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generateShareURLShortcut nodeRef" + nodeRef));
        }
        if (this.context.isShareURLEnabled() && (site = this.getSiteForNode(nodeRef)) != null) {
            StringBuilder urlStr = new StringBuilder();
            urlStr.append("[InternetShortcut]\r\n");
            urlStr.append("URL=");
            urlStr.append(this.getShareURLPrefix());
            urlStr.append("page/site/");
            urlStr.append(site + "/folder-details?nodeRef=");
            urlStr.append(nodeRef.getStoreRef() + "/");
            urlStr.append(nodeRef.getId());
            urlStr.append("\r\n");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("generateShareURLShortcut url as string:" + urlStr));
            }
            byte[] urlData = urlStr.toString().getBytes();
            MemoryPseudoFile urlFile = new MemoryPseudoFile(this.context.getShareURLFileName(), urlData);
            return urlFile;
        }
        return null;
    }

    public boolean isPseudoFile(NodeRef parentDir, String name) {
        if (parentDir == null) {
            return false;
        }
        if (this.context.isAlfrescoURLEnabled() && this.context.getURLFileName().equals(name)) {
            return true;
        }
        if (this.context.isShareURLEnabled() && this.context.getShareURLFileName().equals(name)) {
            return true;
        }
        return this.getPseudoFile(parentDir, name) != null;
    }

    public PseudoFile getPseudoFile(NodeRef parentDir, String fname) {
        if (parentDir == null) {
            return null;
        }
        if (this.context.isAlfrescoURLEnabled() && this.context.getURLFileName().equals(fname)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"returning URL pseudo file");
            }
            return this.generateAlfrescoURLShortcut(parentDir);
        }
        if (this.context.isShareURLEnabled() && this.context.getShareURLFileName().equals(fname)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"returning Share URL pseudo file");
            }
            return this.generateShareURLShortcut(parentDir);
        }
        PseudoFile file = this.pl.findFile(fname, false);
        return file;
    }

    public PseudoFileList searchPseudoFiles(NodeRef parentDir, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchPseudoFile parentDir:" + parentDir + ", name:" + name));
        }
        if (parentDir == null || name == null || name.length() == 0 || name.equals("\\")) {
            return null;
        }
        String fname = name;
        if (fname.equals("*.*")) {
            fname = "*";
        }
        if (WildCard.containsWildcards((String)fname)) {
            PseudoFile sharePseudoFile;
            if (fname.equals("*")) {
                PseudoFile sharePseudoFile2;
                PseudoFileList filterList = new PseudoFileList();
                for (int i = 0; i < this.pl.numberOfFiles(); ++i) {
                    PseudoFile pseudoFile = this.pl.getFileAt(i);
                    filterList.addFile(pseudoFile);
                }
                if (this.context.isAlfrescoURLEnabled()) {
                    filterList.addFile(this.generateAlfrescoURLShortcut(parentDir));
                }
                if (this.context.isShareURLEnabled() && (sharePseudoFile2 = this.generateShareURLShortcut(parentDir)) != null) {
                    filterList.addFile(sharePseudoFile2);
                }
                return filterList;
            }
            WildCard wildCard = new WildCard(fname, false);
            PseudoFileList filterList = new PseudoFileList();
            for (int i = 0; i < this.pl.numberOfFiles(); ++i) {
                PseudoFile pseudoFile = this.pl.getFileAt(i);
                if (!wildCard.matchesPattern(pseudoFile.getFileName())) continue;
                filterList.addFile(pseudoFile);
            }
            if (this.context.isAlfrescoURLEnabled() && wildCard.matchesPattern(this.context.getURLFileName())) {
                filterList.addFile(this.generateAlfrescoURLShortcut(parentDir));
            }
            if (this.context.isShareURLEnabled() && wildCard.matchesPattern(this.context.getShareURLFileName()) && (sharePseudoFile = this.generateShareURLShortcut(parentDir)) != null) {
                filterList.addFile(sharePseudoFile);
            }
            return filterList;
        }
        PseudoFileList filterList = new PseudoFileList();
        PseudoFile file = this.getPseudoFile(parentDir, fname);
        if (file != null) {
            filterList.addFile(file);
        }
        return filterList;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setContext(AlfrescoContext context) {
        this.context = context;
    }

    public AlfrescoContext getContext() {
        return this.context;
    }

    private final String getAlfrescoURLPrefix() {
        return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext() + "/";
    }

    private final String getShareURLPrefix() {
        return this.sysAdminParams.getShareProtocol() + "://" + this.sysAdminParams.getShareHost() + ":" + this.sysAdminParams.getSharePort() + "/" + this.sysAdminParams.getShareContext() + "/";
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public SysAdminParams getSysAdminParams() {
        return this.sysAdminParams;
    }
}

