/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.IOControlHandler;
import org.alfresco.filesys.avm.AVMDiskDriver;
import org.alfresco.filesys.avm.VersionPseudoFile;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.util.StringList;
import org.alfresco.repo.avm.CreateStoreCallback;
import org.alfresco.repo.avm.CreateVersionCallback;
import org.alfresco.repo.avm.PurgeStoreCallback;
import org.alfresco.repo.avm.PurgeVersionCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMContext
extends AlfrescoContext
implements CreateStoreCallback,
PurgeStoreCallback,
CreateVersionCallback,
PurgeVersionCallback {
    private static final Log logger = LogFactory.getLog(AVMContext.class);
    public static final int VERSION_HEAD = -1;
    public static final int ShowNormalStores = 1;
    public static final int ShowSiteStores = 2;
    public static final int ShowStagingStores = 4;
    public static final int ShowAuthorStores = 8;
    public static final int ShowPreviewStores = 16;
    private String m_storePath;
    private int m_version = -1;
    private boolean m_virtualView;
    private int m_showOptions = 12;
    private StringList m_newStores;
    private Object m_newStoresLock;
    private boolean m_allowAdminStagingWrites;
    private boolean m_createStore;

    public AVMContext() {
    }

    public AVMContext(String filesysName, String storePath, int version) {
        this.setDeviceName(filesysName);
        this.setStorePath(storePath);
        this.setVersion(version);
    }

    public AVMContext(String filesysName, int showOptions, AVMDiskDriver avmDriver) {
        this.setDeviceName(filesysName);
        this.setVirtualView(true);
        this.setShowOptions(showOptions);
    }

    public void setStorePath(String path) {
        this.m_storePath = path;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public void setShowOptions(int showOptions) {
        this.m_showOptions = showOptions;
    }

    public void setStores(String showAttr) {
        if (showAttr != null) {
            StringTokenizer tokens = new StringTokenizer(showAttr, ",");
            StringList optList = new StringList();
            while (tokens.hasMoreTokens()) {
                optList.addString(tokens.nextToken().trim().toLowerCase());
            }
            this.m_showOptions = 0;
            if (optList.containsString("normal")) {
                ++this.m_showOptions;
            }
            if (optList.containsString("site")) {
                this.m_showOptions += 2;
            }
            if (optList.containsString("author")) {
                this.m_showOptions += 8;
            }
            if (optList.containsString("preview")) {
                this.m_showOptions += 16;
            }
            if (optList.containsString("staging")) {
                this.m_showOptions += 4;
            }
        }
    }

    public void setVirtualView(boolean isVirtualView) {
        this.m_virtualView = isVirtualView;
    }

    public boolean getCreateStore() {
        return this.m_createStore;
    }

    public void setCreateStore(boolean createStore) {
        this.m_createStore = createStore;
    }

    public void initialize(AlfrescoDiskDriver filesysDriver) {
        if (this.m_virtualView) {
            this.m_newStoresLock = new Object();
            this.m_newStores = new StringList();
            this.setShareName("VirtualView");
        } else {
            if (this.m_storePath == null || this.m_storePath.length() == 0) {
                throw new AlfrescoRuntimeException("Device missing init value: storePath");
            }
            if (this.m_storePath.endsWith("/")) {
                this.m_storePath = this.m_storePath.substring(0, this.m_storePath.length() - 1);
            }
            if (this.m_version < 0 && this.m_version != -1) {
                throw new AlfrescoRuntimeException("Invalid store version id specified, " + this.m_version);
            }
            this.setShareName(this.m_storePath + "(" + this.m_version + ")");
        }
        super.initialize(filesysDriver);
    }

    public String getFilesystemType() {
        return "NTFS";
    }

    public final String getStorePath() {
        return this.m_storePath;
    }

    public final int isVersion() {
        return this.m_version;
    }

    public final boolean isVirtualizationView() {
        return this.m_virtualView;
    }

    public final boolean allowAdminStagingWrites() {
        return this.m_allowAdminStagingWrites;
    }

    public final void setAllowAdminStagingWrites(boolean writeable) {
        this.m_allowAdminStagingWrites = writeable;
    }

    protected final boolean hasNewStoresQueued() {
        return this.m_newStores != null && this.m_newStores.numberOfStrings() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringList getNewStoresQueue() {
        StringList storesQueue = null;
        Object object = this.m_newStoresLock;
        synchronized (object) {
            storesQueue = this.m_newStores;
            this.m_newStores = new StringList();
        }
        return storesQueue;
    }

    public final boolean showNormalStores() {
        return (this.m_showOptions & 1) != 0;
    }

    public final boolean showSiteStores() {
        return (this.m_showOptions & 2) != 0;
    }

    public final boolean showAuthorStores() {
        return (this.m_showOptions & 8) != 0;
    }

    public final boolean showPreviewStores() {
        return (this.m_showOptions & 0x10) != 0;
    }

    public final boolean showStagingStores() {
        return (this.m_showOptions & 4) != 0;
    }

    public final boolean showStoreType(int storeType) {
        boolean showStore = false;
        switch (storeType) {
            case 0: {
                showStore = this.showNormalStores();
                break;
            }
            case 1: {
                showStore = this.showSiteStores();
                break;
            }
            case 2: {
                showStore = this.showAuthorStores();
                break;
            }
            case 5: {
                showStore = this.showStagingStores();
                break;
            }
            case 3: 
            case 4: {
                showStore = this.showPreviewStores();
            }
        }
        return showStore;
    }

    public void CloseContext() {
        super.CloseContext();
    }

    protected IOControlHandler createIOHandler(DiskInterface filesysDriver) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCreated(String storeName) {
        if (!this.isVirtualizationView()) {
            return;
        }
        FileStateCache fsTable = this.getStateCache();
        if (fsTable == null) {
            return;
        }
        FileState rootState = fsTable.findFileState("\\", true);
        if (rootState != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Queueing new store " + storeName + " for addition to virtualization view"));
            }
            Object object = this.m_newStoresLock;
            synchronized (object) {
                this.m_newStores.addString(storeName);
            }
        }
    }

    public void storePurged(String storeName) {
        if (!this.isVirtualizationView()) {
            return;
        }
        FileStateCache fsTable = this.getStateCache();
        if (fsTable == null) {
            return;
        }
        FileState rootState = fsTable.findFileState("\\");
        if (rootState != null && rootState.hasPseudoFiles()) {
            rootState.getPseudoFileList().removeFile(storeName, false);
            StringBuilder pathStr = new StringBuilder();
            pathStr.append('\\');
            pathStr.append(storeName);
            String storePath = pathStr.toString();
            fsTable.removeFileState(storePath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed pseudo folder for purged store " + storeName));
            }
            rootState.updateModifyDateTime();
            if (this.hasChangeHandler()) {
                this.getChangeHandler().notifyDirectoryChanged(2, storePath);
            }
        }
    }

    public void versionCreated(String storeName, int versionID) {
        if (!this.isVirtualizationView()) {
            return;
        }
        FileStateCache fsTable = this.getStateCache();
        if (fsTable == null) {
            return;
        }
        StringBuilder pathStr = new StringBuilder();
        pathStr.append('\\');
        pathStr.append(storeName);
        pathStr.append('\\');
        pathStr.append("VERSION");
        FileState verState = fsTable.findFileState(pathStr.toString());
        if (verState != null) {
            StringBuilder verStr = new StringBuilder();
            verStr.append("v");
            verStr.append(versionID);
            String verName = verStr.toString();
            pathStr.append('\\');
            pathStr.append(verName);
            verState.addPseudoFile((PseudoFile)new VersionPseudoFile(verName, pathStr.toString()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added pseudo folder for new version " + storeName + ":/" + verName));
            }
            if (this.hasChangeHandler()) {
                pathStr.append('\\');
                pathStr.append(verName);
                this.getChangeHandler().notifyDirectoryChanged(1, pathStr.toString());
            }
        }
    }

    public void versionPurged(String storeName, int versionID) {
        if (!this.isVirtualizationView()) {
            return;
        }
        FileStateCache fsTable = this.getStateCache();
        if (fsTable == null) {
            return;
        }
        StringBuilder pathStr = new StringBuilder();
        pathStr.append('\\');
        pathStr.append(storeName);
        pathStr.append('\\');
        pathStr.append("VERSION");
        FileState verState = fsTable.findFileState(pathStr.toString());
        if (verState != null && verState.hasPseudoFiles()) {
            StringBuilder verStr = new StringBuilder();
            verStr.append("v");
            verStr.append(versionID);
            String verName = verStr.toString();
            verState.getPseudoFileList().removeFile(verName, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed pseudo folder for purged version " + storeName + ":/" + verName));
            }
            if (this.hasChangeHandler()) {
                pathStr.append('\\');
                pathStr.append(verName);
                this.getChangeHandler().notifyDirectoryChanged(2, pathStr.toString());
            }
        }
    }
}

