/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.List;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.RepositoryDiskInterface;
import org.alfresco.filesys.repo.CommandExecutor;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.CreateFileCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.DoNothingCommand;
import org.alfresco.filesys.repo.rules.commands.OpenFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReduceQuotaCommand;
import org.alfresco.filesys.repo.rules.commands.RemoveNoContentFileOnError;
import org.alfresco.filesys.repo.rules.commands.RemoveTempFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReturnValueCommand;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandExecutorImpl
implements CommandExecutor {
    private static Log logger = LogFactory.getLog(CommandExecutorImpl.class);
    private TransactionService transactionService;
    private RepositoryDiskInterface repositoryDiskInterface;
    private ExtendedDiskInterface diskInterface;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
        PropertyCheck.mandatory((Object)this, (String)"repositoryDiskInterface", (Object)this.getRepositoryDiskInterface());
    }

    public Object execute(final SrvSession sess, final TreeConnection tree, final Command command) throws IOException {
        AlfrescoTransactionSupport.TxnReadState readState = command.getTransactionRequired();
        Object ret = null;
        if (readState == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            ret = this.executeInternal(sess, tree, command, null);
        } else {
            RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
            boolean readOnly = readState == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
            RetryingTransactionHelper.RetryingTransactionCallback<Object> cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws IOException {
                    try {
                        return CommandExecutorImpl.this.executeInternal(sess, tree, command, null);
                    }
                    catch (IOException e) {
                        throw new PropagatingException(e);
                    }
                }
            };
            try {
                ret = helper.doInTransaction(cb, readOnly);
            }
            catch (PropagatingException pe) {
                if (command instanceof CompoundCommand) {
                    CompoundCommand c;
                    List<Command> commands;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("error executing command :command" + command), (Throwable)pe);
                    }
                    if ((commands = (c = (CompoundCommand)command).getPostErrorCommands()) != null) {
                        for (Command c2 : commands) {
                            try {
                                this.executeInternal(sess, tree, c2, ret);
                            }
                            catch (Throwable t) {
                                logger.warn((Object)"caught and ignored exception from error handler", t);
                            }
                        }
                    }
                }
                throw (IOException)pe.getCause();
            }
        }
        if (command instanceof CompoundCommand) {
            logger.debug((Object)"post commit of compound command");
            CompoundCommand c = (CompoundCommand)command;
            List<Command> commands = c.getPostCommitCommands();
            if (commands != null) {
                for (Command c2 : commands) {
                    this.executeInternal(sess, tree, c2, ret);
                }
            }
        }
        return ret;
    }

    private FileFilterMode.Client getClient(SrvSession srvSession) {
        String clientStr = srvSession.getServer().getProtocolName().toLowerCase();
        if (clientStr.equals("cifs")) {
            return FileFilterMode.Client.cifs;
        }
        if (clientStr.equals("nfs")) {
            return FileFilterMode.Client.nfs;
        }
        if (clientStr.equals("ftp")) {
            return FileFilterMode.Client.ftp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeInternal(SrvSession sess, TreeConnection tree, Command command, Object result) throws IOException {
        block39: {
            FileFilterMode.setClient((FileFilterMode.Client)this.getClient(sess));
            try {
                if (command instanceof CompoundCommand) {
                    Object ret = null;
                    logger.debug((Object)"compound command received");
                    CompoundCommand x = (CompoundCommand)command;
                    for (Command compoundPart : x.getCommands()) {
                        logger.debug((Object)"running part of compound command");
                        Object val = this.executeInternal(sess, tree, compoundPart, result);
                        if (val == null) continue;
                        ret = val;
                    }
                    Iterator<Command> i$ = ret;
                    return i$;
                }
                if (command instanceof CreateFileCommand) {
                    logger.debug((Object)"create file command");
                    CreateFileCommand create = (CreateFileCommand)command;
                    NetworkFile x = this.repositoryDiskInterface.createFile(create.getRootNode(), create.getPath(), create.getAllocationSize());
                    return x;
                }
                if (command instanceof DeleteFileCommand) {
                    logger.debug((Object)"delete file command");
                    DeleteFileCommand delete = (DeleteFileCommand)command;
                    this.diskInterface.deleteFile(sess, tree, delete.getPath());
                    break block39;
                }
                if (command instanceof OpenFileCommand) {
                    logger.debug((Object)"open file command");
                    OpenFileCommand o = (OpenFileCommand)command;
                    OpenFileMode mode = o.getMode();
                    NetworkFile i$ = this.repositoryDiskInterface.openFile(sess, tree, o.getRootNodeRef(), o.getPath(), mode, o.isTruncate());
                    return i$;
                }
                if (command instanceof CloseFileCommand) {
                    logger.debug((Object)"close file command");
                    CloseFileCommand c = (CloseFileCommand)command;
                    this.repositoryDiskInterface.closeFile(c.getRootNodeRef(), c.getPath(), c.getNetworkFile());
                    break block39;
                }
                if (command instanceof ReduceQuotaCommand) {
                    logger.debug((Object)"reduceQuota file command");
                    ReduceQuotaCommand r = (ReduceQuotaCommand)command;
                    this.repositoryDiskInterface.reduceQuota(sess, tree, r.getNetworkFile());
                    break block39;
                }
                if (command instanceof RenameFileCommand) {
                    logger.debug((Object)"rename command");
                    RenameFileCommand rename = (RenameFileCommand)command;
                    this.diskInterface.renameFile(sess, tree, rename.getFromPath(), rename.getToPath());
                    break block39;
                }
                if (command instanceof CopyContentCommand) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Copy content command - copy content");
                    }
                    CopyContentCommand copy = (CopyContentCommand)command;
                    this.repositoryDiskInterface.copyContent(copy.getRootNode(), copy.getFromPath(), copy.getToPath());
                    break block39;
                }
                if (command instanceof DoNothingCommand) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Do Nothing Command - doing nothing");
                    }
                    break block39;
                }
                if (command instanceof ResultCallback) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Result Callback");
                    }
                    ResultCallback callback = (ResultCallback)command;
                    callback.execute(result);
                    break block39;
                }
                if (command instanceof RemoveTempFileCommand) {
                    File file;
                    boolean isDeleted;
                    RemoveTempFileCommand r = (RemoveTempFileCommand)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Remove Temp File:" + (Object)((Object)r.getNetworkFile())));
                    }
                    if (isDeleted = (file = r.getNetworkFile().getFile()).delete()) break block39;
                    logger.debug((Object)("unable to delete temp file:" + (Object)((Object)r.getNetworkFile()) + ", closed=" + r.getNetworkFile().isClosed()));
                    FileChannel outChan = null;
                    try {
                        outChan = new FileOutputStream(file).getChannel();
                        outChan.truncate(0L);
                        break block39;
                    }
                    catch (IOException e) {
                        logger.debug((Object)"unable to clean up file", (Throwable)e);
                        break block39;
                    }
                    finally {
                        if (outChan != null) {
                            try {
                                outChan.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (command instanceof ReturnValueCommand) {
                    ReturnValueCommand r = (ReturnValueCommand)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Return value");
                    }
                    Object object = r.getReturnValue();
                    return object;
                }
                if (command instanceof RemoveNoContentFileOnError) {
                    RemoveNoContentFileOnError r = (RemoveNoContentFileOnError)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Remove no content file on error");
                    }
                    this.repositoryDiskInterface.deleteEmptyFile(r.getRootNodeRef(), r.getPath());
                }
            }
            finally {
                FileFilterMode.clearClient();
            }
        }
        return null;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setRepositoryDiskInterface(RepositoryDiskInterface repositoryDiskInterface) {
        this.repositoryDiskInterface = repositoryDiskInterface;
    }

    public RepositoryDiskInterface getRepositoryDiskInterface() {
        return this.repositoryDiskInterface;
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    protected static class PropagatingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropagatingException(Throwable cause) {
            super(cause);
        }
    }
}

