/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.util.List;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSearchContext
extends SearchContext {
    private static final Log logger = LogFactory.getLog(ContentSearchContext.class);
    public static final int LinkFileSize = 512;
    private CifsHelper cifsHelper;
    private List<NodeRef> results;
    private int index = -1;
    private PseudoFileList pseudoList;
    private boolean donePseudoFiles = false;
    private int resumeId;
    private String m_relPath;
    private String m_lastFileName;

    protected ContentSearchContext(CifsHelper cifsHelper, List<NodeRef> results, String searchStr, PseudoFileList pseudoList, String relPath) {
        super.setSearchString(searchStr);
        this.cifsHelper = cifsHelper;
        this.results = results;
        this.pseudoList = pseudoList;
        this.m_relPath = relPath;
        if (this.m_relPath != null && !this.m_relPath.endsWith("\\")) {
            this.m_relPath = this.m_relPath + "\\";
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("[ContentSearchContext searchStr=");
        sb.append(this.getSearchString());
        sb.append(", resultCount=");
        sb.append(this.results.size());
        sb.append(", pseudoList=");
        if (this.pseudoList != null) {
            sb.append(this.pseudoList.numberOfFiles());
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getResumeId() {
        return this.resumeId;
    }

    public boolean hasMoreFiles() {
        if (!this.donePseudoFiles && this.pseudoList != null && this.index < this.pseudoList.numberOfFiles() - 1) {
            return true;
        }
        return this.index < this.results.size() - 1;
    }

    public boolean nextFileInfo(FileInfo info) {
        PseudoFile pfile;
        if (!this.hasMoreFiles()) {
            return false;
        }
        ++this.index;
        ++this.resumeId;
        if (!this.donePseudoFiles && this.pseudoList != null && this.index < this.pseudoList.numberOfFiles() && (pfile = this.pseudoList.getFileAt(this.index)) != null) {
            FileInfo pinfo = pfile.getFileInfo();
            info.copyFrom(pinfo);
            if (info != null && info.getFileId() == -1) {
                StringBuilder pathStr = new StringBuilder(this.m_relPath);
                pathStr.append(info.getFileName());
                info.setFileId(pathStr.toString().hashCode());
            }
            if (this.index == this.pseudoList.numberOfFiles() - 1) {
                this.donePseudoFiles = true;
                this.index = -1;
            }
            return true;
        }
        try {
            ContentFileInfo nextInfo = null;
            NodeRef nextNodeRef = null;
            while (nextInfo == null && this.index < this.results.size()) {
                nextNodeRef = this.results.get(this.index);
                try {
                    nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "", false, false);
                    info.copyFrom((FileInfo)nextInfo);
                }
                catch (InvalidNodeRefException ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Noderef " + nextNodeRef + " no longer valid, ignoring"));
                    }
                    ++this.index;
                    ++this.resumeId;
                }
            }
            if (nextInfo == null) {
                return false;
            }
            StringBuilder pathStr = new StringBuilder(this.m_relPath);
            pathStr.append(info.getFileName());
            long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.cifsHelper.getNodeService().getProperty(nextNodeRef, ContentModel.PROP_NODE_DBID));
            info.setFileId((int)(id & 0xFFFFFFFFL));
            if (nextInfo.isLinkNode()) {
                info.setFileSize(512L);
                if (!info.isReadOnly()) {
                    info.setFileAttributes(info.getFileAttributes() + 1);
                }
                info.setFileType(3);
            } else {
                info.setFileType(1);
            }
            this.m_lastFileName = info.getFileName();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public String nextFileName() {
        if (!this.hasMoreFiles()) {
            return null;
        }
        ++this.index;
        ++this.resumeId;
        if (!this.donePseudoFiles && this.pseudoList != null) {
            if (this.index < this.pseudoList.numberOfFiles()) {
                PseudoFile pfile = this.pseudoList.getFileAt(this.index);
                if (pfile != null) {
                    FileInfo pinfo = pfile.getFileInfo();
                    return pinfo.getFileName();
                }
            } else {
                this.donePseudoFiles = true;
                this.index = -1;
                if (this.results == null || this.results.size() == 0) {
                    return null;
                }
            }
        }
        NodeRef nextNodeRef = this.results.get(this.index);
        try {
            ContentFileInfo nextInfo = this.cifsHelper.getFileInformation(nextNodeRef, "", false, false);
            this.m_lastFileName = nextInfo.getFileName();
            return nextInfo.getFileName();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean restartAt(FileInfo info) {
        int resId;
        if (this.pseudoList != null) {
            for (resId = 0; resId < this.pseudoList.numberOfFiles(); ++resId) {
                PseudoFile pfile = this.pseudoList.getFileAt(resId);
                if (!pfile.getFileName().equals(info.getFileName())) continue;
                this.donePseudoFiles = false;
                this.index = resId - 1;
                return true;
            }
        }
        if (this.m_lastFileName != null && info.getFileName().equalsIgnoreCase(this.m_lastFileName)) {
            --this.index;
            --this.resumeId;
            this.donePseudoFiles = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fast search restart - " + this.m_lastFileName));
            }
            return true;
        }
        if (this.results != null) {
            int idx = 0;
            while (idx < this.results.size()) {
                String fname = this.cifsHelper.getFileName(this.results.get(idx));
                if (fname != null && fname.equals(info.getFileName())) {
                    this.index = idx - 1;
                    this.resumeId = resId - 1;
                    this.donePseudoFiles = true;
                    return true;
                }
                ++idx;
                ++resId;
            }
        }
        return false;
    }

    public boolean restartAt(int resumeId) {
        --resumeId;
        if (this.pseudoList != null) {
            if (resumeId < this.pseudoList.numberOfFiles()) {
                this.index = resumeId;
                this.donePseudoFiles = false;
                return true;
            }
            resumeId -= this.pseudoList.numberOfFiles();
        }
        if (this.results != null && resumeId < this.results.size()) {
            this.index = resumeId;
            this.donePseudoFiles = true;
            return true;
        }
        return false;
    }

    protected boolean returningPseudoFiles() {
        return this.donePseudoFiles;
    }

    protected String getRelativePath() {
        return this.m_relPath;
    }

    protected int getResultsSize() {
        return this.results != null ? this.results.size() : 0;
    }

    protected int getPseudoListSize() {
        return this.pseudoList != null ? this.pseudoList.numberOfFiles() : 0;
    }
}

