/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.Enumeration;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.config.ServerConfigurationBean;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

public class HomeShareMapper
implements ShareMapper,
InitializingBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    public static final String HOME_FOLDER_SHARE = "HOME";
    private ServerConfiguration m_config;
    private FilesystemsConfigSection m_filesysConfig;
    private ContentDiskDriver m_driver;
    private String m_homeShareName = "HOME";
    private boolean m_debug;

    public void setServerConfiguration(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setName(String shareName) {
        this.m_homeShareName = shareName;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setServerConfiguration(config);
        String homeName = params.getAttribute("name");
        if (homeName != null && homeName.length() > 0) {
            this.setName(homeName);
        }
        if (params != null && params.getChild("debug") != null) {
            this.setDebug(true);
        }
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        SharedDeviceList shares = this.m_filesysConfig.getShares();
        if (shares != null) {
            Enumeration shrEnum = shares.enumerateShares();
            while (shrEnum.hasMoreElements() && this.m_driver == null) {
                try {
                    SharedDevice curShare = (SharedDevice)shrEnum.nextElement();
                    if (!(curShare.getInterface() instanceof ContentDiskDriver)) continue;
                    this.m_driver = (ContentDiskDriver)curShare.getInterface();
                }
                catch (InvalidDeviceInterfaceException invalidDeviceInterfaceException) {}
            }
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final String getHomeFolderName() {
        return this.m_homeShareName;
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        AlfrescoClientInfo alfClient;
        if (sess != null && sess.hasClientInformation() && !sess.hasDynamicShares() && sess.getClientInformation() instanceof AlfrescoClientInfo && (alfClient = (AlfrescoClientInfo)sess.getClientInformation()).hasHomeFolder()) {
            DiskSharedDevice homeShare = this.createHomeDiskShare(alfClient);
            sess.addDynamicShare((SharedDevice)homeShare);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + this.getHomeFolderName() + " share to list of shares for " + alfClient.getUserName()));
            }
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharedDevice findShare(String tohost, String name, int typ, SrvSession sess, boolean create) throws Exception {
        SharedDevice share = null;
        if ((typ == 0 || typ == -1) && name.equalsIgnoreCase(this.getHomeFolderName()) && sess.getClientInformation() != null && this.m_driver != null) {
            ClientInfo client = sess.getClientInformation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Map share " + name + ", type=" + ShareType.TypeAsString((int)typ) + ", client=" + client));
            }
            if (client != null && client instanceof AlfrescoClientInfo) {
                AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                if (!alfClient.hasHomeFolder()) throw new InvalidUserException("No home directory");
                if (sess.hasDynamicShares()) {
                    share = sess.getDynamicShareList().findShare(name, typ, false);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Reusing existing dynamic share for " + name));
                    }
                }
                if (share == null && create) {
                    DiskSharedDevice diskShare = this.createHomeDiskShare(alfClient);
                    sess.addDynamicShare((SharedDevice)diskShare);
                    share = diskShare;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Mapped share " + name + " to " + alfClient.getHomeFolder()));
                    }
                }
            }
        } else {
            share = this.m_filesysConfig.getShares().findShare(name, typ, false);
            if (share == null) {
                share = this.m_filesysConfig.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Deleted dynamic share " + shr));
        }
        shares.removeAllShares();
    }

    public void closeMapper() {
    }

    private final DiskSharedDevice createHomeDiskShare(AlfrescoClientInfo alfClient) {
        if (alfClient != null) {
            ContentContext diskCtx = new ContentContext(this.getHomeFolderName(), "", "", alfClient.getHomeFolder());
            if (!(this.m_config instanceof ServerConfigurationBean)) {
                throw new AlfrescoRuntimeException("configuration error, unknown configuration bean");
            }
            ServerConfigurationBean config = (ServerConfigurationBean)this.m_config;
            config.initialiseRuntimeContext(diskCtx);
            return new DiskSharedDevice(this.getHomeFolderName(), (DeviceInterface)this.m_driver, (DiskDeviceContext)diskCtx, 8);
        }
        return null;
    }
}

