/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.CreateNodeEvent;
import org.alfresco.filesys.repo.DeleteNodeEvent;
import org.alfresco.filesys.repo.LockNodeEvent;
import org.alfresco.filesys.repo.MoveNodeEvent;
import org.alfresco.filesys.repo.NodeEvent;
import org.alfresco.filesys.repo.NodeEventQueue;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMonitor
extends TransactionListenerAdapter
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
Runnable {
    private static final Log logger = LogFactory.getLog(NodeMonitor.class);
    public static final String FileSysNodeEvent = "FileSysNodeEvent";
    public static final String FileSysNodeEvent2 = "FileSysNodeEvent2";
    private PolicyComponent m_policyComponent;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private PermissionService m_permissionService;
    private TransactionService m_transService;
    private ContentContext m_filesysCtx;
    private FileStateCache m_stateTable;
    private String m_rootPath;
    private StoreRef m_storeRef;
    private NodeEventQueue m_eventQueue;
    private Thread m_thread;
    private boolean m_shutdown;

    protected NodeMonitor(ContentContext filesysCtx, NodeService nodeService, PolicyComponent policyComponent, FileFolderService fileFolderService, PermissionService permissionService, TransactionService transService) {
        this.m_filesysCtx = filesysCtx;
        this.m_nodeService = nodeService;
        this.m_policyComponent = policyComponent;
        this.m_fileFolderService = fileFolderService;
        this.m_permissionService = permissionService;
        this.m_transService = transService;
        this.init();
    }

    public final void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.m_nodeService);
        PropertyCheck.mandatory((Object)this, (String)"filesysCtx", (Object)((Object)this.m_filesysCtx));
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.m_policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.m_fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.m_permissionService);
        PropertyCheck.mandatory((Object)this, (String)"transService", (Object)this.m_transService);
        this.m_filesysCtx.setFileServerNotifications(false);
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), this, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.m_storeRef = this.m_filesysCtx.getRootNode().getStoreRef();
        String rootPath = (String)((Object)this.m_nodeService.getProperty(this.m_filesysCtx.getRootNode(), ContentModel.PROP_NAME));
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/");
        if (rootPath != null && rootPath.length() > 0) {
            pathBuilder.append(rootPath);
        }
        this.m_rootPath = pathBuilder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node monitor filesystem=" + this.m_filesysCtx.getDeviceName() + ", rootPath=" + this.m_rootPath));
        }
        this.m_eventQueue = new NodeEventQueue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node monitor installed for " + this.m_filesysCtx.getDeviceName()));
        }
    }

    public void startMonitor() {
        this.m_stateTable = this.m_filesysCtx.getStateCache();
        this.m_thread = new Thread(this);
        this.m_thread.setName("NodeMonitor_" + this.m_filesysCtx.getDeviceName());
        this.m_thread.setDaemon(true);
        this.m_thread.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NodeMonitor started, " + this.m_thread.getName()));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            Path nodePath = this.m_nodeService.getPath(nodeRef);
            String relPath = nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService);
            String fName = (String)((Object)this.m_nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OnCreateNode: nodeRef=" + nodeRef + ", name=" + fName + ", path=" + relPath));
            }
            CreateNodeEvent nodeEvent = new CreateNodeEvent(fType, nodeRef, relPath, fName);
            this.fireNodeEvent(nodeEvent);
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            String beforeLock = (String)((Object)before.get(ContentModel.PROP_LOCK_TYPE));
            String afterLock = (String)((Object)after.get(ContentModel.PROP_LOCK_TYPE));
            String beforeName = (String)((Object)before.get(ContentModel.PROP_NAME));
            String afterName = (String)((Object)after.get(ContentModel.PROP_NAME));
            Path nodePath = this.m_nodeService.getPath(nodeRef);
            String relPath = nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService);
            if (beforeLock != null && afterLock == null || beforeLock == null && afterLock != null) {
                this.fireNodeEvent(new LockNodeEvent(fType, nodeRef, relPath, beforeName, beforeLock, afterLock));
            }
            if (beforeName != null && !beforeName.equals(afterName)) {
                ChildAssociationRef childAssocRef = this.m_nodeService.getPrimaryParent(nodeRef);
                String relPath2 = this.buildRelativePathString(childAssocRef.getParentRef(), beforeName);
                String relPath3 = this.buildRelativePathString(childAssocRef.getParentRef(), afterName);
                this.fireNodeEvent(new MoveNodeEvent(fType, nodeRef, relPath2, relPath3));
            }
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef oldNodeRef = oldChildAssocRef.getChildRef();
        if (!oldNodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(oldNodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            String fName = (String)((Object)this.m_nodeService.getProperty(oldNodeRef, ContentModel.PROP_NAME));
            String relPath = this.buildRelativePathString(oldChildAssocRef.getParentRef(), fName);
            String relPath2 = this.buildRelativePathString(newChildAssocRef.getParentRef(), fName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OnMoveNode: nodeRef=" + oldNodeRef + ", relPath=" + relPath));
            }
            if (relPath.startsWith(this.m_rootPath)) {
                MoveNodeEvent nodeEvent = new MoveNodeEvent(fType, oldNodeRef, relPath, relPath2);
                this.fireNodeEvent(nodeEvent);
            }
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            String relPath;
            StringBuilder pathStr = this.calculateDisplayPath(nodeRef);
            String string = relPath = null != pathStr ? pathStr.toString() : "";
            if (relPath.startsWith(this.m_rootPath)) {
                DeleteNodeEvent nodeEvent = new DeleteNodeEvent(fType, nodeRef, relPath);
                this.fireNodeEvent(nodeEvent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("BeforeDeleteNode: nodeRef=" + nodeRef + ", relPath=" + relPath));
                }
            }
        }
    }

    private StringBuilder calculateDisplayPath(final NodeRef nodeRef) {
        return (StringBuilder)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<StringBuilder>(){

            public StringBuilder doWork() throws Exception {
                Path nodePath = NodeMonitor.this.m_nodeService.getPath(nodeRef);
                String fName = (String)((Object)NodeMonitor.this.m_nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                StringBuilder result = new StringBuilder();
                result.append(nodePath.toDisplayPath(NodeMonitor.this.m_nodeService, NodeMonitor.this.m_permissionService));
                if (0 == result.length() || '/' != result.charAt(result.length() - 1) && '\\' != result.charAt(result.length() - 1)) {
                    result.append("\\");
                }
                return result.append(fName);
            }
        }, (String)"System");
    }

    private String buildRelativePathString(NodeRef parentNodeRef, String nodeName) {
        Path nodePath = this.m_nodeService.getPath(parentNodeRef);
        StringBuilder pathStr = new StringBuilder();
        pathStr.append(nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService));
        if (pathStr.length() == 0 || pathStr.charAt(pathStr.length() - 1) != '/' && pathStr.charAt(pathStr.length() - 1) != '\\') {
            pathStr.append("/");
        }
        pathStr.append((String)((Object)this.m_nodeService.getProperty(parentNodeRef, ContentModel.PROP_NAME))).append("\\").append(nodeName);
        return pathStr.toString();
    }

    private void fireNodeEvent(NodeEvent nodeEvent) {
        String eventKey = FileSysNodeEvent;
        ArrayList<NodeEvent> events = (ArrayList<NodeEvent>)AlfrescoTransactionSupport.getResource(eventKey);
        if (events == null) {
            events = new ArrayList<NodeEvent>();
            AlfrescoTransactionSupport.bindListener(this);
            AlfrescoTransactionSupport.bindResource(eventKey, events);
        }
        events.add(nodeEvent);
    }

    public final void shutdownRequest() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void afterCommit() {
        List events = (List)AlfrescoTransactionSupport.getResource(FileSysNodeEvent);
        if (events != null) {
            for (NodeEvent event : events) {
                this.m_eventQueue.addEvent(event);
            }
        }
    }

    @Override
    public void run() {
        this.m_shutdown = false;
        AuthenticationUtil.setRunAsUserSystem();
        while (!this.m_shutdown) {
            try {
                final NodeEvent nodeEvent = this.m_eventQueue.removeEvent();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing event " + nodeEvent));
                }
                if (this.m_shutdown) continue;
                RetryingTransactionHelper.RetryingTransactionCallback<Object> processEventCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        if (nodeEvent == null) {
                            return null;
                        }
                        if (nodeEvent instanceof DeleteNodeEvent) {
                            NodeMonitor.this.processDeleteNode((DeleteNodeEvent)nodeEvent);
                        } else if (nodeEvent instanceof CreateNodeEvent) {
                            NodeMonitor.this.processCreateNode((CreateNodeEvent)nodeEvent);
                        } else if (nodeEvent instanceof MoveNodeEvent) {
                            NodeMonitor.this.processMoveNode((MoveNodeEvent)nodeEvent);
                        } else if (nodeEvent instanceof LockNodeEvent) {
                            NodeMonitor.this.processLockNode((LockNodeEvent)nodeEvent);
                        }
                        return null;
                    }
                };
                this.m_transService.getRetryingTransactionHelper().doInTransaction(processEventCallback, true, true);
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable e) {
                logger.error((Object)"Throwable in NodeMonitor thread", e);
            }
        }
    }

    private final void processCreateNode(CreateNodeEvent createEvent) {
        String relPath = createEvent.getRelPath();
        String name = createEvent.getName();
        if (relPath.startsWith(this.m_rootPath)) {
            FileState fState;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("CreateNode nodeRef=" + createEvent.getNodeRef() + ", fName=" + name + ", path=" + relPath));
            }
            StringBuilder fullPath = new StringBuilder();
            fullPath.append(relPath.substring(this.m_rootPath.length()));
            fullPath.append("/");
            fullPath.append(name);
            relPath = fullPath.toString();
            if (this.m_stateTable != null && (fState = this.m_stateTable.findFileState(relPath)) != null && !fState.exists()) {
                if (createEvent.getFileType() == FileFolderServiceType.FILE) {
                    fState.setFileStatus(1);
                } else {
                    fState.setFileStatus(2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CreateNode updated file state - " + fState));
                }
            }
            if (this.m_filesysCtx.hasChangeHandler() && this.m_filesysCtx.getChangeHandler().getGlobalNotifyMask() != 0) {
                if (createEvent.getFileType() == FileFolderServiceType.FILE) {
                    this.m_filesysCtx.getChangeHandler().notifyFileChanged(1, relPath);
                } else {
                    this.m_filesysCtx.getChangeHandler().notifyDirectoryChanged(1, relPath);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"CreateNode queued change notification");
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("CreateNode ignored nodeRef=" + createEvent.getNodeRef() + ", path=" + relPath));
        }
    }

    private final void processDeleteNode(DeleteNodeEvent deleteEvent) {
        FileState fState;
        if (!deleteEvent.hasDeleteConfirm()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DeleteNode not confirmed, nodeRef=" + deleteEvent.getNodeRef() + ", path=" + deleteEvent.getPath()));
            }
            return;
        }
        String relPath = deleteEvent.getPath().substring(this.m_rootPath.length()).replace('/', '\\');
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DeleteNode nodeRef=" + deleteEvent.getNodeRef() + ", path=" + relPath));
        }
        if (this.m_stateTable != null && (fState = this.m_stateTable.findFileState(relPath)) != null && fState.exists()) {
            fState.setFileStatus(0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DeleteNode updated file state - " + fState));
            }
        }
        if (this.m_filesysCtx.hasChangeHandler() && this.m_filesysCtx.getChangeHandler().getGlobalNotifyMask() != 0) {
            if (deleteEvent.getFileType() == FileFolderServiceType.FILE) {
                this.m_filesysCtx.getChangeHandler().notifyFileChanged(2, relPath);
            } else {
                this.m_filesysCtx.getChangeHandler().notifyDirectoryChanged(2, relPath);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DeleteNode queued change notification");
            }
        }
    }

    private final void processMoveNode(MoveNodeEvent moveEvent) {
        String fromPath = moveEvent.getFromPath().substring(this.m_rootPath.length()).replace('/', '\\');
        String toPath = moveEvent.getToPath().substring(this.m_rootPath.length()).replace('/', '\\');
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MoveNode fromPath=" + fromPath + ", toPath=" + toPath));
        }
        if (this.m_stateTable != null) {
            FileState fState = this.m_stateTable.findFileState(fromPath);
            if (fState != null && fState.exists()) {
                fState.setFileStatus(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MoveNode updated state for fromPath=" + fromPath));
                }
            }
            if ((fState = this.m_stateTable.findFileState(toPath)) != null && !fState.exists()) {
                if (moveEvent.getFileType() == FileFolderServiceType.FILE) {
                    fState.setFileStatus(1);
                } else {
                    fState.setFileStatus(2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MoveNode updated state for toPath=" + toPath));
                }
            }
        }
        if (this.m_filesysCtx.hasChangeHandler() && this.m_filesysCtx.getChangeHandler().getGlobalNotifyMask() != 0) {
            this.m_filesysCtx.getChangeHandler().notifyRename(fromPath, toPath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MoveNode queued change notification");
            }
        }
    }

    private final void processLockNode(LockNodeEvent lockEvent) {
        String relPath = lockEvent.getRelPath();
        String name = lockEvent.getName();
        if (relPath.startsWith(this.m_rootPath)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("LockNode nodeRef=" + lockEvent.getNodeRef() + ", name=" + name + ", path=" + relPath));
            }
            StringBuilder fullPath = new StringBuilder();
            fullPath.append(relPath.substring(this.m_rootPath.length()));
            fullPath.append("/");
            fullPath.append(name);
            relPath = fullPath.toString().replace('/', '\\');
            if (this.m_filesysCtx.hasChangeHandler()) {
                this.m_filesysCtx.getChangeHandler().notifyAttributesChanged(relPath, lockEvent.getFileType() != FileFolderServiceType.FILE);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"LockNode queued change notification");
                }
            }
        }
    }
}

