/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.smb.server.disk.JavaNetworkFile;

public class TempNetworkFile
extends JavaNetworkFile
implements NetworkFileStateInterface {
    private FileState fileState;

    public TempNetworkFile(File file, String netPath) {
        super(file, netPath);
        this.setFullName(netPath);
    }

    public TempNetworkFile(File file, String netPath, Reader existingContent) {
        super(file, netPath);
        this.setFullName(netPath);
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        return "TempNetworkFile:" + this.getFullName() + " path: " + this.m_file.getAbsolutePath();
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.fileState != null) {
            this.fileState.updateAccessDateTime();
        }
        return super.readFile(buf, len, pos, fileOff);
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        super.writeFile(buf, len, pos);
        long size = this.m_io.length();
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
        }
    }

    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        super.writeFile(buffer, length, position, fileOffset);
        long size = this.m_io.length();
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
        }
    }

    public void truncateFile(long size) throws IOException {
        super.truncateFile(size);
        this.setFileSize(size);
        if (this.fileState != null) {
            this.fileState.updateModifyDateTime();
            this.fileState.updateAccessDateTime();
            this.fileState.setFileSize(size);
        }
    }

    public void setFileState(FileState fileState) {
        this.fileState = fileState;
    }

    public FileState getFileState() {
        return this.fileState;
    }

    public boolean allowsOpenCloseViaNetworkFile() {
        return false;
    }
}

