/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.RuleEvaluator;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleEvaluatorImpl
implements RuleEvaluator {
    private static Log logger = LogFactory.getLog(RuleEvaluatorImpl.class);
    private List<Scenario> scenarios;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"scenarios", this.scenarios);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command evaluate(EvaluatorContext context, Operation operation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("evaluate:" + operation));
        }
        List<ScenarioInstance> list = context.getScenarioInstances();
        synchronized (list) {
            for (Scenario scenario : this.scenarios) {
                ScenarioInstance instance = scenario.createInstance(context.getScenarioInstances(), operation);
                if (instance == null) continue;
                context.getScenarioInstances().add(instance);
            }
            Iterator<ScenarioInstance> i = context.getScenarioInstances().iterator();
            HashMap<ScenarioInstance.Ranking, Command> executors = new HashMap<ScenarioInstance.Ranking, Command>();
            while (i.hasNext()) {
                Command executor;
                ScenarioInstance scenario = i.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("evaluating:" + scenario + " operation: " + operation));
                }
                if ((executor = scenario.evaluate(operation)) != null) {
                    executors.put(scenario.getRanking(), executor);
                }
                if (!scenario.isComplete()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Scenario is complete:" + scenario));
                }
                i.remove();
            }
            Command ex = (Command)executors.get((Object)ScenarioInstance.Ranking.HIGH);
            if (ex != null) {
                logger.debug((Object)"returning high priority executor");
                return ex;
            }
            ex = (Command)executors.get((Object)ScenarioInstance.Ranking.MEDIUM);
            if (ex != null) {
                logger.debug((Object)"returning medium priority executor");
                return ex;
            }
            ex = (Command)executors.get((Object)ScenarioInstance.Ranking.LOW);
            if (ex != null) {
                logger.debug((Object)"returning low priority executor");
                return ex;
            }
        }
        return null;
    }

    public void setScenarios(List<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    @Override
    public EvaluatorContext createContext() {
        return new EvaluatorContextImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvaluatorContextImpl
    implements EvaluatorContext {
        private List<ScenarioInstance> currentScenarioInstances = new ArrayList<ScenarioInstance>();

        private EvaluatorContextImpl() {
        }

        @Override
        public List<ScenarioInstance> getScenarioInstances() {
            return this.currentScenarioInstances;
        }
    }
}

