/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeService;

public class LockImpl
implements Lock {
    private NodeImpl node;
    private Lock proxy = null;

    public LockImpl(NodeImpl node) {
        this.node = node;
    }

    public Lock getProxy() {
        if (this.proxy == null) {
            this.proxy = (Lock)JCRProxyFactory.create(this, Lock.class, this.node.session);
        }
        return this.proxy;
    }

    public String getLockOwner() {
        String lockOwner = null;
        NodeService nodeService = this.node.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        if (nodeService.hasAspect(this.node.getNodeRef(), ContentModel.ASPECT_LOCKABLE)) {
            lockOwner = (String)((Object)nodeService.getProperty(this.node.getNodeRef(), ContentModel.PROP_LOCK_OWNER));
        }
        return lockOwner;
    }

    public boolean isDeep() {
        return false;
    }

    public Node getNode() {
        return this.node.getProxy();
    }

    public String getLockToken() {
        LockService lockService = this.node.session.getRepositoryImpl().getServiceRegistry().getLockService();
        LockStatus lockStatus = lockService.getLockStatus(this.node.getNodeRef());
        return lockStatus.equals((Object)LockStatus.LOCK_OWNER) ? this.node.getNodeRef().toString() : null;
    }

    public boolean isLive() throws RepositoryException {
        return this.getLockToken() != null;
    }

    public boolean isSessionScoped() {
        return false;
    }

    public void refresh() throws LockException, RepositoryException {
    }
}

