/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.alfresco.jcr.item.ValueImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class ValueFactoryImpl
implements ValueFactory {
    private SessionImpl session;
    private ValueFactory proxy = null;

    public ValueFactoryImpl(SessionImpl session) {
        this.session = session;
    }

    public ValueFactory getProxy() {
        if (this.proxy == null) {
            this.proxy = (ValueFactory)JCRProxyFactory.create(this, ValueFactory.class, this.session);
        }
        return this.proxy;
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        Value createdValue = null;
        try {
            switch (type) {
                case 1: {
                    createdValue = this.createValue(this.session.getTypeConverter().stringValue(value));
                    break;
                }
                case 3: {
                    createdValue = this.createValue(this.session.getTypeConverter().longValue(value));
                    break;
                }
                case 4: {
                    createdValue = this.createValue(this.session.getTypeConverter().doubleValue(value));
                    break;
                }
                case 6: {
                    createdValue = this.createValue(this.session.getTypeConverter().booleanValue(value));
                    break;
                }
                case 5: {
                    createdValue = new ValueImpl(this.session, 5, this.session.getTypeConverter().convert(Date.class, (Object)value));
                    break;
                }
                case 2: {
                    createdValue = this.createValue(this.session.getTypeConverter().streamValue(value));
                    break;
                }
                case 9: {
                    createdValue = new ValueImpl(this.session, 9, this.session.getTypeConverter().referenceValue(value));
                    break;
                }
                case 7: {
                    QName name = this.session.getTypeConverter().convert(QName.class, (Object)value);
                    createdValue = new ValueImpl(this.session, 7, name);
                    break;
                }
                case 8: {
                    Path path = this.session.getTypeConverter().convert(Path.class, (Object)value);
                    createdValue = new ValueImpl(this.session, 8, path);
                    break;
                }
                default: {
                    throw new ValueFormatException("Cannot create value of type " + type);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ValueFormatException("Failed to create value " + value + " of type " + type, (Throwable)e);
        }
        return createdValue;
    }

    public Value createValue(String value) {
        return new ValueImpl(this.session, 1, value);
    }

    public Value createValue(long value) {
        return new ValueImpl(this.session, 3, value);
    }

    public Value createValue(double value) {
        return new ValueImpl(this.session, 4, value);
    }

    public Value createValue(boolean value) {
        return new ValueImpl(this.session, 6, value);
    }

    public Value createValue(Calendar value) {
        return new ValueImpl(this.session, 5, value.getTime());
    }

    public Value createValue(InputStream value) {
        return new ValueImpl(this.session, 2, value);
    }

    public Value createValue(Node value) throws RepositoryException {
        if (value == null) {
            throw new RepositoryException("Node value must not be null");
        }
        Property protocol = value.getProperty("sys:store-protocol");
        Property identifier = value.getProperty("sys:store-identifier");
        Property uuid = value.getProperty("sys:node-uuid");
        NodeRef ref = new NodeRef(new StoreRef(protocol.getString(), identifier.getString()), uuid.getString());
        return new ValueImpl(this.session, 9, ref);
    }
}

