/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import org.alfresco.opencmis.AlfrescoCmisService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoCmisServiceInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(AlfrescoCmisServiceInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object invoke(MethodInvocation invocation) throws Throwable {
        boolean debug = logger.isDebugEnabled();
        boolean trace = logger.isTraceEnabled();
        StringBuilder sb = null;
        if (debug || trace) {
            sb = new StringBuilder("\nCMIS invocation:         \n   Method:                 " + invocation.getMethod().getName() + "\n" + "   Arguments:            \n");
            for (Object arg : invocation.getArguments()) {
                sb.append("      ").append(arg).append("\n");
            }
        }
        Object ret = null;
        AlfrescoCmisService service = (AlfrescoCmisService)invocation.getThis();
        try {
            block11: {
                try {
                    if (debug || trace) {
                        sb.append("   Pre-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                    }
                    service.beforeCall();
                    if (debug || trace) {
                        sb.append("   In-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                    }
                    ret = invocation.proceed();
                    Object var10_11 = null;
                    service.afterCall();
                    if (!debug && !trace) break block11;
                    sb.append("   Post-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    service.afterCall();
                    if (debug || trace) {
                        sb.append("   Post-call authentication: \n      Full auth:           " + AuthenticationUtil.getFullyAuthenticatedUser() + "\n" + "      Effective auth:      " + AuthenticationUtil.getRunAsUser() + "\n");
                    }
                    throw throwable;
                }
                {
                }
            }
            if (trace) {
                sb.append("   Returning:              ").append(ret).append("\n");
                logger.debug((Object)sb);
            }
            return ret;
        }
        catch (Throwable e) {
            if (debug) {
                sb.append("   Throwing:             " + e.getMessage());
                logger.debug((Object)sb, e);
            }
            throw e;
        }
    }
}

