/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

public class CMISChangeLogDataExtractor
extends AbstractDataExtractor {
    public static final String KEY_NODE_REF = "nodeRef";
    public static final String KEY_OBJECT_ID = "objectId";
    private NodeService nodeService;
    private CMISDictionaryService cmisDictionaryService;

    public Serializable extractData(Serializable value) throws Throwable {
        NodeRef nodeRef = this.getNodeRef(value);
        QName typeQName = this.nodeService.getType(nodeRef);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findNodeType(typeQName);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put(KEY_NODE_REF, nodeRef);
        CMISPropertyAccessor accessor = type.getPropertyById("cmis:objectId").getPropertyAccessor();
        result.put(KEY_OBJECT_ID, accessor.getValue(accessor.createNodeInfo(nodeRef)));
        return result;
    }

    public boolean isSupported(Serializable data) {
        NodeRef nodeRef;
        if (data != null && (nodeRef = this.getNodeRef(data)) != null) {
            QName typeQName = this.nodeService.getType(nodeRef);
            TypeDefinitionWrapper type = this.cmisDictionaryService.findNodeType(typeQName);
            return type != null && (type.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT || type.getBaseTypeId() == BaseTypeId.CMIS_FOLDER);
        }
        return false;
    }

    private NodeRef getNodeRef(Serializable data) {
        NodeRef nodeRef = null;
        if (data instanceof FileInfo) {
            nodeRef = ((FileInfo)data).getNodeRef();
        } else if (data instanceof NodeRef) {
            nodeRef = (NodeRef)data;
        }
        return nodeRef;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setOpenCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }
}

