/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;

public class AllowedChildObjectTypeIdsProperty
extends AbstractProperty {
    private CMISMapping cmisMapping;

    public AllowedChildObjectTypeIdsProperty(ServiceRegistry serviceRegistry, CMISConnector connector, CMISMapping cmisMapping) {
        super(serviceRegistry, connector, "cmis:allowedChildObjectTypeIds");
        this.cmisMapping = cmisMapping;
    }

    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        if (nodeInfo.getType() == null) {
            return (Serializable)((Object)Collections.emptyList());
        }
        TypeDefinition type = this.getServiceRegistry().getDictionaryService().getType(nodeInfo.getType().getAlfrescoClass());
        if (type != null && type.getChildAssociations() != null && !type.getChildAssociations().isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (ChildAssociationDefinition cad : type.getChildAssociations().values()) {
                String typeId = this.cmisMapping.getCmisTypeId(cad.getTargetClass().getName());
                if (typeId == null) continue;
                result.add(typeId);
            }
            return result;
        }
        return (Serializable)((Object)Collections.emptyList());
    }
}

