/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;

public class DirectProperty
extends AbstractProperty {
    private QName alfrescoName;

    public DirectProperty(ServiceRegistry serviceRegistry, CMISConnector connector, String propertyName, QName alfrescoName) {
        super(serviceRegistry, connector, propertyName);
        this.alfrescoName = alfrescoName;
    }

    public QName getMappedProperty() {
        return this.alfrescoName;
    }

    public Serializable getValueInternal(CMISNodeInfo nodeInfo) {
        if (nodeInfo.getType() == null) {
            return null;
        }
        if (nodeInfo.getNodeRef() != null) {
            return this.getServiceRegistry().getNodeService().getProperty(nodeInfo.getNodeRef(), this.alfrescoName);
        }
        if (nodeInfo.getAssociationRef() != null) {
            return this.getServiceRegistry().getNodeService().getProperty(nodeInfo.getAssociationRef().getSourceRef(), this.alfrescoName);
        }
        return null;
    }
}

