/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISActionEvaluator;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISPropertyAccessor;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.mapping.AbstractProperty;
import org.alfresco.opencmis.mapping.AllowedChildObjectTypeIdsProperty;
import org.alfresco.opencmis.mapping.BaseTypeIdProperty;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.mapping.CanCancelCheckOutActionEvaluator;
import org.alfresco.opencmis.mapping.CanCheckInActionEvaluator;
import org.alfresco.opencmis.mapping.CanCheckOutActionEvaluator;
import org.alfresco.opencmis.mapping.CheckinCommentProperty;
import org.alfresco.opencmis.mapping.ContentStreamIdProperty;
import org.alfresco.opencmis.mapping.ContentStreamLengthProperty;
import org.alfresco.opencmis.mapping.ContentStreamMimetypeProperty;
import org.alfresco.opencmis.mapping.CreationDateProperty;
import org.alfresco.opencmis.mapping.CurrentVersionEvaluator;
import org.alfresco.opencmis.mapping.DirectProperty;
import org.alfresco.opencmis.mapping.FixedValueActionEvaluator;
import org.alfresco.opencmis.mapping.FixedValueProperty;
import org.alfresco.opencmis.mapping.IsImmutableProperty;
import org.alfresco.opencmis.mapping.IsLatestMajorVersionProperty;
import org.alfresco.opencmis.mapping.IsLatestVersionProperty;
import org.alfresco.opencmis.mapping.IsMajorVersionProperty;
import org.alfresco.opencmis.mapping.IsVersionSeriesCheckedOutProperty;
import org.alfresco.opencmis.mapping.ModificationDateProperty;
import org.alfresco.opencmis.mapping.NameProperty;
import org.alfresco.opencmis.mapping.NodeRefProperty;
import org.alfresco.opencmis.mapping.ObjectIdProperty;
import org.alfresco.opencmis.mapping.ObjectTypeIdProperty;
import org.alfresco.opencmis.mapping.ParentActionEvaluator;
import org.alfresco.opencmis.mapping.ParentProperty;
import org.alfresco.opencmis.mapping.PathProperty;
import org.alfresco.opencmis.mapping.PermissionActionEvaluator;
import org.alfresco.opencmis.mapping.RootFolderEvaluator;
import org.alfresco.opencmis.mapping.SourceIdProperty;
import org.alfresco.opencmis.mapping.TargetIdProperty;
import org.alfresco.opencmis.mapping.VersionLabelProperty;
import org.alfresco.opencmis.mapping.VersionSeriesCheckedOutByProperty;
import org.alfresco.opencmis.mapping.VersionSeriesCheckedOutIdProperty;
import org.alfresco.opencmis.mapping.VersionSeriesIdProperty;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimePropertyAccessorMapping
implements PropertyAccessorMapping,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(CMISMapping.class);
    private ServiceRegistry serviceRegistry;
    private CMISConnector cmisConnector;
    private CMISMapping cmisMapping;
    private CMISDictionaryService cmisDictionaryService;
    private Map<String, AbstractProperty> propertyAccessors = new HashMap<String, AbstractProperty>();
    private Map<BaseTypeId, Map<Action, CMISActionEvaluator>> actionEvaluators = new HashMap<BaseTypeId, Map<Action, CMISActionEvaluator>>();

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setCmisConnector(CMISConnector cmisConnector) {
        this.cmisConnector = cmisConnector;
    }

    public void setCmisMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void afterPropertiesSet() throws Exception {
        this.registerPropertyAccessor(new ObjectIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new NodeRefProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new ObjectTypeIdProperty(this.serviceRegistry, this.cmisConnector, this.cmisDictionaryService));
        this.registerPropertyAccessor(new BaseTypeIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, this.cmisConnector, "cmis:createdBy", ContentModel.PROP_CREATOR));
        this.registerPropertyAccessor(new CreationDateProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, this.cmisConnector, "cmis:lastModifiedBy", ContentModel.PROP_MODIFIER));
        this.registerPropertyAccessor(new ModificationDateProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new FixedValueProperty(this.serviceRegistry, this.cmisConnector, "cmis:changeToken", null));
        this.registerPropertyAccessor(new NameProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new IsImmutableProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new IsLatestVersionProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new IsMajorVersionProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new IsLatestMajorVersionProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new VersionLabelProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new VersionSeriesIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new IsVersionSeriesCheckedOutProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new VersionSeriesCheckedOutByProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new VersionSeriesCheckedOutIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new CheckinCommentProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new ContentStreamLengthProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new ContentStreamMimetypeProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new ContentStreamIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new DirectProperty(this.serviceRegistry, this.cmisConnector, "cmis:contentStreamFileName", ContentModel.PROP_NAME));
        this.registerPropertyAccessor(new ParentProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new PathProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new AllowedChildObjectTypeIdsProperty(this.serviceRegistry, this.cmisConnector, this.cmisMapping));
        this.registerPropertyAccessor(new SourceIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerPropertyAccessor(new TargetIdProperty(this.serviceRegistry, this.cmisConnector));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_UPDATE_PROPERTIES, "WriteProperties"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_PROPERTIES, "ReadProperties"));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_RELATIONSHIPS, true));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_PARENTS, "ReadPermissions")));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_MOVE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_CONTENT_STREAM, "WriteProperties", "WriteContent"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new CanCheckOutActionEvaluator(this.serviceRegistry), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CanCancelCheckOutActionEvaluator(this.serviceRegistry));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CanCheckInActionEvaluator(this.serviceRegistry));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_SET_CONTENT_STREAM, "WriteContent"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_ALL_VERSIONS, true));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_ADD_OBJECT_TO_FOLDER, true), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_REMOVE_OBJECT_FROM_FOLDER, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_CONTENT_STREAM, "ReadContent"));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_POLICY, false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_APPLIED_POLICIES, true));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_REMOVE_POLICY, false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_CREATE_RELATIONSHIP, true), false));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_RENDITIONS, true));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_ACL, "ReadPermissions"));
        this.registerEvaluator(BaseTypeId.CMIS_DOCUMENT, new CurrentVersionEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_ACL, "ChangePermissions"), false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new RootFolderEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_UPDATE_PROPERTIES, "WriteProperties"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_FOLDER_TREE, "ReadChildren"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_PROPERTIES, "ReadProperties"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_RELATIONSHIPS, true));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_PARENTS, "ReadPermissions")));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new RootFolderEvaluator(this.serviceRegistry, new ParentActionEvaluator(new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_FOLDER_PARENT, "ReadPermissions")), false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_DESCENDANTS, "ReadChildren"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new RootFolderEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_MOVE_OBJECT, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_POLICY, false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_APPLIED_POLICIES, true));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_REMOVE_POLICY, false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_CHILDREN, "ReadChildren"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_CREATE_DOCUMENT, "CreateChildren"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_CREATE_FOLDER, "CreateChildren"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_CREATE_RELATIONSHIP, "CreateAssociations"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new RootFolderEvaluator(this.serviceRegistry, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_TREE, "DeleteNode"), false));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_GET_ACL, "ReadPermissions"));
        this.registerEvaluator(BaseTypeId.CMIS_FOLDER, new PermissionActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_ACL, "ChangePermissions"));
        this.registerEvaluator(BaseTypeId.CMIS_RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_OBJECT, true));
        this.registerEvaluator(BaseTypeId.CMIS_RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_UPDATE_PROPERTIES, false));
        this.registerEvaluator(BaseTypeId.CMIS_RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_PROPERTIES, true));
        this.registerEvaluator(BaseTypeId.CMIS_RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_ACL, false));
        this.registerEvaluator(BaseTypeId.CMIS_RELATIONSHIP, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_ACL, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_DELETE_OBJECT, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_UPDATE_PROPERTIES, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_PROPERTIES, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_PARENTS, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_MOVE_OBJECT, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_ADD_OBJECT_TO_FOLDER, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_REMOVE_OBJECT_FROM_FOLDER, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_OBJECT_RELATIONSHIPS, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_GET_ACL, false));
        this.registerEvaluator(BaseTypeId.CMIS_POLICY, new FixedValueActionEvaluator(this.serviceRegistry, Action.CAN_APPLY_ACL, false));
    }

    public CMISPropertyAccessor getPropertyAccessor(String propertyId) {
        return this.propertyAccessors.get(propertyId);
    }

    public CMISPropertyAccessor createDirectPropertyAccessor(String propertyId, QName propertyName) {
        return new DirectProperty(this.serviceRegistry, this.cmisConnector, propertyId, propertyName);
    }

    private void registerPropertyAccessor(AbstractProperty propertyAccessor) {
        this.propertyAccessors.put(propertyAccessor.getName(), propertyAccessor);
    }

    public Map<Action, CMISActionEvaluator> getActionEvaluators(BaseTypeId scope) {
        Map<Object, Object> evaluators = this.actionEvaluators.get(scope);
        if (evaluators == null) {
            evaluators = Collections.emptyMap();
        }
        return evaluators;
    }

    private void registerEvaluator(BaseTypeId scope, CMISActionEvaluator evaluator) {
        Map<Action, CMISActionEvaluator> evaluators = this.actionEvaluators.get(scope);
        if (evaluators == null) {
            evaluators = new LinkedHashMap<Action, CMISActionEvaluator>();
            this.actionEvaluators.put(scope, evaluators);
        }
        if (evaluators.get(evaluator.getAction()) != null) {
            throw new AlfrescoRuntimeException("Already registered Action Evaluator " + evaluator.getAction() + " for scope " + scope);
        }
        evaluators.put(evaluator.getAction(), evaluator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered Action Evaluator: scope=" + scope + ", evaluator=" + evaluator));
        }
    }
}

