/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.Map;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParameterConstraint
implements ParameterConstraint,
BeanNameAware {
    protected String name;
    protected RuntimeActionService actionService;
    protected boolean cache = true;
    protected Map<String, String> allowableValues;

    public void init() {
        this.actionService.registerParameterConstraint(this);
    }

    public void setActionService(RuntimeActionService actionService) {
        this.actionService = actionService;
    }

    public void setCacheAllowableValues(boolean cache) {
        this.cache = cache;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, String> getAllowableValues() {
        if (this.cache) {
            if (this.allowableValues == null) {
                this.allowableValues = this.getAllowableValuesImpl();
            }
            return this.allowableValues;
        }
        return this.getAllowableValuesImpl();
    }

    protected abstract Map<String, String> getAllowableValuesImpl();

    protected String getI18NLabel(String key) {
        String result = key.toString();
        StringBuffer longKey = new StringBuffer(this.name).append(".").append(key.toString().toLowerCase());
        String i18n = I18NUtil.getMessage((String)longKey.toString());
        if (i18n != null) {
            result = i18n;
        }
        return result;
    }

    @Override
    public String getValueDisplayLabel(String value) {
        return this.getAllowableValues().get(value);
    }

    @Override
    public boolean isValidValue(String value) {
        return this.getAllowableValues().containsKey(value);
    }
}

