/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemAbstractBase;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ActionExecuterAbstractBase
extends ParameterizedItemAbstractBase
implements ActionExecuter {
    private static Log logger = LogFactory.getLog(ActionExecuterAbstractBase.class);
    protected ActionDefinition actionDefinition;
    private LockService lockService;
    private NodeService baseNodeService;
    private boolean trackStatus = false;
    protected boolean publicAction = true;
    protected List<QName> applicableTypes = new ArrayList<QName>();
    private String queueName = "";
    private boolean ignoreLock = true;

    public void init() {
        if (this.publicAction) {
            this.runtimeActionService.registerActionExecuter(this);
        }
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setBaseNodeService(NodeService nodeService) {
        this.baseNodeService = nodeService;
    }

    public void setPublicAction(boolean publicAction) {
        this.publicAction = publicAction;
    }

    public boolean getTrackStatus() {
        return this.trackStatus;
    }

    public void setTrackStatus(boolean trackStatus) {
        this.trackStatus = trackStatus;
    }

    public void setApplicableTypes(String[] applicableTypes) {
        for (String type : applicableTypes) {
            this.applicableTypes.add(QName.createQName((String)type));
        }
    }

    public boolean getIgnoreLock() {
        return this.ignoreLock;
    }

    public void setIgnoreLock(boolean ignoreLock) {
        this.ignoreLock = ignoreLock;
    }

    public ActionDefinition getActionDefinition() {
        if (this.actionDefinition == null) {
            this.actionDefinition = this.createActionDefinition(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setTitleKey(this.getTitleKey());
            ((ActionDefinitionImpl)this.actionDefinition).setDescriptionKey(this.getDescriptionKey());
            ((ActionDefinitionImpl)this.actionDefinition).setTrackStatus(this.getTrackStatus());
            ((ActionDefinitionImpl)this.actionDefinition).setAdhocPropertiesAllowed(this.getAdhocPropertiesAllowed());
            ((ActionDefinitionImpl)this.actionDefinition).setRuleActionExecutor(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setParameterDefinitions(this.getParameterDefintions());
            ((ActionDefinitionImpl)this.actionDefinition).setApplicableTypes(this.applicableTypes);
        }
        return this.actionDefinition;
    }

    protected ActionDefinition createActionDefinition(String name) {
        return new ActionDefinitionImpl(name);
    }

    public void execute(Action action, NodeRef actionedUponNodeRef) {
        this.checkMandatoryProperties(action, this.getActionDefinition());
        if (this.ignoreLock || !this.hasLock(actionedUponNodeRef)) {
            this.executeImpl(action, actionedUponNodeRef);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Action (" + action.getActionDefinitionName() + ") ignored because actioned upon node (" + actionedUponNodeRef.toString() + ") is locked."));
        }
    }

    private boolean hasLock(NodeRef nodeRef) {
        boolean result = false;
        if (this.baseNodeService.exists(nodeRef)) {
            result = this.lockService.getLockStatus(nodeRef) != LockStatus.NO_LOCK;
        }
        return result;
    }

    protected abstract void executeImpl(Action var1, NodeRef var2);

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }
}

