/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.action.scheduled.AbstractScheduledAction;
import org.alfresco.repo.action.scheduled.InvalidCronExpression;
import org.alfresco.repo.action.scheduled.TemplateActionModelFactory;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronScheduledQueryBasedTemplateActionDefinition
extends AbstractScheduledAction {
    private SearchService searchService;
    private TemplateService templateService;
    private String queryLanguage;
    private List<String> stores;
    private String queryTemplate;
    private String cronExpression;
    private String jobName;
    private String jobGroup;
    private String triggerName;
    private String triggerGroup;
    private Scheduler scheduler;
    private TemplateActionModelFactory templateActionModelFactory;

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public TemplateActionModelFactory getTemplateActionModelFactory() {
        return this.templateActionModelFactory;
    }

    public void setTemplateActionModelFactory(TemplateActionModelFactory templateActionModelFactory) {
        this.templateActionModelFactory = templateActionModelFactory;
    }

    @Override
    public Trigger getTrigger() {
        try {
            return new CronTrigger(this.getTriggerName(), this.getTriggerGroup(), this.getCronExpression());
        }
        catch (ParseException e) {
            throw new InvalidCronExpression("Invalid chron expression: n" + this.getCronExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<NodeRef> getNodes() {
        LinkedList<NodeRef> nodeRefs = new LinkedList<NodeRef>();
        String queryTemplate = this.getQueryTemplate();
        String query = this.templateService.processTemplateString(this.getTemplateActionModelFactory().getTemplateEngine(), queryTemplate, this.getTemplateActionModelFactory().getModel());
        SearchParameters sp = new SearchParameters();
        sp.setLanguage(this.getQueryLanguage());
        sp.setQuery(query);
        for (String storeRef : this.getStores()) {
            sp.addStore(new StoreRef(storeRef));
        }
        ResultSet results = null;
        try {
            results = this.searchService.query(sp);
            for (ResultSetRow row : results) {
                nodeRefs.add(row.getNodeRef());
            }
            Object var9_8 = null;
            if (results == null) return nodeRefs;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (results == null) throw throwable;
            results.close();
            throw throwable;
        }
        results.close();
        return nodeRefs;
    }

    @Override
    public Action getAction(NodeRef nodeRef) {
        return this.getTemplateActionDefinition().getAction(nodeRef);
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setStores(List<String> stores) {
        this.stores = stores;
    }

    public List<String> getStores() {
        return this.stores;
    }

    public void setQueryTemplate(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Override
    public String getJobGroup() {
        return this.jobGroup;
    }

    @Override
    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    @Override
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    @Override
    public String getTriggerGroup() {
        return this.triggerGroup;
    }

    public void afterPropertiesSet() throws Exception {
        this.register(this.getScheduler());
    }
}

