/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedNotifierImpl
implements FeedNotifier {
    private static Log logger = LogFactory.getLog(FeedNotifierImpl.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ActivityFeedNotifier");
    private static final long LOCK_TTL = 30000L;
    private static ThreadLocal<Pair<Long, String>> lockThreadLocal = new ThreadLocal();
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(FeedNotifierImpl.class.getName());
    private static final String MSG_EMAIL_SUBJECT = "activities.feed.notifier.email.subject";
    private ActivityService activityService;
    private PersonService personService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private ActionService actionService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private SiteService siteService;
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private AuthenticationContext authenticationContext;
    private SysAdminParams sysAdminParams;
    private RepoAdminService repoAdminService;
    private List<String> excludedEmailSuffixes;
    private RepositoryLocation feedEmailTemplateLocation;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setFeedEmailTemplateLocation(RepositoryLocation feedEmailTemplateLocation) {
        this.feedEmailTemplateLocation = feedEmailTemplateLocation;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setExcludedEmailSuffixes(List<String> excludedEmailSuffixes) {
        this.excludedEmailSuffixes = excludedEmailSuffixes;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
        PropertyCheck.mandatory((Object)this, (String)"feedEmailTemplateLocation", (Object)this.feedEmailTemplateLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(int repeatIntervalMins) {
        block11: {
            this.checkProperties();
            if (this.transactionService.isReadOnly()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Activities email notification bypassed; the system is read-only");
                }
                return;
            }
            try {
                block10: {
                    try {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Activities email notification started");
                        }
                        this.refreshLock();
                        this.executeInternal(repeatIntervalMins);
                        if (!logger.isTraceEnabled()) break block10;
                        logger.trace((Object)"Activities email notification completed");
                    }
                    catch (LockAcquisitionException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Activities email notification already underway");
                        }
                        Object var4_3 = null;
                        this.releaseLock();
                        break block11;
                    }
                    catch (VmShutdownListener.VmShutdownException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Activities email notification aborted");
                        }
                        Object var4_4 = null;
                        this.releaseLock();
                    }
                }
                Object var4_2 = null;
                this.releaseLock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.releaseLock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeInternal(final int repeatIntervalMins) {
        block13: {
            final NodeRef emailTemplateRef = this.getEmailTemplateRef();
            if (emailTemplateRef == null) {
                return;
            }
            final String shareUrl = UrlUtil.getShareUrl(this.sysAdminParams);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Share URL configured as: " + shareUrl));
            }
            int userCnt = 0;
            int feedEntryCnt = 0;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    final String subjectText = this.buildSubjectText(startTime);
                    Set<NodeRef> people = this.personService.getAllPeople();
                    final HashMap siteNames = new HashMap(10);
                    for (final NodeRef personNodeRef : people) {
                        this.refreshLock();
                        try {
                            RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
                            txHelper.setMaxRetries(0);
                            Pair<Integer, Long> result = txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Integer, Long>>(){

                                @Override
                                public Pair<Integer, Long> execute() throws Throwable {
                                    return FeedNotifierImpl.this.prepareAndSendEmail(personNodeRef, emailTemplateRef, subjectText, siteNames, shareUrl, repeatIntervalMins);
                                }
                            }, true, true);
                            if (result == null) continue;
                            int entryCnt = (Integer)result.getFirst();
                            final long maxFeedId = (Long)result.getSecond();
                            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                @Override
                                public Void execute() throws Throwable {
                                    Long currentMaxFeedId = (Long)FeedNotifierImpl.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID);
                                    if (currentMaxFeedId == null || currentMaxFeedId < maxFeedId) {
                                        FeedNotifierImpl.this.nodeService.setProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID, (Serializable)Long.valueOf(maxFeedId));
                                    }
                                    return null;
                                }
                            }, false, true);
                            ++userCnt;
                            feedEntryCnt += entryCnt;
                        }
                        catch (InvalidNodeRefException inre) {
                            logger.warn((Object)("Skip feed notification for user (" + personNodeRef + "): " + inre.getMessage()));
                        }
                    }
                    Object var19_18 = null;
                    if (userCnt <= 0) break block13;
                }
                catch (Throwable e) {
                    if (!vmShutdownListener.isVmShuttingDown()) {
                        logger.error((Object)"Exception during notification of feeds", e);
                    }
                    Object var19_19 = null;
                    if (userCnt <= 0) {
                        if (!logger.isTraceEnabled()) return;
                        logger.trace((Object)"Nothing to send since no new user activities found");
                        return;
                    }
                    if (!logger.isInfoEnabled()) return;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Notified ").append(userCnt).append(" user").append(userCnt != 1 ? "s" : "");
                    sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(feedEntryCnt != 1 ? "ies" : "y");
                    sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                    logger.info((Object)sb.toString());
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (userCnt <= 0) {
                    if (!logger.isTraceEnabled()) throw throwable;
                    logger.trace((Object)"Nothing to send since no new user activities found");
                    throw throwable;
                }
                if (!logger.isInfoEnabled()) throw throwable;
                StringBuilder sb = new StringBuilder();
                sb.append("Notified ").append(userCnt).append(" user").append(userCnt != 1 ? "s" : "");
                sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(feedEntryCnt != 1 ? "ies" : "y");
                sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                logger.info((Object)sb.toString());
                throw throwable;
            }
            if (!logger.isInfoEnabled()) return;
            StringBuilder sb = new StringBuilder();
            sb.append("Notified ").append(userCnt).append(" user").append(userCnt != 1 ? "s" : "");
            sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(feedEntryCnt != 1 ? "ies" : "y");
            sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
            logger.info((Object)sb.toString());
            return;
        }
        if (!logger.isTraceEnabled()) return;
        logger.trace((Object)"Nothing to send since no new user activities found");
    }

    protected Pair<Integer, Long> prepareAndSendEmail(NodeRef personNodeRef, NodeRef emailTemplateRef, String subjectText, Map<String, String> siteNames, String shareUrl, int repeatIntervalMins) {
        Map personProps = this.nodeService.getProperties(personNodeRef);
        String feedUserId = (String)personProps.get(ContentModel.PROP_USERNAME);
        String emailAddress = (String)personProps.get(ContentModel.PROP_EMAIL);
        Boolean emailFeedDisabled = (Boolean)personProps.get(ContentModel.PROP_EMAIL_FEED_DISABLED);
        if (this.skipUser(emailFeedDisabled, feedUserId, emailAddress, this.excludedEmailSuffixes)) {
            return null;
        }
        Long emailFeedDBID = (Long)personProps.get(ContentModel.PROP_EMAIL_FEED_ID);
        if (emailFeedDBID != null) {
            Long l = emailFeedDBID;
            Long l2 = emailFeedDBID = Long.valueOf(emailFeedDBID + 1L);
        } else {
            emailFeedDBID = -1L;
        }
        List<ActivityFeedEntity> feedEntries = this.activityService.getUserFeedEntries(feedUserId, "json", null, false, false, null, null, emailFeedDBID);
        if (feedEntries.size() > 0) {
            long userMaxFeedId = -1L;
            HashMap<String, Object> model = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> activityFeedModels = new ArrayList<Map<String, Object>>();
            for (ActivityFeedEntity feedEntry : feedEntries) {
                Map<String, Object> map = null;
                try {
                    map = feedEntry.getModel();
                    activityFeedModels.add(map);
                    String siteId = feedEntry.getSiteNetwork();
                    this.addSiteName(siteId, siteNames);
                    long feedId = feedEntry.getId();
                    if (feedId <= userMaxFeedId) continue;
                    userMaxFeedId = feedId;
                }
                catch (JSONException je) {
                    logger.warn((Object)("Skip feed entry for user (" + feedUserId + "): " + je.getMessage()));
                }
            }
            if (activityFeedModels.size() > 0) {
                model.put("activities", activityFeedModels);
                model.put("siteTitles", siteNames);
                model.put("repeatIntervalMins", repeatIntervalMins);
                model.put("feedItemsMax", this.activityService.getMaxFeedItems());
                model.put("feedItemsCount", activityFeedModels.size());
                model.put("productName", ModelUtil.getProductName(this.repoAdminService));
                HashMap personPrefixProps = new HashMap(personProps.size());
                for (QName propQName : personProps.keySet()) {
                    try {
                        String propPrefix = propQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
                        personPrefixProps.put(propPrefix, personProps.get(propQName));
                    }
                    catch (NamespaceException ne) {
                        logger.warn((Object)("Ignoring property '" + propQName + "' as it's namespace is not registered"));
                    }
                }
                model.put("personProps", personPrefixProps);
                this.sendMail(emailTemplateRef, emailAddress, subjectText, model);
                return new Pair((Object)activityFeedModels.size(), (Object)userMaxFeedId);
            }
        }
        return null;
    }

    protected void sendMail(NodeRef emailTemplateRef, String emailAddress, String subjectText, Map<String, Object> model) {
        ParameterCheck.mandatoryString((String)"emailAddress", (String)emailAddress);
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("to", (Serializable)((Object)emailAddress));
        mail.setParameterValue("subject", (Serializable)((Object)subjectText));
        mail.setParameterValue("template", (Serializable)emailTemplateRef);
        mail.setParameterValue("template_model", (Serializable)((Object)model));
        this.actionService.executeAction(mail, null);
    }

    protected String buildSubjectText(long currentTime) {
        return I18NUtil.getMessage((String)MSG_EMAIL_SUBJECT, (Object[])new Object[]{ModelUtil.getProductName(this.repoAdminService)});
    }

    protected NodeRef getEmailTemplateRef() {
        StoreRef store = this.feedEmailTemplateLocation.getStoreRef();
        String xpath = this.feedEmailTemplateLocation.getPath();
        if (!this.feedEmailTemplateLocation.getQueryLanguage().equals("xpath")) {
            logger.warn((Object)("Cannot find the activities email template - repository location query language is not 'xpath': " + this.feedEmailTemplateLocation.getQueryLanguage()));
            return null;
        }
        List nodeRefs = this.searchService.selectNodes(this.nodeService.getRootNode(store), xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() != 1) {
            logger.warn((Object)("Cannot find the activities email template: " + xpath));
            return null;
        }
        return this.fileFolderService.getLocalizedSibling((NodeRef)nodeRefs.get(0));
    }

    protected void addSiteName(String siteId, Map<String, String> siteNames) {
        if (siteId == null) {
            return;
        }
        String siteName = siteNames.get(siteId);
        if (siteName == null) {
            SiteInfo site = this.siteService.getSite(siteId);
            if (site == null) {
                return;
            }
            String siteTitle = site.getTitle();
            siteName = siteTitle != null && siteTitle.length() > 0 ? siteTitle : siteId;
            siteNames.put(siteId, siteName);
        }
    }

    protected boolean skipUser(Boolean emailFeedDisabled, String feedUserId, String emailAddress, List<String> excludedEmailSuffixes) {
        if (emailFeedDisabled != null && emailFeedDisabled.booleanValue()) {
            return true;
        }
        if (this.authenticationContext.isSystemUserName(feedUserId) || this.authenticationContext.isGuestUserName(feedUserId)) {
            return true;
        }
        if (emailAddress == null || emailAddress.length() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skip for '" + feedUserId + "' since they have no email address set"));
            }
            return true;
        }
        String lowerEmailAddress = emailAddress.toLowerCase();
        for (String excludedEmailSuffix : excludedEmailSuffixes) {
            if (!lowerEmailAddress.endsWith(excludedEmailSuffix.toLowerCase())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skip for '" + feedUserId + "' since email address is excluded (" + emailAddress + ")"));
            }
            return true;
        }
        return false;
    }

    private void refreshLock() {
        Pair lockPair = lockThreadLocal.get();
        if (lockPair == null) {
            String lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
            Long lastLock = new Long(System.currentTimeMillis());
            lockPair = new Pair((Object)lastLock, (Object)lockToken);
            lockThreadLocal.set((Pair<Long, String>)lockPair);
        } else {
            long now = System.currentTimeMillis();
            long lastLock = (Long)lockPair.getFirst();
            String lockToken = (String)lockPair.getSecond();
            if (now - lastLock > 15000L) {
                this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L);
                lastLock = System.currentTimeMillis();
                lockPair = new Pair((Object)lastLock, (Object)lockToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock() {
        Pair<Long, String> lockPair = lockThreadLocal.get();
        if (lockPair != null) {
            try {
                this.jobLockService.releaseLock((String)lockPair.getSecond(), LOCK_QNAME);
                Object var3_2 = null;
                lockThreadLocal.set(null);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lockThreadLocal.set(null);
                throw throwable;
            }
        }
    }
}

