/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.File;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.IndexConfigurationChecker;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class IndexConfigurationCheckerBootstrapBean
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(IndexConfigurationCheckerBootstrapBean.class);
    private IndexConfigurationChecker indexConfigurationChecker;
    private RepositoryState repositoryState;
    private TransactionService transactionService;
    private boolean strict;
    private String dirRoot;

    protected void onBootstrap(ApplicationEvent event) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                if (IndexConfigurationCheckerBootstrapBean.this.repositoryState == null || !IndexConfigurationCheckerBootstrapBean.this.repositoryState.isBootstrapping()) {
                    log.info((Object)"Checking/Recovering indexes ...");
                    IndexConfigurationCheckerBootstrapBean.this.check();
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, true);
    }

    private void check() {
        String msg;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting index configuration check: " + (Object)((Object)this)));
        }
        File dirRootFile = new File(this.dirRoot);
        List<StoreRef> missingIndexStoreRefs = this.indexConfigurationChecker.checkIndexConfiguration();
        int missingStoreIndexes = missingIndexStoreRefs.size();
        if (missingStoreIndexes > 0) {
            msg = I18NUtil.getMessage((String)"system.config_check.err.missing_index", (Object[])new Object[]{missingStoreIndexes});
            logger.error((Object)msg);
            String msgRecover = I18NUtil.getMessage((String)"system.config_check.msg.howto_index_recover");
            logger.info((Object)msgRecover);
        }
        if (missingStoreIndexes > 0) {
            msg = I18NUtil.getMessage((String)"system.config_check.err.fix_dir_root", (Object[])new Object[]{dirRootFile});
            logger.error((Object)msg);
            if (this.strict) {
                throw new AlfrescoRuntimeException(msg);
            }
            String warn = I18NUtil.getMessage((String)"system.config_check.warn.starting_with_errors");
            logger.warn((Object)warn);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public IndexConfigurationChecker getIndexConfigurationChecker() {
        return this.indexConfigurationChecker;
    }

    public void setIndexConfigurationChecker(IndexConfigurationChecker indexConfigurationChecker) {
        this.indexConfigurationChecker = indexConfigurationChecker;
    }

    public RepositoryState getRepositoryState() {
        return this.repositoryState;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setDirRoot(String dirRoot) {
        this.dirRoot = dirRoot;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

