/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.RepoModelDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class RepoAdminServiceImplTest
extends TestCase {
    private static Log logger = LogFactory.getLog(RepoAdminServiceImplTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private RepoAdminService repoAdminService;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    final String modelPrefix = "model-";
    static final String MKR = "{MKR}";
    public static final String MODEL_MKR_XML = "<model name='ratest-{MKR}:testModel{MKR}' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model {MKR}</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>      <import uri='http://www.alfresco.org/model/content/1.0' prefix='cm'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel{MKR}/1.0' prefix='ratest-{MKR}'/>   </namespaces>   <types>      <type name='ratest-{MKR}:base'>        <title>Base</title>        <description>The Base Type</description>        <parent>cm:content</parent>        <properties>           <property name='ratest-{MKR}:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";

    protected void setUp() throws Exception {
        super.setUp();
        this.repoAdminService = (RepoAdminService)ctx.getBean("RepoAdminService");
        this.dictionaryService = (DictionaryService)ctx.getBean("DictionaryService");
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.searchService = (SearchService)ctx.getBean("SearchService");
        this.namespaceService = (NamespaceService)ctx.getBean("NamespaceService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetup() throws Exception {
    }

    public void xtestRepeat() throws Exception {
        int cnt = 10;
        for (int i = 1; i <= cnt; ++i) {
            System.out.println("Itr: " + i + " out of " + cnt);
            this.testSimpleDynamicModelViaNodeService();
            this.testSimpleDynamicModelViaRepoAdminService();
            this.testConcurrentDynamicModelCreate();
            this.testConcurrentDynamicModelDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleDynamicModelViaNodeService() throws Exception {
        String X = "A";
        String modelFileName = "model-A.xml";
        QName typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelA/1.0}base");
        QName modelName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelA/1.0}testModelA");
        try {
            if (this.isModelDeployed("model-A.xml")) {
                this.repoAdminService.undeployModel("model-A.xml");
            }
            StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
            NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
            int defaultModelCnt = this.dictionaryService.getAllModels().size();
            String model = MODEL_MKR_XML.replace(MKR, "A");
            ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
            List nodeRefs = this.searchService.selectNodes(rootNodeRef, "/app:company_home/app:dictionary/app:models", null, (NamespacePrefixResolver)this.namespaceService, false);
            RepoAdminServiceImplTest.assertEquals((int)1, (int)nodeRefs.size());
            NodeRef modelsNodeRef = (NodeRef)nodeRefs.get(0);
            HashMap<QName, String> contentProps = new HashMap<QName, String>();
            contentProps.put(ContentModel.PROP_NAME, "model-A.xml");
            NodeRef model1 = this.nodeService.createNode(modelsNodeRef, ContentModel.ASSOC_CONTAINS, modelName, ContentModel.TYPE_DICTIONARY_MODEL, contentProps).getChildRef();
            HashMap<QName, String> titledProps = new HashMap<QName, String>();
            titledProps.put(ContentModel.PROP_TITLE, "model-A.xml");
            titledProps.put(ContentModel.PROP_DESCRIPTION, "model-A.xml");
            this.nodeService.addAspect(model1, ContentModel.ASPECT_TITLED, titledProps);
            ContentWriter writer = this.contentService.getWriter(model1, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/xml");
            writer.setEncoding("UTF-8");
            writer.putContent((InputStream)modelStream);
            ((InputStream)modelStream).close();
            this.nodeService.setProperty(model1, ContentModel.PROP_MODEL_ACTIVE, (Serializable)new Boolean(true));
            RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
            ClassDefinition myType = this.dictionaryService.getClass(typeName);
            RepoAdminServiceImplTest.assertNotNull((Object)myType);
            RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
            NodeRef node1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), typeName, null).getChildRef();
            try {
                this.nodeService.deleteNode(model1);
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Failed to validate model delete"));
            }
            this.nodeService.deleteNode(node1);
            RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(node1));
            NodeRef archiveRootNode = this.nodeService.getStoreArchiveNode(storeRef);
            NodeRef archiveNode1 = new NodeRef(archiveRootNode.getStoreRef(), node1.getId());
            RepoAdminServiceImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode1));
            try {
                this.nodeService.deleteNode(model1);
                RepoAdminServiceImplTest.fail();
            }
            catch (AlfrescoRuntimeException are) {
                RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Failed to validate model delete"));
            }
            this.nodeService.deleteNode(archiveNode1);
            RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(archiveNode1));
            this.nodeService.deleteNode(model1);
            RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
            RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
            NodeRef archiveModel1 = new NodeRef(archiveRootNode.getStoreRef(), model1.getId());
            this.nodeService.restoreNode(archiveModel1, null, null, null);
            RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
            RepoAdminServiceImplTest.assertNotNull((Object)this.dictionaryService.getClass(typeName));
            this.nodeService.deleteNode(model1);
            this.nodeService.deleteNode(archiveModel1);
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleDynamicModelViaRepoAdminService() throws Exception {
        QName typeName;
        block14: {
            String X = "B";
            String modelFileName = "model-B.xml";
            typeName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelB/1.0}base");
            QName modelName = QName.createQName((String)"{http://www.alfresco.org/test/testmodelB/1.0}testModelB");
            try {
                if (this.isModelDeployed("model-B.xml")) {
                    this.repoAdminService.undeployModel("model-B.xml");
                }
                RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-B.xml"));
                RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
                int defaultModelCnt = this.dictionaryService.getAllModels().size();
                String model = MODEL_MKR_XML.replace(MKR, "B");
                ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                this.repoAdminService.deployModel(modelStream, "model-B.xml");
                RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
                RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
                ClassDefinition myType = this.dictionaryService.getClass(typeName);
                RepoAdminServiceImplTest.assertNotNull((Object)myType);
                RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
                modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                this.repoAdminService.deployModel(modelStream, "model-B.xml");
                this.repoAdminService.deactivateModel("model-B.xml");
                RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
                RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
                RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
                try {
                    this.repoAdminService.deactivateModel("model-B.xml");
                    RepoAdminServiceImplTest.fail();
                }
                catch (AlfrescoRuntimeException are) {
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model deactivation failed"));
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is already deactivated"));
                }
                this.repoAdminService.activateModel("model-B.xml");
                RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-B.xml"));
                RepoAdminServiceImplTest.assertEquals((int)(defaultModelCnt + 1), (int)this.dictionaryService.getAllModels().size());
                myType = this.dictionaryService.getClass(typeName);
                RepoAdminServiceImplTest.assertNotNull((Object)myType);
                RepoAdminServiceImplTest.assertEquals((Object)modelName, (Object)myType.getModel().getName());
                try {
                    this.repoAdminService.activateModel("model-B.xml");
                    RepoAdminServiceImplTest.fail();
                }
                catch (AlfrescoRuntimeException are) {
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model activation failed"));
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("is already activated"));
                }
                StoreRef storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
                NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
                NodeRef node1 = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node1"), typeName, null).getChildRef();
                try {
                    this.repoAdminService.undeployModel("model-B.xml");
                    RepoAdminServiceImplTest.fail();
                }
                catch (AlfrescoRuntimeException are) {
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("Failed to validate model delete"));
                }
                this.nodeService.deleteNode(node1);
                RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(node1));
                NodeRef archiveRootNode = this.nodeService.getStoreArchiveNode(storeRef);
                NodeRef archiveNode1 = new NodeRef(archiveRootNode.getStoreRef(), node1.getId());
                RepoAdminServiceImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode1));
                try {
                    this.repoAdminService.undeployModel("model-B.xml");
                    RepoAdminServiceImplTest.fail();
                }
                catch (AlfrescoRuntimeException are) {
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("Failed to validate model delete"));
                }
                this.nodeService.deleteNode(archiveNode1);
                RepoAdminServiceImplTest.assertFalse((boolean)this.nodeService.exists(archiveNode1));
                this.repoAdminService.undeployModel("model-B.xml");
                RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-B.xml"));
                RepoAdminServiceImplTest.assertEquals((int)defaultModelCnt, (int)this.dictionaryService.getAllModels().size());
                RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
                try {
                    this.repoAdminService.undeployModel("model-B.xml");
                    RepoAdminServiceImplTest.fail();
                }
                catch (AlfrescoRuntimeException are) {
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getMessage().contains("Model undeployment failed"));
                    RepoAdminServiceImplTest.assertTrue((boolean)are.getCause().getMessage().contains("Could not find custom model"));
                }
                Object var16_19 = null;
                if (!this.isModelDeployed("model-B.xml")) break block14;
                this.repoAdminService.undeployModel("model-B.xml");
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (this.isModelDeployed("model-B.xml")) {
                    this.repoAdminService.undeployModel("model-B.xml");
                }
                RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
                throw throwable;
            }
            {
            }
        }
        RepoAdminServiceImplTest.assertNull((Object)this.dictionaryService.getClass(typeName));
    }

    private boolean isModelDeployed(String modelFileName) {
        for (RepoModelDefinition modelDef : this.repoAdminService.getModels()) {
            if (!modelDef.getRepoName().equals(modelFileName)) continue;
            return true;
        }
        return false;
    }

    private void undeployModels(int modelCnt) {
        for (int i = 1; i <= modelCnt; ++i) {
            if (!this.isModelDeployed("model-" + i)) continue;
            this.repoAdminService.undeployModel("model-" + i);
        }
    }

    private void deployModels(int modelCnt) throws UnsupportedEncodingException {
        for (int i = 1; i <= modelCnt; ++i) {
            if (!this.isModelDeployed("model-" + i)) {
                String model = MODEL_MKR_XML.replace(MKR, i + "");
                ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                this.repoAdminService.deployModel(modelStream, "model-" + i);
                logger.info((Object)("[" + i + "] Deployed - test model: " + "model-" + i));
                continue;
            }
            logger.warn((Object)("[" + i + "] Already deployed - test model: " + "model-" + i));
        }
    }

    public void testConcurrentDynamicModelCreate() throws Exception {
        int n = 2;
        this.undeployModels(2);
        int deployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("Before deploy: deployed custom model count: " + deployedModelCount));
        int dictModelCount = this.getModelCount();
        logger.info((Object)("Before deploy: dictionary model count: " + dictModelCount));
        this.runConcurrentOps(2, 1);
        int newDeployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("After deploy: deployed custom model count: " + newDeployedModelCount));
        RepoAdminServiceImplTest.assertEquals((int)(deployedModelCount + 2), (int)newDeployedModelCount);
        for (int i = 1; i <= 2; ++i) {
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-" + i));
        }
        int newDictModelCount = this.getModelCount();
        logger.info((Object)("After deploy: dictionary model count: " + newDictModelCount));
        RepoAdminServiceImplTest.assertEquals((int)(dictModelCount + 2), (int)newDictModelCount);
        this.undeployModels(2);
        newDeployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("After undeploy: deployed custom model count: " + newDeployedModelCount));
        RepoAdminServiceImplTest.assertEquals((int)deployedModelCount, (int)newDeployedModelCount);
        newDictModelCount = this.getModelCount();
        logger.info((Object)("After undeploy: dictionary model count: " + newDictModelCount));
        RepoAdminServiceImplTest.assertEquals((int)dictModelCount, (int)newDictModelCount);
    }

    public void testConcurrentDynamicModelDelete() throws Exception {
        int i;
        int n = 2;
        this.undeployModels(2);
        int deployedModelCount = this.repoAdminService.getModels().size();
        logger.info((Object)("Existing deployed custom model count: " + deployedModelCount));
        int dictModelCount = this.getModelCount();
        logger.info((Object)("Existing dictionary model count: " + dictModelCount));
        this.deployModels(2);
        RepoAdminServiceImplTest.assertEquals((int)(deployedModelCount + 2), (int)this.repoAdminService.getModels().size());
        for (i = 1; i <= 2; ++i) {
            RepoAdminServiceImplTest.assertTrue((boolean)this.isModelDeployed("model-" + i));
        }
        RepoAdminServiceImplTest.assertEquals((int)(dictModelCount + 2), (int)this.getModelCount());
        this.runConcurrentOps(2, 2);
        RepoAdminServiceImplTest.assertEquals((int)deployedModelCount, (int)this.repoAdminService.getModels().size());
        for (i = 1; i <= 2; ++i) {
            RepoAdminServiceImplTest.assertFalse((boolean)this.isModelDeployed("model-" + i));
        }
        RepoAdminServiceImplTest.assertEquals((int)dictModelCount, (int)this.getModelCount());
    }

    private int getModelCount() {
        return this.dictionaryService.getAllModels().size();
    }

    private void runConcurrentOps(int threadCnt, int opType) throws InterruptedException {
        int i;
        Thread[] threads = new Thread[threadCnt];
        Tester[] testers = new Tester[threadCnt];
        for (i = 0; i < threadCnt; ++i) {
            Tester tester;
            testers[i] = tester = new Tester(i + 1, opType);
            threads[i] = new Thread(tester);
            threads[i].start();
        }
        for (i = 0; i < threadCnt; ++i) {
            threads[i].join();
            if (testers[i].getErrorStackTrace() == null) continue;
            RepoAdminServiceImplTest.fail((String)testers[i].getErrorStackTrace());
        }
    }

    private class Tester
    implements Runnable {
        private int i;
        private int opType;
        private String errorStackTrace = null;

        public Tester(int i, int opType) {
            this.i = i;
            this.opType = opType;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        public void run() {
            try {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                RepoAdminServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        if (Tester.this.opType == 1) {
                            String model = RepoAdminServiceImplTest.MODEL_MKR_XML.replace(RepoAdminServiceImplTest.MKR, Tester.this.i + "");
                            ByteArrayInputStream modelStream = new ByteArrayInputStream(model.getBytes("UTF-8"));
                            RepoAdminServiceImplTest.this.repoAdminService.deployModel(modelStream, "model-" + Tester.this.i);
                            logger.info((Object)("[" + Tester.this.i + "] Deploying - test model: " + "model-" + Tester.this.i));
                        } else if (Tester.this.opType == 2) {
                            RepoAdminServiceImplTest.this.repoAdminService.undeployModel("model-" + Tester.this.i);
                            logger.info((Object)("[" + Tester.this.i + "] Undeployed - test model: " + "model-" + Tester.this.i));
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                this.errorStackTrace = sw.toString();
                logger.error((Object)("[" + this.i + "] Failed to " + (this.opType == 1 ? "deploy" : "undeploy") + " test model: " + t));
            }
        }
    }
}

