/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.springframework.extensions.surf.util.I18NUtil;

public class CalendarModelUriPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.calendarModelNamespacePatch.result";
    private static final String URI_BEFORE = "com.infoaxon.alfresco.calendar";
    private static final String URI_AFTER = "http://www.alfresco.org/model/calendar";
    private ImporterBootstrap importerBootstrap;
    private IndexerAndSearcher indexerAndSearcher;
    private QNameDAO qnameDAO;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    protected String applyInternal() throws Exception {
        this.qnameDAO.getOrCreateNamespace(URI_BEFORE);
        this.qnameDAO.updateNamespace(URI_BEFORE, URI_AFTER);
        int count = this.reindex("TYPE:\\{" + AbstractLuceneQueryParser.escape((String)URI_BEFORE) + "\\}*", this.importerBootstrap.getStoreRef());
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{count});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int reindex(String query, StoreRef store) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery(query);
        sp.addStore(store);
        Indexer indexer = this.indexerAndSearcher.getIndexer(store);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = this.searchService.query(sp);
            count = rs.length();
            for (ResultSetRow row : rs) {
                indexer.updateNode(row.getNodeRef());
            }
            Object var10_9 = null;
            if (rs == null) return count;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return count;
    }
}

