/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import java.util.Properties;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class ClearOldImapMessgesPatch
extends AbstractPatch {
    private static final String MSG_REMOVED = "patch.imap.clear.old.messages.description.cleared";
    private static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    private static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    private static final String PROPERTY_SCRIPTS_CHILDNAME = "spaces.scripts.childname";
    private static final String PROPERTY_IMAP_CONFIG_CHILDNAME = "spaces.imapConfig.childname";
    private static final String PROPERTY_IMAP_TEMPLATES_CHILDNAME = "spaces.imap_templates.childname";
    private ImporterBootstrap importerBootstrap;
    protected Properties configuration;
    private NodeRef imapTemplatesFolderNodeRef;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String scriptsChildName = this.configuration.getProperty(PROPERTY_SCRIPTS_CHILDNAME);
        if (scriptsChildName == null || scriptsChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.scripts.childname' is not present");
        }
        String imapConfigChildName = this.configuration.getProperty(PROPERTY_IMAP_CONFIG_CHILDNAME);
        if (imapConfigChildName == null || imapConfigChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.imapConfig.childname' is not present");
        }
        String imapTemplatesChildName = this.configuration.getProperty(PROPERTY_IMAP_TEMPLATES_CHILDNAME);
        if (imapConfigChildName == null || imapConfigChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.imapConfig.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/").append(companyHomeChildName);
        sb.append("/").append(dictionaryChildName);
        sb.append("/").append(imapConfigChildName);
        sb.append("/").append(imapTemplatesChildName);
        String xpath = sb.toString();
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.imapTemplatesFolderNodeRef = nodeRefs.size() == 0 ? null : (NodeRef)nodeRefs.get(0);
    }

    protected String applyInternal() throws Exception {
        this.setUp();
        if (this.imapTemplatesFolderNodeRef != null) {
            NodeRef oldTextPlain = this.nodeService.getChildByName(this.imapTemplatesFolderNodeRef, ContentModel.ASSOC_CONTAINS, "emailbody-textplain.ftl");
            NodeRef oldTextHTML = this.nodeService.getChildByName(this.imapTemplatesFolderNodeRef, ContentModel.ASSOC_CONTAINS, "emailbody-texthtml.ftl");
            if (oldTextPlain != null) {
                this.nodeService.deleteNode(oldTextPlain);
            }
            if (oldTextHTML != null) {
                this.nodeService.deleteNode(oldTextHTML);
            }
        }
        return I18NUtil.getMessage((String)MSG_REMOVED);
    }
}

