/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrTenantsPatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MSG_SUCCESS = "patch.migrateAttrTenants.result";
    private AttributeService attributeService;
    private PatchDAO patchDAO;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        TenantResultHandler handler = new TenantResultHandler();
        this.patchDAO.migrateOldAttrTenants(handler);
        if (handler.total > 0) {
            this.logger.info((Object)("Processed " + handler.total + " Tenant attrs in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{handler.total});
        return msg;
    }

    private class TenantResultHandler
    implements ResultHandler {
        private int total = 0;

        private TenantResultHandler() {
        }

        public void handleResult(ResultContext context) {
            Map result = (Map)context.getResultObject();
            String tenantDomain = (String)result.get("tenantDomain");
            Boolean isEnabled = (Boolean)result.get("isEnabled");
            String rootDir = (String)result.get("rootDir");
            HashMap<String, Object> tenantAttributes = new HashMap<String, Object>(7);
            tenantAttributes.put("enabled", isEnabled);
            tenantAttributes.put("rootContentStoreDir", rootDir);
            MigrateAttrTenantsPatch.this.attributeService.setAttribute(tenantAttributes, new Serializable[]{"alfresco-tenants", tenantDomain});
            if (MigrateAttrTenantsPatch.this.logger.isTraceEnabled()) {
                MigrateAttrTenantsPatch.this.logger.trace((Object)("Set Tenant attr [tenantDomain=" + tenantDomain + ", isEnabled=" + isEnabled + ", rootDir=" + rootDir + "]"));
            }
            ++this.total;
            if (MigrateAttrTenantsPatch.this.logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                MigrateAttrTenantsPatch.this.logger.debug((Object)("   Handled " + this.total + " tenant attributes"));
            }
        }
    }
}

