/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.VersionMigrator;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateVersionStorePatch
extends AbstractPatch {
    private static Log logger = LogFactory.getLog(MigrateVersionStorePatch.class);
    public static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"MigrateVersionStore");
    public static final long LOCK_TTL = 30000L;
    private static final String MSG_DONE = "patch.migrateVersionStore.done";
    private static final String MSG_INCOMPLETE = "patch.migrateVersionStore.incomplete";
    private VersionMigrator versionMigrator;
    private TenantService tenantService;
    private ImporterBootstrap version2ImporterBootstrap;
    private JobLockService jobLockService;
    private int batchSize = 1;
    private int threadCount = 2;
    private int limitPerJobCycle = -1;
    private boolean migrationComplete = false;
    private boolean deleteImmediately = false;
    private boolean runAsScheduledJob = false;
    private boolean useDeprecatedV1 = false;
    private ThreadLocal<Boolean> runningAsJob = new ThreadLocal();

    public MigrateVersionStorePatch() {
        this.runningAsJob.set(Boolean.FALSE);
    }

    public void setVersionMigrator(VersionMigrator versionMigrator) {
        this.versionMigrator = versionMigrator;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setImporterBootstrap(ImporterBootstrap version2ImporterBootstrap) {
        this.version2ImporterBootstrap = version2ImporterBootstrap;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setLimitPerJobCycle(int limitPerJobCycle) {
        this.limitPerJobCycle = limitPerJobCycle;
    }

    public void setDeleteImmediately(boolean deleteImmediately) {
        this.deleteImmediately = deleteImmediately;
    }

    public void setRunAsScheduledJob(boolean runAsScheduledJob) {
        this.runAsScheduledJob = runAsScheduledJob;
    }

    public void setOnlyUseDeprecatedV1(boolean useDeprecatedV1) {
        this.useDeprecatedV1 = useDeprecatedV1;
    }

    public void init() {
        if (this.batchSize < 1) {
            String errorMessage = "batchSize (" + this.batchSize + ") cannot be less than 1";
            logger.error((Object)errorMessage);
            throw new AlfrescoRuntimeException(errorMessage);
        }
        if (this.threadCount < 1) {
            String errorMessage = "threadCount (" + this.threadCount + ") cannot be less than 1";
            logger.error((Object)errorMessage);
            throw new AlfrescoRuntimeException(errorMessage);
        }
        super.init();
    }

    private void executeViaJob() {
        AuthenticationUtil.RunAsWork<String> patchRunAs = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<String> patchTxn = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String execute() throws Exception {
                        try {
                            String report;
                            MigrateVersionStorePatch.this.runningAsJob.set(Boolean.TRUE);
                            String string = report = MigrateVersionStorePatch.this.applyInternal();
                            Object var4_3 = null;
                            MigrateVersionStorePatch.this.runningAsJob.set(Boolean.FALSE);
                            return string;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            MigrateVersionStorePatch.this.runningAsJob.set(Boolean.FALSE);
                            throw throwable;
                        }
                    }
                };
                return MigrateVersionStorePatch.this.transactionHelper.doInTransaction(patchTxn);
            }
        };
        String report = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)patchRunAs, (String)AuthenticationUtil.getSystemUserName());
        if (report != null) {
            logger.info((Object)report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        String lockToken;
        block14: {
            boolean isRunningAsJob;
            block15: {
                block13: {
                    if (this.useDeprecatedV1) {
                        return null;
                    }
                    if (this.migrationComplete) {
                        return null;
                    }
                    isRunningAsJob = this.runningAsJob.get();
                    if (this.runAsScheduledJob && !isRunningAsJob) {
                        return I18NUtil.getMessage((String)"patch.migrateVersionStore.bypassingPatch");
                    }
                    lockToken = this.getLock();
                    if (lockToken == null) {
                        if (isRunningAsJob) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Cannot get lock - an earlier job is still busy (or previous lock has not yet expired after failure - TTL was 30000 ms)");
                            }
                            return null;
                        }
                        throw new RuntimeException("Unable to get job lock during patch execution.  Only one server should perform the upgrade.");
                    }
                    if (isRunningAsJob && !this.deleteImmediately) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"VersionMigrator is running as a background job will immediately delete old versions (after they are migrated");
                        }
                        this.deleteImmediately = true;
                    }
                    try {
                        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> preMigrate = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                            @Override
                            public Boolean execute() throws Throwable {
                                if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
                                    return false;
                                }
                                if (MigrateVersionStorePatch.this.tenantService.isEnabled() && MigrateVersionStorePatch.this.tenantService.isTenantUser()) {
                                    StoreRef bootstrapStoreRef = MigrateVersionStorePatch.this.version2ImporterBootstrap.getStoreRef();
                                    if (!MigrateVersionStorePatch.this.nodeService.exists(bootstrapStoreRef)) {
                                        bootstrapStoreRef = MigrateVersionStorePatch.this.tenantService.getName(AuthenticationUtil.getRunAsUser(), bootstrapStoreRef);
                                        MigrateVersionStorePatch.this.version2ImporterBootstrap.setStoreUrl(bootstrapStoreRef.toString());
                                        MigrateVersionStorePatch.this.version2ImporterBootstrap.bootstrap();
                                    }
                                }
                                if (AuthenticationUtil.getRunAsUser() == null) {
                                    logger.info((Object)"Set system user");
                                    AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
                                }
                                return true;
                            }
                        };
                        Boolean doMigration = this.transactionHelper.doInTransaction(preMigrate);
                        if (doMigration.booleanValue()) break block13;
                        String string = null;
                        Object var8_7 = null;
                        this.releaseLock(lockToken);
                        return string;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        this.releaseLock(lockToken);
                        throw throwable;
                    }
                }
                Boolean migrated = this.versionMigrator.migrateVersions(this.batchSize, this.threadCount, this.limitPerJobCycle, this.deleteImmediately, lockToken, isRunningAsJob);
                boolean bl = this.migrationComplete = migrated != null ? migrated : true;
                if (migrated == null) break block14;
                if (!this.migrationComplete) break block15;
                String string = I18NUtil.getMessage((String)MSG_DONE);
                Object var8_8 = null;
                this.releaseLock(lockToken);
                return string;
            }
            if (isRunningAsJob) break block14;
            String string = I18NUtil.getMessage((String)MSG_INCOMPLETE);
            Object var8_9 = null;
            this.releaseLock(lockToken);
            return string;
        }
        String string = null;
        Object var8_10 = null;
        this.releaseLock(lockToken);
        return string;
    }

    private String getLock() {
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK, 30000L);
            if (lockToken != null && logger.isTraceEnabled()) {
                logger.trace((Object)("Got lock: " + lockToken + " with TTL of " + 30000L + " ms [" + AlfrescoTransactionSupport.getTransactionId() + "][" + Thread.currentThread().getId() + "]"));
            }
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            // empty catch block
        }
        return lockToken;
    }

    private void releaseLock(String lockToken) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.releaseLock(lockToken, LOCK);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Released lock: " + lockToken + " [" + AlfrescoTransactionSupport.getTransactionId() + "][" + Thread.currentThread().getId() + "]"));
        }
    }

    public static class MigrateVersionStoreJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object migrateVersionStoreObj = jobData.get((Object)"migrateVersionStore");
            if (migrateVersionStoreObj == null || !(migrateVersionStoreObj instanceof MigrateVersionStorePatch)) {
                throw new AlfrescoRuntimeException("'migrateVersionStore' data must contain valid 'MigrateVersionStore' reference");
            }
            MigrateVersionStorePatch migrateVersionStore = (MigrateVersionStorePatch)migrateVersionStoreObj;
            migrateVersionStore.executeViaJob();
        }
    }
}

