/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class PersonUsagePatch
extends AbstractPatch {
    private static Log logger = LogFactory.getLog(PersonUsagePatch.class);
    private static final String MSG_SUCCESS1 = "patch.personUsagePatch.result1";
    private static final String MSG_SUCCESS2 = "patch.personUsagePatch.result2";
    private PatchDAO patchDAO;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    protected String applyInternal() throws Exception {
        logger.info((Object)"Checking for people with missing 'cm:sizeCurrent' property ...");
        int count = this.addPersonSizeCurrentProperty();
        String msg = null;
        if (count > 0) {
            logger.info((Object)("... missing 'cm:sizeCurrent' property added to " + count + " people"));
            msg = I18NUtil.getMessage((String)MSG_SUCCESS1, (Object[])new Object[]{count});
        } else {
            logger.info((Object)"... no people were missing the 'cm:sizeCurrent' property");
            msg = I18NUtil.getMessage((String)MSG_SUCCESS2);
        }
        return msg;
    }

    private int addPersonSizeCurrentProperty() {
        return this.patchDAO.addSizeCurrentProp();
    }
}

