/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteLoadPatch
extends AbstractPatch {
    public static final String PROPERTIES_USERS = "users";
    public static final String PROPERTIES_PEOPLE = "people";
    public static final String PROPERTIES_GROUPS = "groups";
    public static final String PROPERTIES_CONTENTS = "contents";
    private static final Map<String, String> DEFAULT_PATHS = new HashMap<String, String>();
    private static final String MSG_SITE_ALREADY_EXISTS = "patch.siteLoadPatch.exists";
    private static final String MSG_NO_BOOTSTRAP_VIEWS_GIVEN = "patch.siteLoadPatch.noBootstrapViews";
    private static final String MSG_SITE_CREATED = "patch.siteLoadPatch.result";
    private static final Log logger;
    private AuthorityService authorityService;
    private BehaviourFilter behaviourFilter;
    private SiteService siteService;
    private String siteName;
    private ImporterBootstrap spacesBootstrap;
    private ImporterBootstrap usersBootstrap;
    private Map<String, Properties> bootstrapViews;

    public SiteLoadPatch() {
        this.setRequiresTransaction(true);
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setSpacesBootstrap(ImporterBootstrap spacesBootstrap) {
        this.spacesBootstrap = spacesBootstrap;
    }

    public void setUsersBootstrap(ImporterBootstrap usersBootstrap) {
        this.usersBootstrap = usersBootstrap;
    }

    public void setBootstrapViews(Map<String, Properties> bootstrapViews) {
        this.bootstrapViews = bootstrapViews;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"siteName", (Object)this.siteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        String string;
        AuthenticationUtil.pushAuthentication();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            string = this.applyInternalImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applyInternalImpl() throws Exception {
        ArrayList<Properties> views;
        if (this.bootstrapViews == null || this.bootstrapViews.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No Bootstraps given to import from - bootstrap import ignored");
            }
            return I18NUtil.getMessage((String)MSG_NO_BOOTSTRAP_VIEWS_GIVEN, (Object[])new Object[]{this.siteName});
        }
        if (this.siteService.getSite(this.siteName) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Site " + this.siteName + " already exists - bootstrap import ignored"));
            }
            return I18NUtil.getMessage((String)MSG_SITE_ALREADY_EXISTS, (Object[])new Object[]{this.siteName});
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing bootstrap of site " + this.siteName));
        }
        SiteInfo site = this.siteService.createSite(this.siteName, this.siteName, this.siteName, null, SiteVisibility.PUBLIC);
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        for (ImporterBootstrap bootstrap : new ImporterBootstrap[]{this.spacesBootstrap, this.usersBootstrap}) {
            bootstrap.setAllowWrite(true);
            bootstrap.setUseExistingStore(true);
            bootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.REPLACE_EXISTING);
        }
        for (String type : DEFAULT_PATHS.keySet()) {
            Properties props = this.bootstrapViews.get(type);
            if (props == null || DEFAULT_PATHS.get(type) == null || props.containsKey("path")) continue;
            props.setProperty("path", DEFAULT_PATHS.get(type));
        }
        if (this.bootstrapViews.containsKey(PROPERTIES_USERS)) {
            views = new ArrayList<Properties>(1);
            views.add(this.bootstrapViews.get(PROPERTIES_USERS));
            this.usersBootstrap.setBootstrapViews(views);
            this.usersBootstrap.bootstrap();
        }
        if (this.bootstrapViews.containsKey(PROPERTIES_PEOPLE)) {
            views = new ArrayList(1);
            views.add(this.bootstrapViews.get(PROPERTIES_PEOPLE));
            this.spacesBootstrap.setBootstrapViews(views);
            this.spacesBootstrap.bootstrap();
        }
        if (this.bootstrapViews.containsKey(PROPERTIES_GROUPS)) {
            try {
                this.doGroupImport(this.bootstrapViews.get(PROPERTIES_GROUPS).getProperty("location"));
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Bootstrap failed", t);
            }
        }
        if (this.bootstrapViews.containsKey(PROPERTIES_CONTENTS)) {
            this.behaviourFilter.disableBehaviour(site.getNodeRef(), ContentModel.ASPECT_UNDELETABLE);
            try {
                this.nodeService.addAspect(site.getNodeRef(), ContentModel.ASPECT_TEMPORARY, null);
                this.nodeService.deleteNode(site.getNodeRef());
                Object var7_9 = null;
                this.behaviourFilter.enableBehaviour(site.getNodeRef(), ContentModel.ASPECT_UNDELETABLE);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.behaviourFilter.enableBehaviour(site.getNodeRef(), ContentModel.ASPECT_UNDELETABLE);
                throw throwable;
            }
            views = new ArrayList(1);
            views.add(this.bootstrapViews.get(PROPERTIES_CONTENTS));
            this.spacesBootstrap.setBootstrapViews(views);
            this.spacesBootstrap.bootstrap();
        }
        return I18NUtil.getMessage((String)MSG_SITE_CREATED, (Object[])new Object[]{this.siteName});
    }

    private void doGroupImport(String location) throws Throwable {
        String line;
        File groupFile = ImporterBootstrap.getFile(location);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(groupFile), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            int splitAt = line.indexOf(61);
            if (splitAt == -1) {
                logger.warn((Object)("Invalid group line " + line));
                continue;
            }
            String user = line.substring(0, splitAt);
            Set<String> currentGroups = this.authorityService.getAuthoritiesForUser(user);
            StringTokenizer groups = new StringTokenizer(line.substring(splitAt + 1), ",");
            while (groups.hasMoreTokens()) {
                String group = groups.nextToken();
                if (currentGroups.contains(group)) continue;
                this.authorityService.addAuthority(group, user);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added user " + user + " to group " + group));
            }
        }
        reader.close();
    }

    static {
        DEFAULT_PATHS.put(PROPERTIES_USERS, "/${alfresco_user_store.system_container.childname}/${alfresco_user_store.user_container.childname}");
        DEFAULT_PATHS.put(PROPERTIES_PEOPLE, "/${system.system_container.childname}/${system.people_container.childname}");
        DEFAULT_PATHS.put(PROPERTIES_GROUPS, null);
        DEFAULT_PATHS.put(PROPERTIES_CONTENTS, "/${spaces.company_home.childname}/${spaces.sites.childname}");
        logger = LogFactory.getLog(SiteLoadPatch.class);
    }
}

