/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import java.util.Properties;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class SitesSpacePermissionsPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.sitesSpacePermissions.result";
    private static final String MSG_SUCCESS_NONE = "patch.sitesSpacePermissions.result.none";
    private static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    private static final String PROPERTY_SITES_CHILDNAME = "spaces.sites.childname";
    private NodeRef sitesNodeRef;
    private ImporterBootstrap importerBootstrap;
    private PermissionService permissionService;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull((Object)this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.permissionService, "permissionService");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        Properties configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String sitesChildName = configuration.getProperty(PROPERTY_SITES_CHILDNAME);
        if (sitesChildName == null || sitesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.sites.childname' is not present");
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("/").append(companyHomeChildName);
        sb.append("/").append(sitesChildName);
        String xpath = sb.toString();
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        this.sitesNodeRef = (NodeRef)nodeRefs.get(0);
    }

    protected String applyInternal() throws Exception {
        String msg;
        block3: {
            this.setUp();
            NodeRef sitesSpace = this.sitesNodeRef;
            if (sitesSpace == null || !this.nodeService.exists(sitesSpace)) {
                throw new IllegalStateException("Sites Space not found in Company Home!");
            }
            msg = I18NUtil.getMessage((String)MSG_SUCCESS);
            try {
                this.permissionService.deletePermission(sitesSpace, "GROUP_EVERYONE", "Contributor");
            }
            catch (IllegalStateException e) {
                if (!e.getMessage().contains("SHARED")) break block3;
                msg = I18NUtil.getMessage((String)MSG_SUCCESS_NONE);
            }
        }
        return msg;
    }
}

