/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.repo.audit.access.NodeInfo;
import org.alfresco.repo.audit.access.NodeInfoFactory;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeChange
implements NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
ContentServicePolicies.OnContentReadPolicy,
ContentServicePolicies.OnContentUpdatePolicy,
VersionServicePolicies.OnCreateVersionPolicy,
CopyServicePolicies.OnCopyCompletePolicy,
CheckOutCheckInServicePolicies.OnCheckOut,
CheckOutCheckInServicePolicies.OnCheckIn,
CheckOutCheckInServicePolicies.OnCancelCheckOut {
    private static final String USER = "user";
    private static final String ACTION = "action";
    private static final String SUB_ACTIONS = "sub-actions";
    private static final String NODE = "node";
    private static final String PATH = "path";
    private static final String TYPE = "type";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String COPY = "copy";
    private static final String MOVE = "move";
    private static final String PROPERTIES = "properties";
    private static final String ASPECTS = "aspects";
    private static final String VERSION_PROPERTIES = "version-properties";
    public static final String SUB_ACTION = "sub-action";
    private static final String DELETE_NODE = "deleteNode";
    private static final String CREATE_NODE = "createNode";
    private static final String MOVE_NODE = "moveNode";
    private static final String UPDATE_NODE_PROPERTIES = "updateNodeProperties";
    private static final String DELETE_NODE_ASPECT = "deleteNodeAspect";
    private static final String ADD_NODE_ASPECT = "addNodeAspect";
    private static final String CREATE_CONTENT = "createContent";
    private static final String UPDATE_CONTENT = "updateContent";
    private static final String READ_CONTENT = "readContent";
    private static final String CREATE_VERSION = "createVersion";
    private static final String COPY_NODE = "copyNode";
    private static final String CHECK_IN = "checkIn";
    private static final String CHECK_OUT = "checkOut";
    private static final String CANCEL_CHECK_OUT = "cancelCheckOut";
    private static final String INVALID_PATH_CHAR_REPLACEMENT = "-";
    private static final Pattern INVALID_PATH_COMP_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9:\\-\\_\\.]");
    public static Collection<String> SUMMARY_KEYS = new ArrayList<String>();
    public static final String SUB_ACTION_PREFIX = "sub-action/";
    private final NodeInfoFactory nodeInfoFactory;
    private final NamespaceService namespaceService;
    private NodeInfo nodeInfo;
    private String action;
    private boolean auditSubActions = false;
    private Set<String> subActions = new LinkedHashSet<String>();
    private List<Map<String, Serializable>> subActionAuditMaps;
    private NodeInfo copyFrom;
    private NodeInfo moveFrom;
    private Map<QName, Serializable> fromProperties;
    private Map<QName, Serializable> toProperties;
    private HashSet<QName> addedAspects;
    private HashSet<QName> deletedAspects;
    private HashMap<String, Serializable> versionProperties;

    NodeChange(NodeInfoFactory nodeInfoFactory, NamespaceService namespaceService, NodeRef nodeRef) {
        this.nodeInfoFactory = nodeInfoFactory;
        this.nodeInfo = nodeInfoFactory.newNodeInfo(nodeRef);
        this.namespaceService = namespaceService;
    }

    public String getDerivedAction() {
        String action = this.subActions.contains(CHECK_OUT) ? "CHECK OUT" : (this.subActions.contains(CHECK_IN) ? "CHECK IN" : (this.subActions.contains(CANCEL_CHECK_OUT) ? "CANCEL CHECK OUT" : (this.subActions.contains(COPY_NODE) ? "COPY" : (this.subActions.contains(CREATE_NODE) ? "CREATE" : (this.subActions.size() == 1 && this.subActions.contains(READ_CONTENT) ? "READ" : (this.subActions.contains(DELETE_NODE) ? "DELETE" : (this.subActions.contains(CREATE_VERSION) ? "CREATE VERSION" : (this.subActions.contains(UPDATE_CONTENT) ? "UPDATE CONTENT" : (this.subActions.contains(MOVE_NODE) ? "MOVE" : this.action)))))))));
        return action;
    }

    public boolean isTemporaryNode() {
        return this.subActions.contains(CREATE_NODE) && this.subActions.contains(DELETE_NODE);
    }

    private NodeChange setAction(String action) {
        this.action = action;
        return this;
    }

    private void appendSubAction(NodeChange subNodeChange) {
        this.subActions.add(subNodeChange.action);
        if (this.action == null) {
            this.action = subNodeChange.action;
        }
        if (this.auditSubActions) {
            if (this.subActionAuditMaps == null) {
                this.subActionAuditMaps = new ArrayList<Map<String, Serializable>>();
            }
            this.subActionAuditMaps.add(subNodeChange.getAuditData(true));
        }
    }

    public NodeChange setAuditSubActions(boolean auditSubActions) {
        this.auditSubActions = auditSubActions;
        return this;
    }

    private NodeChange setCopyFrom(NodeRef copyFrom) {
        this.copyFrom = this.nodeInfoFactory.newNodeInfo(copyFrom);
        return this;
    }

    private NodeChange setMoveFrom(ChildAssociationRef childAssocRef) {
        if (this.moveFrom == null) {
            this.moveFrom = this.nodeInfoFactory.newNodeInfo(childAssocRef);
        }
        return this;
    }

    private NodeChange setMoveTo(ChildAssociationRef childAssocRef) {
        this.nodeInfo = this.nodeInfoFactory.newNodeInfo(childAssocRef);
        if (this.nodeInfo.equals(this.moveFrom)) {
            this.moveFrom = null;
        }
        return this;
    }

    private NodeChange setFromProperties(Map<QName, Serializable> fromProperties) {
        if (this.fromProperties == null) {
            this.fromProperties = fromProperties;
        }
        return this;
    }

    private NodeChange setToProperties(Map<QName, Serializable> toProperties) {
        this.toProperties = toProperties;
        return this;
    }

    private NodeChange addAspect(QName aspect) {
        if (this.addedAspects == null) {
            this.addedAspects = new HashSet();
        }
        if (this.deletedAspects != null && this.deletedAspects.contains(aspect)) {
            this.deletedAspects.remove(aspect);
        } else {
            this.addedAspects.add(aspect);
        }
        return this;
    }

    private NodeChange deleteAspect(QName aspect) {
        if (this.deletedAspects == null) {
            this.deletedAspects = new HashSet();
        }
        if (this.addedAspects != null && this.addedAspects.contains(aspect)) {
            this.addedAspects.remove(aspect);
        } else {
            this.deletedAspects.add(aspect);
        }
        return this;
    }

    private NodeChange setVersionProperties(HashMap<String, Serializable> versionProperties) {
        if (this.versionProperties == null) {
            this.versionProperties = new HashMap();
        }
        this.versionProperties.putAll(versionProperties);
        return this;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(DELETE_NODE));
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        Map<QName, Serializable> fromProperties = Collections.emptyMap();
        Map<QName, Serializable> toProperties = this.nodeInfoFactory.getProperties(nodeRef);
        this.fromProperties = null;
        this.setFromProperties(fromProperties);
        this.setToProperties(toProperties);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(CREATE_NODE).setFromProperties(fromProperties).setToProperties(toProperties));
    }

    @Override
    public void onMoveNode(ChildAssociationRef fromChildAssocRef, ChildAssociationRef toChildAssocRef) {
        this.setMoveFrom(fromChildAssocRef);
        this.setMoveTo(toChildAssocRef);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, toChildAssocRef.getChildRef()).setAction(MOVE_NODE).setMoveFrom(fromChildAssocRef).setMoveTo(toChildAssocRef));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> fromProperties, Map<QName, Serializable> toProperties) {
        if (fromProperties.isEmpty() && this.toProperties != null) {
            fromProperties = this.toProperties;
        }
        this.setFromProperties(fromProperties);
        this.setToProperties(toProperties);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(UPDATE_NODE_PROPERTIES).setFromProperties(fromProperties).setToProperties(toProperties));
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspect) {
        this.deleteAspect(aspect);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(DELETE_NODE_ASPECT).deleteAspect(aspect));
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspect) {
        this.addAspect(aspect);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(ADD_NODE_ASPECT).addAspect(aspect));
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (newContent) {
            this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(CREATE_CONTENT));
        } else {
            this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(UPDATE_CONTENT));
        }
    }

    @Override
    public void onContentRead(NodeRef nodeRef) {
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(READ_CONTENT));
    }

    @Override
    public void onCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        this.setVersionProperties((HashMap)versionProperties);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(CREATE_VERSION).setVersionProperties((HashMap)versionProperties));
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        this.setCopyFrom(sourceNodeRef);
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, targetNodeRef).setAction(COPY_NODE).setCopyFrom(sourceNodeRef));
    }

    @Override
    public void onCheckOut(NodeRef workingCopy) {
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, workingCopy).setAction(CHECK_OUT));
    }

    @Override
    public void onCheckIn(NodeRef nodeRef) {
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(CHECK_IN));
    }

    @Override
    public void onCancelCheckOut(NodeRef nodeRef) {
        this.appendSubAction(new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef).setAction(CANCEL_CHECK_OUT));
    }

    public Map<String, Serializable> getAuditData(boolean subAction) {
        HashMap<String, Serializable> auditMap = new HashMap<String, Serializable>(2 * (12 + (this.fromProperties != null ? this.fromProperties.size() + this.toProperties.size() + 4 : 0) + (this.addedAspects != null ? this.addedAspects.size() : 0) + (this.deletedAspects != null ? this.deletedAspects.size() : 0) + (this.versionProperties != null ? this.versionProperties.size() + 1 : 0) + this.getSubAuditDataSize()));
        if (!subAction) {
            this.setAction(this.getDerivedAction());
        }
        auditMap.put(ACTION, (Serializable)((Object)this.action));
        if (!subAction) {
            auditMap.put(USER, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
            this.addSubActionsToAuditMap(auditMap);
            auditMap.put(NODE, (Serializable)this.nodeInfo.getNodeRef());
            auditMap.put(PATH, (Serializable)((Object)this.nodeInfo.getPrefixPath()));
            auditMap.put(TYPE, (Serializable)((Object)this.nodeInfo.getPrefixType()));
        }
        if (this.copyFrom != null) {
            auditMap.put(NodeChange.buildPath(COPY, FROM, NODE), (Serializable)this.copyFrom.getNodeRef());
            auditMap.put(NodeChange.buildPath(COPY, FROM, PATH), (Serializable)((Object)this.copyFrom.getPrefixPath()));
            auditMap.put(NodeChange.buildPath(COPY, FROM, TYPE), (Serializable)((Object)this.copyFrom.getPrefixType()));
        }
        if (this.moveFrom != null) {
            auditMap.put(NodeChange.buildPath(MOVE, FROM, NODE), (Serializable)this.moveFrom.getNodeRef());
            auditMap.put(NodeChange.buildPath(MOVE, FROM, PATH), (Serializable)((Object)this.moveFrom.getPrefixPath()));
            auditMap.put(NodeChange.buildPath(MOVE, FROM, TYPE), (Serializable)((Object)this.moveFrom.getPrefixType()));
        }
        if (this.fromProperties != null) {
            this.addPropertyChangesToAuditMap(auditMap, subAction);
        }
        if (this.addedAspects != null && !this.addedAspects.isEmpty()) {
            this.addAspectChangesToAuditMap(auditMap, ADD, this.addedAspects, subAction);
        }
        if (this.deletedAspects != null && !this.deletedAspects.isEmpty()) {
            this.addAspectChangesToAuditMap(auditMap, DELETE, this.deletedAspects, subAction);
        }
        if (this.versionProperties != null && !this.versionProperties.isEmpty()) {
            this.addVersionPropertiesToAuditMap(auditMap, this.versionProperties, subAction);
        }
        this.addSubActionAuditMapsToAuditMap(auditMap);
        return auditMap;
    }

    private void addSubActionsToAuditMap(Map<String, Serializable> auditMap) {
        StringBuilder sb = new StringBuilder();
        for (String subAction : this.subActions) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(subAction);
        }
        auditMap.put(SUB_ACTIONS, (Serializable)((Object)sb.toString()));
    }

    private void addPropertyChangesToAuditMap(Map<String, Serializable> auditMap, boolean subAction) {
        HashMap<QName, Serializable> from = new HashMap<QName, Serializable>(this.fromProperties.size());
        HashMap<QName, Serializable> to = new HashMap<QName, Serializable>(this.toProperties.size());
        HashMap<QName, Serializable> add = new HashMap<QName, Serializable>(this.toProperties.size());
        HashMap<QName, Serializable> delete = new HashMap<QName, Serializable>(this.fromProperties.size());
        for (Map.Entry<QName, Serializable> entry : this.fromProperties.entrySet()) {
            QName key = this.getPrefixedQName(entry.getKey());
            String name = this.replaceInvalidPathChars(key.toPrefixString());
            Serializable beforeValue = entry.getValue();
            Serializable afterValue = null;
            boolean exists = this.toProperties.containsKey(key);
            boolean same = false;
            if (exists && (beforeValue == (afterValue = this.toProperties.get(key)) || beforeValue != null && beforeValue.equals(afterValue))) {
                same = true;
            }
            if (same) continue;
            if (exists) {
                auditMap.put(NodeChange.buildPath(PROPERTIES, FROM, name), beforeValue);
                auditMap.put(NodeChange.buildPath(PROPERTIES, TO, name), afterValue);
                from.put(key, beforeValue);
                to.put(key, afterValue);
                continue;
            }
            auditMap.put(NodeChange.buildPath(PROPERTIES, DELETE, name), beforeValue);
            delete.put(key, beforeValue);
        }
        HashSet<QName> newKeys = new HashSet<QName>(this.toProperties.keySet());
        newKeys.removeAll(this.fromProperties.keySet());
        for (QName key : newKeys) {
            key = this.getPrefixedQName(key);
            Serializable afterValue = this.toProperties.get(key);
            String name = this.replaceInvalidPathChars(key.toPrefixString());
            auditMap.put(NodeChange.buildPath(PROPERTIES, ADD, name), afterValue);
            add.put(key, afterValue);
        }
        if (!subAction) {
            if (!add.isEmpty()) {
                auditMap.put(NodeChange.buildPath(PROPERTIES, ADD), add);
            }
            if (!delete.isEmpty()) {
                auditMap.put(NodeChange.buildPath(PROPERTIES, DELETE), delete);
            }
            if (!from.isEmpty()) {
                auditMap.put(NodeChange.buildPath(PROPERTIES, FROM), from);
            }
            if (!to.isEmpty()) {
                auditMap.put(NodeChange.buildPath(PROPERTIES, TO), to);
            }
        }
    }

    private void addAspectChangesToAuditMap(Map<String, Serializable> auditMap, String addOrDelete, HashSet<QName> aspects, boolean subAction) {
        HashSet<QName> prefixedAspects = new HashSet<QName>(aspects.size());
        for (QName aspect : aspects) {
            aspect = this.getPrefixedQName(aspect);
            prefixedAspects.add(aspect);
            String name = this.replaceInvalidPathChars(aspect.toPrefixString());
            auditMap.put(NodeChange.buildPath(ASPECTS, addOrDelete, name), null);
        }
        if (!subAction) {
            auditMap.put(NodeChange.buildPath(ASPECTS, addOrDelete), prefixedAspects);
        }
    }

    private void addVersionPropertiesToAuditMap(Map<String, Serializable> auditMap, HashMap<String, Serializable> properties, boolean subAction) {
        for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf(58) == 0) {
                try {
                    QName qNameKey = QName.createQName((String)key);
                    qNameKey = this.getPrefixedQName(qNameKey);
                    key = qNameKey.toPrefixString();
                }
                catch (InvalidQNameException e) {
                    // empty catch block
                }
            }
            String name = this.replaceInvalidPathChars(key);
            auditMap.put(NodeChange.buildPath(VERSION_PROPERTIES, name), entry.getValue());
        }
        if (!subAction) {
            auditMap.put(VERSION_PROPERTIES, properties);
        }
    }

    private int getSubAuditDataSize() {
        int size = 0;
        if (this.subActionAuditMaps != null && this.subActionAuditMaps.size() > 1) {
            for (Map<String, Serializable> subActionAuditMap : this.subActionAuditMaps) {
                size += subActionAuditMap.size();
            }
        }
        return size;
    }

    private void addSubActionAuditMapsToAuditMap(Map<String, Serializable> auditMap) {
        if (this.subActionAuditMaps != null && this.subActionAuditMaps.size() > 1) {
            String format = "%0" + Integer.toString(auditMap.size()).length() + "d";
            int i = 0;
            for (Map<String, Serializable> subActionAuditMap : this.subActionAuditMaps) {
                String seq = String.format(format, i);
                for (Map.Entry<String, Serializable> entry : subActionAuditMap.entrySet()) {
                    auditMap.put(NodeChange.buildPath(SUB_ACTION, seq, entry.getKey()), entry.getValue());
                }
                ++i;
            }
        }
    }

    private static String buildPath(String ... components) {
        StringBuilder sb = new StringBuilder();
        for (String component : components) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(component);
        }
        return sb.toString();
    }

    private QName getPrefixedQName(QName qName) {
        try {
            qName = qName.getPrefixedQName((NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return qName;
    }

    private String replaceInvalidPathChars(String path) {
        return INVALID_PATH_COMP_CHAR_PATTERN.matcher(path).replaceAll(INVALID_PATH_CHAR_REPLACEMENT);
    }

    static {
        SUMMARY_KEYS.add(NodeChange.buildPath(PROPERTIES, ADD));
        SUMMARY_KEYS.add(NodeChange.buildPath(PROPERTIES, DELETE));
        SUMMARY_KEYS.add(NodeChange.buildPath(PROPERTIES, FROM));
        SUMMARY_KEYS.add(NodeChange.buildPath(PROPERTIES, TO));
        SUMMARY_KEYS.add(NodeChange.buildPath(ASPECTS, ADD));
        SUMMARY_KEYS.add(NodeChange.buildPath(ASPECTS, DELETE));
    }
}

