/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.extractor;

import java.io.Serializable;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;

public class NodeTypeDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    public boolean isSupported(Serializable data) {
        return data != null && data instanceof NodeRef;
    }

    public Serializable extractData(Serializable in) throws Throwable {
        NodeRef nodeRef = (NodeRef)in;
        QName nodeType = null;
        if (!this.nodeService.exists(nodeRef)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extractor can't pull value from non-existent node: " + nodeRef));
            }
        } else {
            nodeType = this.nodeService.getType(nodeRef);
        }
        return nodeType;
    }
}

