/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMTestSuite;
import org.alfresco.repo.avm.CreateStoreCallback;
import org.alfresco.repo.avm.CreateStoreTxnListener;
import org.alfresco.repo.avm.CreateVersionCallback;
import org.alfresco.repo.avm.CreateVersionTxnListener;
import org.alfresco.repo.avm.OrphanReaper;
import org.alfresco.repo.avm.PurgeStoreCallback;
import org.alfresco.repo.avm.PurgeStoreTxnListener;
import org.alfresco.repo.avm.PurgeVersionCallback;
import org.alfresco.repo.avm.PurgeVersionTxnListener;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMServiceTestBase
extends TestCase {
    protected static AVMService fService;
    protected static OrphanReaper fReaper;
    protected static AVMSyncService fSyncService;
    protected static ApplicationContext fContext;
    private long fStartTime;
    protected static RetryingTransactionHelper fRetryingTransactionHelper;
    protected static AuthenticationComponent fAuthenticationComponent;
    protected static AVMSnapShotTriggeredIndexingMethodInterceptor fIndexingInterceptor;
    protected static TransactionService fTransactionService;
    protected static IndexerAndSearcher fIndexerAndSearcher;
    protected static AVMLockingService fLockingService;
    protected static AuthenticationService fAuthService;

    public void testSetup() throws Exception {
    }

    protected void setUp() throws Exception {
        if (fContext == null) {
            fContext = AVMTestSuite.getContext();
            fService = (AVMService)fContext.getBean("AVMService");
            fReaper = (OrphanReaper)fContext.getBean("orphanReaper");
            fSyncService = (AVMSyncService)fContext.getBean("AVMSyncService");
            fIndexerAndSearcher = (IndexerAndSearcher)fContext.getBean("indexerAndSearcherFactory");
            fTransactionService = (TransactionService)fContext.getBean("transactionComponent");
            fLockingService = (AVMLockingService)fContext.getBean("AVMLockingService");
            fIndexingInterceptor = (AVMSnapShotTriggeredIndexingMethodInterceptor)fContext.getBean("avmSnapShotTriggeredIndexingMethodInterceptor");
            fAuthService = (AuthenticationService)fContext.getBean("AuthenticationService");
            fAuthenticationComponent = (AuthenticationComponent)fContext.getBean("authenticationComponent");
            fRetryingTransactionHelper = (RetryingTransactionHelper)fContext.getBean("retryingTransactionHelper");
            CreateStoreTxnListener cstl = (CreateStoreTxnListener)fContext.getBean("createStoreTxnListener");
            cstl.addCallback(new CreateStoreCallback(){

                public void storeCreated(String name) {
                }
            });
            PurgeStoreTxnListener pstl = (PurgeStoreTxnListener)fContext.getBean("purgeStoreTxnListener");
            pstl.addCallback(new PurgeStoreCallback(){

                public void storePurged(String name) {
                }
            });
            CreateVersionTxnListener cvtl = (CreateVersionTxnListener)fContext.getBean("createVersionTxnListener");
            cvtl.addCallback(new CreateVersionCallback(){

                public void versionCreated(String name, int versionID) {
                }
            });
            PurgeVersionTxnListener pvtl = (PurgeVersionTxnListener)fContext.getBean("purgeVersionTxnListener");
            pvtl.addCallback(new PurgeVersionCallback(){

                public void versionPurged(String name, int versionID) {
                }
            });
        }
        fAuthService.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        if (fService.getStore("main") != null) {
            fService.purgeStore("main");
        }
        fService.createStore("main");
        if (fService.getStore("layer") != null) {
            fService.purgeStore("layer");
        }
        this.fStartTime = System.currentTimeMillis();
    }

    protected void tearDown() throws Exception {
        long now = System.currentTimeMillis();
        System.out.println("Timing: " + (now - this.fStartTime) + "ms");
        if (fService.getStore("main") != null) {
            fService.purgeStore("main");
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected String recursiveContents(String path, int version, boolean followLinks) {
        String val = this.recursiveList(path, version, 0, followLinks);
        return val.substring(val.indexOf(10));
    }

    protected String recursiveList(String repoName, int version, boolean followLinks) {
        return this.recursiveList(repoName + ":/", version, 0, followLinks);
    }

    protected String recursiveList(String path, int version, int indent, boolean followLinks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        builder.append(path.substring(path.lastIndexOf(47) + 1));
        builder.append(' ');
        AVMNodeDescriptor desc = fService.lookup(version, path, true);
        builder.append(desc.toString());
        builder.append('\n');
        if (desc.getType() == 2 || desc.getType() == 3 && followLinks) {
            String basename = path.endsWith("/") ? path : path + "/";
            SortedMap<String, AVMNodeDescriptor> listing = fService.getDirectoryListing(version, path, true);
            for (String name : listing.keySet()) {
                System.err.println(name);
                builder.append(this.recursiveList(basename + name, version, indent + 2, followLinks));
            }
        }
        return builder.toString();
    }

    protected void setupBasicTree0() throws IOException {
        fService.createDirectory("main:/", "a");
        fService.createDirectory("main:/a", "b");
        fService.createDirectory("main:/a/b", "c");
        fService.createDirectory("main:/", "d");
        fService.createDirectory("main:/d", "e");
        fService.createDirectory("main:/d/e", "f");
        fService.createFile("main:/a/b/c", "foo").close();
        ContentWriter writer = fService.getContentWriter("main:/a/b/c/foo", true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/foo");
        fService.createFile("main:/a/b/c", "bar").close();
        writer = fService.getContentWriter("main:/a/b/c/bar", true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/bar");
        fService.createSnapshot("main", null, null);
    }

    protected void setupBasicTree() throws IOException {
        this.setupBasicTree0();
    }

    protected void runQueriesAgainstBasicTree(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTestBase.assertEquals((int)9, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTestBase.assertEquals((int)8, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTestBase.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTestBase.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void runQueriesAgainstBasicTreeWithAOnly(String store) {
        StoreRef storeRef = AVMNodeConverter.ToStoreRef(store);
        SearchService searchService = fIndexerAndSearcher.getSearcher(AVMNodeConverter.ToStoreRef(store), true);
        ResultSet results = searchService.query(storeRef, "lucene", "TEXT:\"I am main\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":\"foo\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NAME)) + ":foo");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_CREATOR)) + ":admin");
        if (results.length() == 10) {
            for (ResultSetRow row : results) {
                System.out.println(row.getNodeRef());
            }
        }
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_MODIFIER)) + ":admin");
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_OWNER)) + ":admin");
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_NODE_UUID)) + ":unknown");
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_PROTOCOL)) + ":avm");
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", AbstractLuceneQueryParser.escape((String)("@" + ContentModel.PROP_STORE_IDENTIFIER)) + ":" + store);
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/foo\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/b/c/bar\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d\"");
        AVMServiceTestBase.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e\"");
        AVMServiceTestBase.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/d/e/f\"");
        AVMServiceTestBase.assertEquals((int)0, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//.\"");
        AVMServiceTestBase.assertEquals((int)6, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//*\"");
        AVMServiceTestBase.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//.\"");
        AVMServiceTestBase.assertEquals((int)5, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a//*\"");
        AVMServiceTestBase.assertEquals((int)4, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/a/*\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"//c/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)1, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)2, (int)results.length());
        results.close();
        results = searchService.query(storeRef, "lucene", "PATH:\"/*/*/*/*/*\"");
        AVMServiceTestBase.assertEquals((int)0, (int)results.length());
        results.close();
    }

    protected void checkHistory(TreeMap<Integer, String> history, String repName) {
        for (Integer i : history.keySet()) {
            AVMServiceTestBase.assertEquals((String)history.get(i), (String)this.recursiveList(repName, i, false));
        }
        int latest = fService.getNextVersionID(repName);
        history.put(latest - 1, this.recursiveList(repName, -1, false));
    }
}

