/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.List;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.remote.AVMSyncServiceTransport;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.NameMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMSyncServiceTransportImpl
implements AVMSyncServiceTransport {
    private AVMSyncService fSyncService;
    private AuthenticationService fAuthenticationService;

    public void setAvmSyncService(AVMSyncService service) {
        this.fSyncService = service;
    }

    public void setAuthenticationService(AuthenticationService service) {
        this.fAuthenticationService = service;
    }

    @Override
    public List<AVMDifference> compare(String ticket, int srcVersion, String srcPath, int dstVersion, String dstPath, NameMatcher excluder) {
        this.fAuthenticationService.validate(ticket);
        return this.fSyncService.compare(srcVersion, srcPath, dstVersion, dstPath, excluder);
    }

    @Override
    public void flatten(String ticket, String layerPath, String underlyingPath) {
        this.fAuthenticationService.validate(ticket);
        this.fSyncService.flatten(layerPath, underlyingPath);
    }

    @Override
    public void resetLayer(String ticket, String layerPath) {
        this.fAuthenticationService.validate(ticket);
        this.fSyncService.resetLayer(layerPath);
    }

    @Override
    public void update(String ticket, List<AVMDifference> diffList, NameMatcher excluder, boolean ignoreConflicts, boolean ignoreOlder, boolean overrideConflicts, boolean overrideOlder, String tag, String description) {
        this.fAuthenticationService.validate(ticket);
        this.fSyncService.update(diffList, excluder, ignoreConflicts, ignoreOlder, overrideConflicts, overrideOlder, tag, description);
    }
}

