/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.LookupCache;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.repo.avm.util.SimplePath;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.util.Pair;

public class NOOPLookupCache
implements LookupCache {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lookup lookup(AVMStore store, int version, SimplePath path, boolean write, boolean includeDeleted) {
        if (path.size() == 0) {
            return null;
        }
        Lookup result = new Lookup(store, store.getName(), version);
        DirectoryNode dir = null;
        if (version < 0) {
            dir = store.getRoot();
        } else {
            VersionRoot vRoot = AVMDAOs.Instance().fVersionRootDAO.getByVersionID(store, version);
            if (vRoot != null) {
                dir = vRoot.getRoot();
            }
        }
        if (dir == null) {
            return null;
        }
        result.add(dir, "", true, write);
        dir = (DirectoryNode)result.getCurrentNode();
        if (path.size() == 1 && path.get(0).equals("")) {
            return result;
        }
        DirectoryNode prevDir = null;
        for (int i = 0; i < path.size() - 1; ++i) {
            if (!AVMRepository.GetInstance().can(null, dir, "ReadChildren", result.getDirectlyContained())) {
                throw new AccessDeniedException("Not allowed to read children: " + path.get(i) + " (" + store.getName() + ")");
            }
            Pair<ChildEntry, Boolean> childEntryResult = dir.lookupChildEntry(result, path.get(i), includeDeleted);
            if (childEntryResult == null) {
                return null;
            }
            AVMNode child = ((ChildEntry)childEntryResult.getFirst()).getChild();
            if (child.getType() != 2 && child.getType() != 3) {
                return null;
            }
            prevDir = (DirectoryNode)child;
            String lookupPathElementName = ((ChildEntry)childEntryResult.getFirst()).getKey().getName();
            result.add(child, lookupPathElementName, (Boolean)childEntryResult.getSecond(), write);
            dir = (DirectoryNode)result.getCurrentNode();
        }
        if (!AVMRepository.GetInstance().can(null, dir, "ReadChildren", result.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read children: " + path.get(path.size() - 1) + " (" + store.getName() + ")");
        }
        Pair childEntryResult = dir.lookupChildEntry(result, path.get(path.size() - 1), includeDeleted);
        if (childEntryResult == null) {
            if (!write || dir.getType() != 3) return null;
            ChildKey key = new ChildKey(prevDir, path.get(path.size() - 1));
            ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
            if (entry == null) return null;
            if (!includeDeleted && entry.getChild().getType() == 4) {
                return null;
            }
            childEntryResult = new Pair((Object)entry, (Object)true);
        }
        AVMNode child = ((ChildEntry)childEntryResult.getFirst()).getChild();
        String lookupPathElementName = ((ChildEntry)childEntryResult.getFirst()).getKey().getName();
        result.add(child, lookupPathElementName, (Boolean)childEntryResult.getSecond(), write);
        return result;
    }

    public void onWrite(String storeName) {
    }

    public void onDelete(String storeName) {
    }

    public void onSnapshot(String storeName) {
    }

    public void reset() {
    }
}

