/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.blog.BlogService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogServiceImplTest {
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static BlogService BLOG_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static SiteService SITE_SERVICE;
    private static TaggingService TAGGING_SERVICE;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;
    private static SiteInfo BLOG_SITE;
    private static NodeRef BLOG_CONTAINER_NODE;

    @BeforeClass
    public static void initTestsContext() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        BLOG_SERVICE = (BlogService)testContext.getBean("blogService");
        DICTIONARY_SERVICE = (DictionaryService)testContext.getBean("dictionaryService");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        SITE_SERVICE = (SiteService)testContext.getBean("siteService");
        TAGGING_SERVICE = (TaggingService)testContext.getBean("TaggingService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        BlogServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        BlogServiceImplTest.createTestSiteWithBlogContainer();
    }

    private static void createTestSiteWithBlogContainer() throws Exception {
        BLOG_SITE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite("BlogSitePreset", BlogServiceImplTest.class.getSimpleName() + "_testSite" + GUID.generate(), "test site title", "test site description", SiteVisibility.PUBLIC);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        BLOG_CONTAINER_NODE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                SiteInfo site = BLOG_SITE;
                NodeRef result = SITE_SERVICE.getContainer(site.getShortName(), "blog");
                if (result == null) {
                    result = SITE_SERVICE.createContainer(site.getShortName(), "blog", ContentModel.TYPE_FOLDER, null);
                    CLASS_TEST_NODES_TO_TIDY.add(result);
                }
                return result;
            }
        });
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        BlogServiceImplTest.performDeletionOfNodes(this.testNodesToTidy);
    }

    @AfterClass
    public static void deleteClassTestNodesAndUsers() throws Exception {
        BlogServiceImplTest.performDeletionOfNodes(CLASS_TEST_NODES_TO_TIDY);
        BlogServiceImplTest.deleteUser(TEST_USER);
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    if (NODE_SERVICE.getType(node).equals((Object)SiteModel.TYPE_SITE)) {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(node);
                        SITE_SERVICE.deleteSite(siteInfo.getShortName());
                        continue;
                    }
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    @Test
    public void createDraftBlogPostsAndGetPagedResults() throws Exception {
        int arbitraryNumberGreaterThanPageSize = 42;
        final List<NodeRef> submittedBlogPosts = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            @Override
            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                for (int i = 0; i < 42; ++i) {
                    BlogPostInfo newBlogPost = i % 2 == 0 ? BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "title_" + i, "Hello world", true) : BLOG_SERVICE.createBlogPost(BLOG_SITE.getShortName(), "title_" + i, "Hello world", true);
                    results.add(newBlogPost.getNodeRef());
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ArrayList recoveredBlogPosts = new ArrayList(42);
                int pageSize = 10;
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults<BlogPostInfo> pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                Assert.assertEquals((String)"Wrong total result count.", (long)42L, (long)((Integer)pagedResults.getTotalResultCount().getFirst()).intValue());
                while (pagedResults.hasMoreItems()) {
                    recoveredBlogPosts.addAll(pagedResults.getPage());
                    pagingReq = new PagingRequest(pagingReq.getSkipCount() + 10, 10, null);
                    pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                }
                recoveredBlogPosts.addAll(pagedResults.getPage());
                Assert.assertEquals((String)"Wrong number of blog posts.", (long)submittedBlogPosts.size(), (long)recoveredBlogPosts.size());
                BlogServiceImplTest.this.assertNodeRefsAreSortedBy(recoveredBlogPosts, ContentModel.PROP_CREATED, false);
                return null;
            }
        });
    }

    private void assertNodeRefsAreSortedBy(List<BlogPostInfo> blogPosts, QName property, boolean ascendingOrder) {
        PropertyDefinition propertyDef = DICTIONARY_SERVICE.getProperty(property);
        Assert.assertNotNull((String)"Property not recognised.", (Object)propertyDef);
        Assert.assertEquals((String)"Property was not a Date", (Object)DataTypeDefinition.DATETIME, (Object)propertyDef.getDataType().getName());
        if (blogPosts.size() > 1) {
            for (int i = 0; i < blogPosts.size() - 1; ++i) {
                Date date2;
                NodeRef nodeRef1 = blogPosts.get(i).getNodeRef();
                NodeRef nodeRef2 = blogPosts.get(i + 1).getNodeRef();
                Date date1 = (Date)NODE_SERVICE.getProperty(nodeRef1, property);
                if (date1.equals(date2 = (Date)NODE_SERVICE.getProperty(nodeRef2, property))) continue;
                if (ascendingOrder) {
                    Assert.assertTrue((String)("BlogPosts not asc-sorted by " + property + ". Error at index " + i), (boolean)date1.before(date2));
                    continue;
                }
                Assert.assertTrue((String)("BlogPosts not desc-sorted by " + property + ". Error at index " + i), (boolean)date1.after(date2));
            }
        }
    }

    @Test
    public void createTaggedDraftBlogPost() throws Exception {
        final List<String> tags = Arrays.asList("alpha", "beta", "gamma", "fran\u00e7ais", "chinese_\u535a\u5ba2");
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            @Override
            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                for (String tag : tags) {
                    String blogTitle = "draftWithTag" + tag;
                    BlogPostInfo newBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, blogTitle, "Hello world", true);
                    TAGGING_SERVICE.addTags(newBlogPost.getNodeRef(), Arrays.asList(tag));
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    results.add(newBlogPost.getNodeRef());
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashSet expectedTags = new HashSet();
                expectedTags.addAll(tags);
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults<BlogPostInfo> pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                Assert.assertEquals((String)"Wrong number of blog posts", (long)tags.size(), (long)pagedResults.getPage().size());
                for (BlogPostInfo bpi : pagedResults.getPage()) {
                    NodeRef blogNode = bpi.getNodeRef();
                    List<String> recoveredTags = TAGGING_SERVICE.getTags(blogNode);
                    Assert.assertEquals((String)"Wrong number of tags", (long)1L, (long)recoveredTags.size());
                    String tag = recoveredTags.get(0);
                    Assert.assertTrue((String)("Tag found on node but not expected: " + tag), (boolean)expectedTags.remove(tag));
                }
                Assert.assertTrue((String)"Not all tags were recovered from a blogpost", (boolean)expectedTags.isEmpty());
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                BlogService.RangedDateProperty dates = new BlogService.RangedDateProperty(null, null, ContentModel.PROP_CREATED);
                for (String tag : tags) {
                    PagingResults<BlogPostInfo> pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, dates, tag, pagingReq);
                    Assert.assertEquals((String)("Wrong number of blog posts for " + tag), (long)1L, (long)pagedResults.getPage().size());
                }
                return null;
            }
        });
    }

    @Test
    public void findBlogPostsByPublishedDate() throws Exception {
        final List<String> tags = Arrays.asList("hello", "goodbye");
        Calendar cal = Calendar.getInstance();
        cal.set(1971, 6, 15);
        final Date _1971 = cal.getTime();
        cal.set(1975, 0, 1);
        final Date _1975 = cal.getTime();
        cal.set(1980, 0, 1);
        final Date _1980 = cal.getTime();
        cal.set(1981, 0, 1);
        final Date _1981 = cal.getTime();
        cal.set(1985, 6, 15);
        final Date _1985 = cal.getTime();
        cal.set(1991, 6, 15);
        final Date _1991 = cal.getTime();
        final Map<Integer, NodeRef> blogPosts = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Map<Integer, NodeRef>>(){

            @Override
            public Map<Integer, NodeRef> execute() throws Throwable {
                HashMap<Integer, NodeRef> result = new HashMap<Integer, NodeRef>();
                BlogPostInfo blogPost1971 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1971", "Hello world", true);
                BlogPostInfo blogPost1981 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1981", "Hello world", true);
                BlogPostInfo blogPost1991 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1991", "Hello world", true);
                TAGGING_SERVICE.addTags(blogPost1971.getNodeRef(), tags);
                TAGGING_SERVICE.addTags(blogPost1981.getNodeRef(), tags);
                TAGGING_SERVICE.addTags(blogPost1991.getNodeRef(), tags);
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1971.getNodeRef());
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1981.getNodeRef());
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1991.getNodeRef());
                NODE_SERVICE.setProperty(blogPost1971.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1971);
                NODE_SERVICE.setProperty(blogPost1981.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1981);
                NODE_SERVICE.setProperty(blogPost1991.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1991);
                result.put(1971, blogPost1971.getNodeRef());
                result.put(1981, blogPost1981.getNodeRef());
                result.put(1991, blogPost1991.getNodeRef());
                return result;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Incorrect published date", (long)71L, (long)((Date)NODE_SERVICE.getProperty((NodeRef)blogPosts.get(1971), ContentModel.PROP_PUBLISHED)).getYear());
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                BlogService.RangedDateProperty publishedBefore1980 = new BlogService.RangedDateProperty(null, _1980, ContentModel.PROP_PUBLISHED);
                BlogService.RangedDateProperty publishedAfter1980 = new BlogService.RangedDateProperty(_1980, null, ContentModel.PROP_PUBLISHED);
                BlogService.RangedDateProperty publishedBetween1975And1985 = new BlogService.RangedDateProperty(_1975, _1985, ContentModel.PROP_PUBLISHED);
                PagingResults<BlogPostInfo> pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, null, null, pagingReq);
                Assert.assertEquals((String)"Wrong number of blog posts", (long)3L, (long)pagedResults.getPage().size());
                HashSet<NodeRef> recoveredBlogNodes = new HashSet<NodeRef>();
                for (BlogPostInfo bpi : pagedResults.getPage()) {
                    recoveredBlogNodes.add(bpi.getNodeRef());
                }
                Assert.assertTrue((String)"Missing expected BlogPost NodeRef 71", (boolean)recoveredBlogNodes.contains(blogPosts.get(1971)));
                Assert.assertTrue((String)"Missing expected BlogPost NodeRef 81", (boolean)recoveredBlogNodes.contains(blogPosts.get(1981)));
                Assert.assertTrue((String)"Missing expected BlogPost NodeRef 91", (boolean)recoveredBlogNodes.contains(blogPosts.get(1991)));
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedBefore1980, null, pagingReq);
                Assert.assertEquals((String)"Wrong blog post count", (long)1L, (long)pagedResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1971));
                List<String> recoveredTags = TAGGING_SERVICE.getTags(blogNode);
                Assert.assertEquals((String)"Incorrect tags.", (Object)tags, recoveredTags);
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedAfter1980, "hello", pagingReq);
                Assert.assertEquals((String)"Wrong blog post count", (long)2L, (long)pagedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1981));
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedBetween1975And1985, "hello", pagingReq);
                Assert.assertEquals((String)"Wrong blog post count", (long)1L, (long)pagedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1981));
                return null;
            }
        });
    }

    @Test
    public void ensureBlogPostsAreCorrectlySorted() throws Exception {
        int testBlogCount = 3;
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                long slightDelay = 50L;
                for (int i = 0; i < 3; ++i) {
                    BlogPostInfo newDraft = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "draftPost_ensureBlogPostsAreCorrectlySorted" + i, "x", true);
                    Thread.sleep(50L);
                    BlogPostInfo newPublished = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPost_ensureBlogPostsAreCorrectlySorted" + i, "x", false);
                    Thread.sleep(50L);
                    BlogServiceImplTest.this.testNodesToTidy.add(newDraft.getNodeRef());
                    BlogServiceImplTest.this.testNodesToTidy.add(newPublished.getNodeRef());
                }
                return null;
            }
        });
        final PagingRequest pagingReq = new PagingRequest(100);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                PagingResults<BlogPostInfo> resultsPage = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, currentUser, pagingReq);
                List blogPosts = resultsPage.getPage();
                Assert.assertTrue((String)("Expected more draft blog posts than " + blogPosts.size()), (blogPosts.size() >= 3 ? 1 : 0) != 0);
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                resultsPage = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, currentUser, pagingReq);
                blogPosts = resultsPage.getPage();
                Assert.assertTrue((String)("Expected more published blog posts than " + blogPosts.size()), (blogPosts.size() >= 3 ? 1 : 0) != 0);
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                System.out.println("  getMyDraftsAndAllPublished");
                resultsPage = BLOG_SERVICE.getMyDraftsAndAllPublished(BLOG_CONTAINER_NODE, null, null, pagingReq);
                blogPosts = resultsPage.getPage();
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                return null;
            }
        });
    }

    private void assertSortingIsCorrect(List<BlogPostInfo> blogPosts) {
        for (BlogPostInfo bpi : blogPosts) {
            System.out.println("  -----");
            Date published = (Date)NODE_SERVICE.getProperty(bpi.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date created = (Date)NODE_SERVICE.getProperty(bpi.getNodeRef(), ContentModel.PROP_CREATED);
            System.out.print("    published: " + (published == null ? "             " : Long.valueOf(published.getTime())));
            System.out.println("    created  : " + created.getTime());
        }
        for (int i = 0; i < blogPosts.size() - 1; ++i) {
            BlogPostInfo nextBPI = blogPosts.get(i);
            BlogPostInfo followingBPI = blogPosts.get(i + 1);
            Date nextPublishedDate = (Date)NODE_SERVICE.getProperty(nextBPI.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date followingPublishedDate = (Date)NODE_SERVICE.getProperty(followingBPI.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date nextCreatedDate = (Date)NODE_SERVICE.getProperty(nextBPI.getNodeRef(), ContentModel.PROP_CREATED);
            Date followingCreatedDate = (Date)NODE_SERVICE.getProperty(followingBPI.getNodeRef(), ContentModel.PROP_CREATED);
            if (nextPublishedDate == null && followingPublishedDate != null) {
                Assert.fail((String)"Published posts must precede draft posts");
                continue;
            }
            if (nextPublishedDate != null && followingPublishedDate != null) {
                Assert.assertTrue((String)"Error in BlogPostInfo sorting. Published dates in wrong order.", (!nextPublishedDate.before(followingPublishedDate) ? 1 : 0) != 0);
                continue;
            }
            if (nextPublishedDate != null || followingPublishedDate != null) continue;
            Assert.assertTrue((String)"Error in BlogPostInfo sorting. Created dates in wrong order.", (!nextCreatedDate.before(followingCreatedDate) ? 1 : 0) != 0);
        }
    }

    @Test
    public void multipleUsersCreateDraftsAndPublishedPostsAndBrowse() throws Exception {
        final Pair<NodeRef, NodeRef> adminPosts = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            @Override
            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                BlogPostInfo newDraftBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "adminDraft", "", true);
                BlogServiceImplTest.this.testNodesToTidy.add(newDraftBlogPost.getNodeRef());
                BlogPostInfo newPublishedBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "adminPublished", "", false);
                BlogServiceImplTest.this.testNodesToTidy.add(newPublishedBlogPost.getNodeRef());
                return new Pair((Object)newDraftBlogPost.getNodeRef(), (Object)newPublishedBlogPost.getNodeRef());
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        final Pair<NodeRef, NodeRef> userPosts = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            @Override
            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                BlogPostInfo newDraftBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "userDraft", "", true);
                BlogServiceImplTest.this.testNodesToTidy.add(newDraftBlogPost.getNodeRef());
                BlogPostInfo newPublishedBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "userPublished", "", false);
                BlogServiceImplTest.this.testNodesToTidy.add(newPublishedBlogPost.getNodeRef());
                return new Pair((Object)newDraftBlogPost.getNodeRef(), (Object)newPublishedBlogPost.getNodeRef());
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults<BlogPostInfo> pagedDraftResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                Assert.assertEquals((String)"Wrong number of admin draft blog posts", (long)1L, (long)pagedDraftResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedDraftResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect admin draft NodeRef.", (Object)blogNode, (Object)adminPosts.getFirst());
                PagingResults<BlogPostInfo> pagedPublishedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, ADMIN_USER, pagingReq);
                Assert.assertEquals((String)"Wrong number of admin published blog posts", (long)1L, (long)pagedPublishedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedPublishedResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect admin published NodeRef.", (Object)blogNode, (Object)adminPosts.getSecond());
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults<BlogPostInfo> pagedDraftResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, TEST_USER, pagingReq);
                Assert.assertEquals((String)"Wrong number of user draft blog posts", (long)1L, (long)pagedDraftResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedDraftResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect user draft NodeRef.", (Object)blogNode, (Object)userPosts.getFirst());
                PagingResults<BlogPostInfo> pagedPublishedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, TEST_USER, pagingReq);
                Assert.assertEquals((String)"Wrong number of user published blog posts", (long)1L, (long)pagedPublishedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedPublishedResults.getPage().get(0)).getNodeRef();
                Assert.assertEquals((String)"Incorrect user published NodeRef.", (Object)blogNode, (Object)userPosts.getSecond());
                return null;
            }
        });
    }

    @Test
    public void getBlogPostsFilteredByDateRange() throws Exception {
        int numberOfPosts = 91;
        final List<NodeRef> posts = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            @Override
            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                for (int i = 0; i < 91; ++i) {
                    BlogPostInfo newBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "date-specific-post" + i, "", false);
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    results.add(newBlogPost.getNodeRef());
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Calendar current = Calendar.getInstance();
                current.set(1999, 11, 1, 11, 0);
                Date currentDate = current.getTime();
                for (NodeRef nr : posts) {
                    BEHAVIOUR_FILTER.disableBehaviour(nr, ContentModel.ASPECT_AUDITABLE);
                    NODE_SERVICE.setProperty(nr, ContentModel.PROP_PUBLISHED, (Serializable)currentDate);
                    current.add(5, 1);
                    currentDate = current.getTime();
                }
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 100, null);
                Calendar cal = Calendar.getInstance();
                cal.set(1999, 11, 1, 0, 0, 0);
                Date firstDec99 = cal.getTime();
                cal.set(2000, 0, 1, 0, 0, 0);
                Date firstJan00 = cal.getTime();
                cal.set(2000, 1, 1, 0, 0, 0);
                Date firstFeb00 = cal.getTime();
                cal.set(2000, 2, 1, 0, 0, 0);
                Date firstMar00 = cal.getTime();
                PagingResults<BlogPostInfo> pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstDec99, firstJan00, null, pagingReq);
                Assert.assertEquals((String)"Wrong number of user blog posts", (long)31L, (long)pagedResults.getPage().size());
                pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstFeb00, firstMar00, null, pagingReq);
                Assert.assertEquals((String)"Wrong number of user blog posts", (long)29L, (long)pagedResults.getPage().size());
                pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstJan00, firstMar00, null, pagingReq);
                Assert.assertEquals((String)"Wrong number of user blog posts", (long)60L, (long)pagedResults.getPage().size());
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put(ContentModel.PROP_USERNAME, userName);
                    ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
                    ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
                    ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
                    ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                    PERSON_SERVICE.createPerson(ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }

    static {
        TEST_USER = BlogServiceImplTest.class.getSimpleName() + "_testuser";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }
}

