/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBulkImportTests {
    protected static ApplicationContext ctx = null;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected TransactionService transactionService;
    protected ContentService contentService;
    protected UserTransaction txn = null;
    protected RuleService ruleService;
    protected ActionService actionService;
    protected MultiThreadedBulkFilesystemImporter bulkImporter;
    protected NodeRef rootNodeRef;
    protected FileInfo topLevelFolder;
    protected NodeRef top;

    protected static void startContext() {
        ctx = ApplicationContextHelper.getApplicationContext();
    }

    protected static void startContext(String[] configLocations) {
        ctx = ApplicationContextHelper.getApplicationContext((String[])configLocations);
    }

    protected static void stopContext() {
        ApplicationContextHelper.closeApplicationContext();
    }

    @Before
    public void setup() throws SystemException, NotSupportedException {
        try {
            this.nodeService = (NodeService)ctx.getBean("nodeService");
            this.fileFolderService = (FileFolderService)ctx.getBean("fileFolderService");
            this.transactionService = (TransactionService)ctx.getBean("transactionService");
            this.bulkImporter = (MultiThreadedBulkFilesystemImporter)ctx.getBean("bulkFilesystemImporter");
            this.contentService = (ContentService)ctx.getBean("contentService");
            this.actionService = (ActionService)ctx.getBean("actionService");
            this.ruleService = (RuleService)ctx.getBean("ruleService");
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            String s = "BulkFilesystemImport" + System.currentTimeMillis();
            this.txn = this.transactionService.getUserTransaction();
            this.txn.begin();
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            StoreRef storeRef = this.nodeService.createStore("workspace", s);
            this.rootNodeRef = this.nodeService.getRootNode(storeRef);
            this.top = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}top"), ContentModel.TYPE_FOLDER).getChildRef();
            this.topLevelFolder = this.fileFolderService.create(this.top, s, ContentModel.TYPE_FOLDER);
            this.txn.commit();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void teardown() throws Exception {
        AuthenticationUtil.popAuthentication();
        if (this.txn != null) {
            this.txn.commit();
        }
    }

    @AfterClass
    public static void afterTests() {
        AbstractBulkImportTests.stopContext();
    }

    protected List<FileInfo> getFolders(NodeRef parent, String pattern) {
        PagingResults<FileInfo> page = this.fileFolderService.list(parent, false, true, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
        List folders = page.getPage();
        return folders;
    }

    protected List<FileInfo> getFiles(NodeRef parent, String pattern) {
        PagingResults<FileInfo> page = this.fileFolderService.list(parent, true, false, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
        List files = page.getPage();
        return files;
    }

    protected Map<String, FileInfo> toMap(List<FileInfo> list) {
        HashMap<String, FileInfo> map = new HashMap<String, FileInfo>(list.size());
        for (FileInfo fileInfo : list) {
            map.put(fileInfo.getName(), fileInfo);
        }
        return map;
    }

    protected void checkFolder(NodeRef folderNode, String childFolderName, String pattern, int numExpectedFolders, int numExpectedFiles, ExpectedFolder[] expectedFolders, ExpectedFile[] expectedFiles) {
        List<FileInfo> folders = this.getFolders(folderNode, childFolderName);
        Assert.assertEquals((String)"", (long)1L, (long)folders.size());
        NodeRef folder1 = folders.get(0).getNodeRef();
        this.checkFiles(folder1, pattern, numExpectedFolders, numExpectedFiles, expectedFiles, expectedFolders);
    }

    protected void checkFiles(NodeRef parent, String pattern, int expectedNumFolders, int expectedNumFiles, ExpectedFile[] expectedFiles, ExpectedFolder[] expectedFolders) {
        FileInfo fileInfo;
        Map<String, FileInfo> folders = this.toMap(this.getFolders(parent, pattern));
        Map<String, FileInfo> files = this.toMap(this.getFiles(parent, pattern));
        Assert.assertEquals((String)"", (long)expectedNumFolders, (long)folders.size());
        Assert.assertEquals((String)"", (long)expectedNumFiles, (long)files.size());
        if (expectedFiles != null) {
            for (ExpectedFile expectedFile : expectedFiles) {
                fileInfo = files.get(expectedFile.getName());
                Assert.assertNotNull((String)"", (Object)fileInfo);
                Assert.assertNotNull((String)"", (Object)fileInfo.getContentData());
                Assert.assertEquals((Object)expectedFile.getMimeType(), (Object)fileInfo.getContentData().getMimetype());
                if (fileInfo.getContentData().getMimetype() != "text/plain" || expectedFile.getContentContains() == null) continue;
                ContentReader reader = this.contentService.getReader(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
                String contentContains = expectedFile.getContentContains();
                Assert.assertTrue((String)"", (reader.getContentString().indexOf(contentContains) != -1 ? 1 : 0) != 0);
            }
        }
        if (expectedFolders != null) {
            for (ExpectedFolder expectedFolder : expectedFolders) {
                fileInfo = folders.get(expectedFolder.getName());
                Assert.assertNotNull((String)"", (Object)fileInfo);
            }
        }
    }

    protected void checkContent(FileInfo file, String name, String mimeType) {
        Assert.assertEquals((String)"", (Object)name, (Object)file.getName());
        Assert.assertEquals((String)"", (Object)mimeType, (Object)file.getContentData().getMimetype());
    }

    protected static class ExpectedFile {
        private String name;
        private String mimeType;
        private String contentContains = null;

        public ExpectedFile(String name, String mimeType, String contentContains) {
            this(name, mimeType);
            this.contentContains = contentContains;
        }

        public ExpectedFile(String name, String mimeType) {
            this.name = name;
            this.mimeType = mimeType;
        }

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getContentContains() {
            return this.contentContains;
        }
    }

    protected static class ExpectedFolder {
        private String name;

        public ExpectedFolder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

