/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.bulkimport.AnalysedDirectory;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.ImportFilter;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.MetadataLoader;
import org.alfresco.repo.bulkimport.impl.BulkImportStatusImpl;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryAnalyserImpl
implements DirectoryAnalyser {
    private static final Log log = LogFactory.getLog(DirectoryAnalyserImpl.class);
    private static final Pattern VERSION_SUFFIX_PATTERN = Pattern.compile(".+\\.v([0-9]+)\\z");
    private MetadataLoader metadataLoader;
    private BulkImportStatusImpl importStatus;
    private List<ImportFilter> importFilters;

    public DirectoryAnalyserImpl(MetadataLoader metadataLoader, BulkImportStatusImpl importStatus, List<ImportFilter> importFilters) {
        this.metadataLoader = metadataLoader;
        this.importStatus = importStatus;
        this.importFilters = importFilters;
    }

    public DirectoryAnalyserImpl() {
    }

    public void setMetadataLoader(MetadataLoader metadataLoader) {
        this.metadataLoader = metadataLoader;
    }

    public void setImportStatus(BulkImportStatusImpl status) {
        this.importStatus = status;
    }

    public final void setImportFilters(List<ImportFilter> importFilters) {
        this.importFilters = importFilters != null ? importFilters : new ArrayList<ImportFilter>();
    }

    protected boolean shouldFilter(ImportableItem importableItem) {
        boolean filterImportableItem = false;
        if (this.importFilters != null && this.importFilters.size() > 0) {
            for (ImportFilter filter : this.importFilters) {
                if (!filter.shouldFilter(importableItem)) continue;
                filterImportableItem = true;
                break;
            }
        }
        return filterImportableItem;
    }

    @Override
    public AnalysedDirectory analyseDirectory(ImportableItem directory, FileFilter filter) {
        ImportableItem importableItem;
        File directoryFile = directory.getHeadRevision().getContentFile();
        AnalysedDirectory result = null;
        result = filter == null ? new AnalysedDirectory(directoryFile.listFiles()) : new AnalysedDirectory(directoryFile.listFiles(filter));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Analysing directory " + FileUtils.getFileName(directoryFile) + "..."));
        }
        for (File file : result.getOriginalListing()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Scanning file " + FileUtils.getFileName(file) + "..."));
            }
            if (file.canRead()) {
                if (this.isVersionFile(file)) {
                    this.addVersionFile(directory, result, file);
                    this.importStatus.incrementNumberOfFilesScanned();
                    continue;
                }
                if (this.isMetadataFile(file)) {
                    this.addMetadataFile(directory, result, file);
                    this.importStatus.incrementNumberOfFilesScanned();
                    continue;
                }
                boolean isDirectory = this.addParentFile(directory, result, file);
                if (isDirectory) {
                    this.importStatus.incrementNumberOfFoldersScanned();
                    continue;
                }
                this.importStatus.incrementNumberOfFilesScanned();
                continue;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skipping unreadable file '" + FileUtils.getFileName(file) + "'."));
            }
            this.importStatus.incrementNumberOfUnreadableEntries();
        }
        Iterator<ImportableItem> iter = result.getImportableItems().iterator();
        while (iter.hasNext()) {
            importableItem = iter.next();
            if (importableItem.isValid()) continue;
            iter.remove();
        }
        iter = result.getImportableDirectories().iterator();
        while (iter.hasNext()) {
            importableItem = iter.next();
            if (importableItem.isValid()) continue;
            iter.remove();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished analysing directory " + FileUtils.getFileName(directoryFile) + "."));
        }
        return result;
    }

    private boolean isVersionFile(File file) {
        Matcher matcher = VERSION_SUFFIX_PATTERN.matcher(file.getName());
        return matcher.matches();
    }

    private boolean isMetadataFile(File file) {
        boolean result = false;
        if (this.metadataLoader != null) {
            result = file.getName().endsWith(".metadata." + this.metadataLoader.getMetadataFileExtension());
        }
        return result;
    }

    private void addVersionFile(ImportableItem parent, AnalysedDirectory analysedDirectory, File versionFile) {
        File parentContentFile = this.getParentOfVersionFile(versionFile);
        boolean isContentVersion = false;
        if (this.isMetadataFile(parentContentFile)) {
            parentContentFile = this.getParentOfMetadatafile(parentContentFile);
            isContentVersion = false;
        } else {
            isContentVersion = true;
        }
        ImportableItem importableItem = this.findOrCreateImportableItem(parent, analysedDirectory, parentContentFile);
        int version = this.getVersionNumber(versionFile);
        ImportableItem.VersionedContentAndMetadata versionEntry = this.findOrCreateVersionEntry(importableItem, version);
        if (isContentVersion) {
            versionEntry.setContentFile(versionFile);
        } else {
            versionEntry.setMetadataFile(versionFile);
        }
    }

    private void addMetadataFile(ImportableItem parent, AnalysedDirectory analysedDirectory, File metadataFile) {
        File parentContentfile = this.getParentOfMetadatafile(metadataFile);
        ImportableItem importableItem = this.findOrCreateImportableItem(parent, analysedDirectory, parentContentfile);
        importableItem.getHeadRevision().setMetadataFile(metadataFile);
    }

    private boolean addParentFile(ImportableItem parent, AnalysedDirectory analysedDirectory, File contentFile) {
        ImportableItem importableItem = this.findOrCreateImportableItem(parent, analysedDirectory, contentFile);
        importableItem.getHeadRevision().setContentFile(contentFile);
        return importableItem.getHeadRevision().getContentFileType() == ImportableItem.FileType.DIRECTORY;
    }

    private ImportableItem findOrCreateImportableItem(ImportableItem parent, AnalysedDirectory analysedDirectory, File contentFile) {
        ImportableItem result = this.findImportableItem(analysedDirectory, contentFile);
        if (result == null) {
            result = new ImportableItem();
            result.setParent(parent);
            result.getHeadRevision().setContentFile(contentFile);
            if (!this.shouldFilter(result)) {
                analysedDirectory.addImportableItem(result);
            }
        }
        return result;
    }

    private ImportableItem findImportableItem(AnalysedDirectory analysedDirectory, File contentFile) {
        ImportableItem result = null;
        if (contentFile == null) {
            throw new IllegalStateException("Cannot call findOrCreateImportableItem with null key");
        }
        result = analysedDirectory.findImportableItem(contentFile);
        return result;
    }

    private ImportableItem.VersionedContentAndMetadata findOrCreateVersionEntry(ImportableItem importableItem, int version) {
        ImportableItem.VersionedContentAndMetadata result = this.findVersionEntry(importableItem, version);
        if (result == null) {
            ImportableItem importableItem2 = importableItem;
            importableItem2.getClass();
            result = importableItem2.new ImportableItem.VersionedContentAndMetadata(version);
            importableItem.addVersionEntry(result);
        }
        return result;
    }

    private ImportableItem.VersionedContentAndMetadata findVersionEntry(ImportableItem importableItem, int version) {
        ImportableItem.VersionedContentAndMetadata result = null;
        if (importableItem.hasVersionEntries()) {
            for (ImportableItem.VersionedContentAndMetadata versionEntry : importableItem.getVersionEntries()) {
                if (version != versionEntry.getVersion()) continue;
                result = versionEntry;
                break;
            }
        }
        return result;
    }

    private int getVersionNumber(File versionFile) {
        int result = -1;
        if (!this.isVersionFile(versionFile)) {
            throw new IllegalStateException(FileUtils.getFileName(versionFile) + " is not a version file.");
        }
        Matcher matcher = VERSION_SUFFIX_PATTERN.matcher(versionFile.getName());
        String versionStr = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("");
        }
        versionStr = matcher.group(1);
        result = Integer.parseInt(versionStr);
        return result;
    }

    private File getParentOfVersionFile(File versionFile) {
        File result = null;
        if (!this.isVersionFile(versionFile)) {
            throw new IllegalStateException(FileUtils.getFileName(versionFile) + " is not a version file.");
        }
        String parentFilename = versionFile.getName().replaceFirst("\\.v([0-9]+)\\z", "");
        result = new File(versionFile.getParent(), parentFilename);
        return result;
    }

    private File getParentOfMetadatafile(File metadataFile) {
        File result = null;
        if (!this.isMetadataFile(metadataFile)) {
            throw new IllegalStateException(FileUtils.getFileName(metadataFile) + " is not a metadata file.");
        }
        String name = metadataFile.getName();
        String contentName = name.substring(0, name.length() - (".metadata." + this.metadataLoader.getMetadataFileExtension()).length());
        result = new File(metadataFile.getParent(), contentName);
        return result;
    }
}

