/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.bulkimport.impl.StripingFilesystemTracker;

public class StripingBulkFilesystemImporter
extends MultiThreadedBulkFilesystemImporter {
    protected void bulkImportImpl(BulkImportParameters bulkImportParameters, NodeImporter nodeImporter, String lockToken) {
        super.bulkImportImpl(bulkImportParameters, nodeImporter, lockToken);
        File sourceFolder = nodeImporter.getSourceFolder();
        int batchSize = this.getBatchSize(bulkImportParameters);
        int loggingInterval = this.getLoggingInterval(bulkImportParameters);
        StripingFilesystemTracker tracker = new StripingFilesystemTracker(this.directoryAnalyser, bulkImportParameters.getTarget(), sourceFolder, batchSize);
        BatchProcessor<ImportableItem> batchProcessor = this.getBatchProcessor(bulkImportParameters, tracker.getWorkProvider(), loggingInterval);
        BatchProcessor.BatchProcessWorker<ImportableItem> worker = this.getWorker(bulkImportParameters, lockToken, nodeImporter, tracker);
        do {
            batchProcessor.process(worker, true);
        } while (tracker.moreLevels());
    }
}

