/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.metadataloaders;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.MetadataLoader;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMapBasedMetadataLoader
implements MetadataLoader {
    private static final Log log = LogFactory.getLog(AbstractMapBasedMetadataLoader.class);
    private static final String PROPERTY_NAME_TYPE = "type";
    private static final String PROPERTY_NAME_ASPECTS = "aspects";
    private static final String DEFAULT_MULTI_VALUED_SEPARATOR = ",";
    protected final NamespaceService namespaceService;
    protected final DictionaryService dictionaryService;
    protected final String multiValuedSeparator;
    protected final String metadataFileExtension;

    protected AbstractMapBasedMetadataLoader(ServiceRegistry serviceRegistry, String fileExtension) {
        this(serviceRegistry, DEFAULT_MULTI_VALUED_SEPARATOR, fileExtension);
    }

    protected AbstractMapBasedMetadataLoader(ServiceRegistry serviceRegistry, String multiValuedSeparator, String fileExtension) {
        assert (serviceRegistry != null) : "serviceRegistry must not be null";
        assert (multiValuedSeparator != null) : "multiValuedSeparator must not be null";
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.dictionaryService = serviceRegistry.getDictionaryService();
        this.multiValuedSeparator = multiValuedSeparator;
        this.metadataFileExtension = fileExtension;
    }

    @Override
    public final String getMetadataFileExtension() {
        return this.metadataFileExtension;
    }

    protected abstract Map<String, Serializable> loadMetadataFromFile(File var1);

    @Override
    public final void loadMetadata(ImportableItem.ContentAndMetadata contentAndMetadata, MetadataLoader.Metadata metadata) {
        if (contentAndMetadata.metadataFileExists()) {
            File metadataFile = contentAndMetadata.getMetadataFile();
            if (metadataFile.canRead()) {
                Map<String, Serializable> metadataProperties = this.loadMetadataFromFile(metadataFile);
                for (String key : metadataProperties.keySet()) {
                    if (PROPERTY_NAME_TYPE.equals(key)) {
                        String typeName = (String)((Object)metadataProperties.get(key));
                        QName type = QName.createQName((String)typeName, (NamespacePrefixResolver)this.namespaceService);
                        metadata.setType(type);
                        continue;
                    }
                    if (PROPERTY_NAME_ASPECTS.equals(key)) {
                        String[] aspectNames;
                        for (String aspectName : aspectNames = ((String)((Object)metadataProperties.get(key))).split(DEFAULT_MULTI_VALUED_SEPARATOR)) {
                            QName aspect = QName.createQName((String)aspectName.trim(), (NamespacePrefixResolver)this.namespaceService);
                            metadata.addAspect(aspect);
                        }
                        continue;
                    }
                    QName name = QName.createQName((String)key, (NamespacePrefixResolver)this.namespaceService);
                    PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(name);
                    if (propertyDefinition != null) {
                        if (propertyDefinition.isMultiValued()) {
                            ArrayList<String> values = new ArrayList<String>(Arrays.asList(((String)((Object)metadataProperties.get(key))).split(this.multiValuedSeparator)));
                            metadata.addProperty(name, values);
                            continue;
                        }
                        metadata.addProperty(name, metadataProperties.get(key));
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Property " + String.valueOf(name) + " doesn't exist in the Data Dictionary.  Ignoring it."));
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Metadata file '" + FileUtils.getFileName(metadataFile) + "' is not readable."));
            }
        }
    }
}

