/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import net.sf.ehcache.CacheManager;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:cache-test/cache-test-context.xml", ApplicationContextHelper.CONFIG_LOCATIONS[0]});
    private ServiceRegistry serviceRegistry;
    private SimpleCache<String, Object> standaloneCache;
    private SimpleCache<String, Object> backingCache;
    private TransactionalCache<String, Object> transactionalCache;
    private SimpleCache<String, Object> objectCache;
    private static final String NEW_GLOBAL_ONE = "new_global_one";
    private static final String NEW_GLOBAL_TWO = "new_global_two";
    private static final String NEW_GLOBAL_THREE = "new_global_three";
    private static final String UPDATE_TXN_THREE = "updated_txn_three";
    private static final String UPDATE_TXN_FOUR = "updated_txn_four";
    private static final String COMMON_KEY = "A";
    private static final MutableLong VALUE_ONE_A = new MutableLong(1L);
    private static final MutableLong VALUE_ONE_B = new MutableLong(1L);
    private static final MutableLong VALUE_TWO_A = new MutableLong(2L);

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            CacheTest.fail((String)"A transaction is still running");
        }
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.standaloneCache = (SimpleCache)ctx.getBean("ehCache1");
        this.backingCache = (SimpleCache)ctx.getBean("backingCache");
        this.transactionalCache = (TransactionalCache)ctx.getBean("transactionalCache");
        this.objectCache = (SimpleCache)ctx.getBean("objectCache");
        this.backingCache.clear();
        this.transactionalCache.setMutable(true);
        this.transactionalCache.setAllowEqualsChecks(false);
    }

    public void tearDown() {
        this.serviceRegistry = null;
        this.standaloneCache = null;
        this.backingCache = null;
        this.transactionalCache = null;
    }

    public void testSetUp() throws Exception {
        CacheManager cacheManager = (CacheManager)ctx.getBean("testEHCacheManager");
        CacheTest.assertNotNull((Object)cacheManager);
        CacheManager cacheManagerCheck = (CacheManager)ctx.getBean("testEHCacheManager");
        CacheTest.assertTrue((cacheManager == cacheManagerCheck ? 1 : 0) != 0);
        CacheTest.assertNotNull((Object)this.serviceRegistry);
        CacheTest.assertNotNull(this.backingCache);
        CacheTest.assertNotNull(this.standaloneCache);
        CacheTest.assertNotNull(this.transactionalCache);
        CacheTest.assertNotNull(this.objectCache);
    }

    public void testObjectCache() throws Exception {
        this.objectCache.put((Serializable)((Object)COMMON_KEY), (Object)this);
        Object obj = this.objectCache.get((Serializable)((Object)COMMON_KEY));
        CacheTest.assertTrue((String)"Object not cached properly", (this == obj ? 1 : 0) != 0);
    }

    public void testEhcacheAdaptors() throws Exception {
        this.backingCache.put((Serializable)((Object)COMMON_KEY), (Object)"AAA");
        CacheTest.assertNull((String)"Second cache should not have first's present", (Object)this.standaloneCache.get((Serializable)((Object)COMMON_KEY)));
        CacheTest.assertEquals((Object)"AAA", (Object)this.backingCache.get((Serializable)((Object)COMMON_KEY)));
        Collection keys = this.backingCache.getKeys();
        CacheTest.assertEquals((String)"Backing cache didn't return correct number of keys", (int)1, (int)keys.size());
        this.backingCache.remove((Serializable)((Object)COMMON_KEY));
        CacheTest.assertNull((Object)this.backingCache.get((Serializable)((Object)COMMON_KEY)));
    }

    public void testTransactionalCacheNoTxn() throws Exception {
        String key = "B";
        String value = "BBB";
        this.transactionalCache.put(key, value);
        CacheTest.assertEquals((String)"Backing cache not used for put when no transaction present", (Object)value, (Object)this.backingCache.get((Serializable)((Object)key)));
        this.backingCache.remove((Serializable)((Object)key));
        CacheTest.assertNull((String)"Backing cache not used for removed when no transaction present", (Object)this.transactionalCache.get(key));
        this.backingCache.put((Serializable)((Object)key), (Object)value);
        this.transactionalCache.remove(key);
        CacheTest.assertNull((String)"Non-transactional remove didn't go to backing cache", (Object)this.backingCache.get((Serializable)((Object)key)));
    }

    public void testRollbackCleanup() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        RetryingTransactionHelper txnHelper = transactionService.getRetryingTransactionHelper();
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){
            private int throwCount = 0;

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put(CacheTest.NEW_GLOBAL_TWO, CacheTest.NEW_GLOBAL_TWO);
                CacheTest.this.transactionalCache.remove(CacheTest.NEW_GLOBAL_ONE);
                String key = "B";
                String value = "BBB";
                CacheTest.this.transactionalCache.put(key, value);
                if (this.throwCount < 5) {
                    ++this.throwCount;
                    throw new SQLException("Dummy");
                }
                throw new Exception("Fail");
            }
        };
        try {
            txnHelper.doInTransaction(callback);
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheTest.assertFalse((String)"Remove not done after rollback", (boolean)this.transactionalCache.contains(NEW_GLOBAL_ONE));
        CacheTest.assertFalse((String)"Update happened after rollback", (boolean)this.transactionalCache.contains(NEW_GLOBAL_TWO));
    }

    public void testTransactionalCacheWithSingleTxn() throws Throwable {
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE);
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_TWO), (Object)NEW_GLOBAL_TWO);
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_THREE), (Object)NEW_GLOBAL_THREE);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            this.transactionalCache.remove(NEW_GLOBAL_ONE);
            CacheTest.assertFalse((String)"Item was not removed from txn cache", (boolean)this.transactionalCache.contains(NEW_GLOBAL_ONE));
            CacheTest.assertNull((String)"Get didn't return null", (Object)this.transactionalCache.get(NEW_GLOBAL_ONE));
            CacheTest.assertTrue((String)"Item was removed from backing cache", (boolean)this.backingCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertEquals((String)"Item not read from backing cache", (Object)NEW_GLOBAL_TWO, (Object)this.transactionalCache.get(NEW_GLOBAL_TWO));
            this.backingCache.put((Serializable)((Object)NEW_GLOBAL_TWO), (Object)"new_global_two-updated");
            CacheTest.assertEquals((String)"Read-committed not preserved", (Object)NEW_GLOBAL_TWO, (Object)this.transactionalCache.get(NEW_GLOBAL_TWO));
            this.transactionalCache.put(UPDATE_TXN_THREE, "XXX");
            CacheTest.assertEquals((String)"Item not updated in txn cache", (Object)"XXX", (Object)this.transactionalCache.get(UPDATE_TXN_THREE));
            CacheTest.assertFalse((String)"Item was put into backing cache", (boolean)this.backingCache.contains((Serializable)((Object)UPDATE_TXN_THREE)));
            Collection<String> transactionalKeys = this.transactionalCache.getKeys();
            CacheTest.assertFalse((String)"Transactionally removed item found in keys", (boolean)transactionalKeys.contains(NEW_GLOBAL_ONE));
            CacheTest.assertTrue((String)"Transactionally added item not found in keys", (boolean)transactionalKeys.contains(UPDATE_TXN_THREE));
            PostCommitCacheReader listenerReader = new PostCommitCacheReader(this.transactionalCache, UPDATE_TXN_THREE);
            AlfrescoTransactionSupport.bindListener(listenerReader);
            PostCommitCacheWriter listenerWriter = new PostCommitCacheWriter(this.transactionalCache, UPDATE_TXN_FOUR, "FOUR");
            AlfrescoTransactionSupport.bindListener(listenerWriter);
            txn.commit();
            if (listenerReader.e != null) {
                throw listenerReader.e;
            }
            if (listenerWriter.e != null) {
                throw listenerWriter.e;
            }
            CacheTest.assertFalse((String)"Item was not removed from backing cache", (boolean)this.backingCache.contains((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertNull((String)"Item could still be fetched from backing cache", (Object)this.backingCache.get((Serializable)((Object)NEW_GLOBAL_ONE)));
            CacheTest.assertEquals((String)"Item not updated in backing cache", (Object)"XXX", (Object)this.backingCache.get((Serializable)((Object)UPDATE_TXN_THREE)));
            CacheTest.assertEquals((String)"Transactional cache must serve post-commit get requests", (Object)"XXX", (Object)this.transactionalCache.get(UPDATE_TXN_THREE));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public void testTransactionalCacheDisableSharedCaches() throws Throwable {
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_ONE), (Object)NEW_GLOBAL_ONE);
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_TWO), (Object)NEW_GLOBAL_TWO);
        this.backingCache.put((Serializable)((Object)NEW_GLOBAL_THREE), (Object)NEW_GLOBAL_THREE);
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            this.transactionalCache.setDisableSharedCacheReadForTransaction(true);
            CacheTest.assertNull((String)"Read of mutable shared cache MUST NOT use backing cache", (Object)this.transactionalCache.get(NEW_GLOBAL_ONE));
            CacheTest.assertNull((String)"Value should not be in any cache", (Object)this.transactionalCache.get(UPDATE_TXN_THREE));
            this.transactionalCache.put(NEW_GLOBAL_TWO, "An update");
            this.transactionalCache.put(UPDATE_TXN_THREE, UPDATE_TXN_THREE);
            CacheTest.assertNull((String)"Read of mutable shared cache MUST NOT use backing cache", (Object)this.transactionalCache.get(NEW_GLOBAL_ONE));
            CacheTest.assertEquals((String)"Value should be in transactional cache", (Object)"An update", (Object)this.transactionalCache.get(NEW_GLOBAL_TWO));
            CacheTest.assertEquals((String)"Value should be in transactional cache", (Object)UPDATE_TXN_THREE, (Object)this.transactionalCache.get(UPDATE_TXN_THREE));
            txn.commit();
            CacheTest.assertEquals((String)"Out-of-txn read must return shared value", (Object)NEW_GLOBAL_ONE, (Object)this.transactionalCache.get(NEW_GLOBAL_ONE));
            CacheTest.assertNull((String)"Value should be removed from shared cache", (Object)this.transactionalCache.get(NEW_GLOBAL_TWO));
            CacheTest.assertEquals((String)"New values must be written to shared cache", (Object)UPDATE_TXN_THREE, (Object)this.transactionalCache.get(UPDATE_TXN_THREE));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public long runPerformanceTestOnCache(SimpleCache<String, Object> cache, int objectCount) {
        for (int i = 0; i < objectCount; ++i) {
            String key = Integer.toString(i);
            Integer value = new Integer(i);
            cache.put((Serializable)((Object)key), (Object)value);
        }
        long start = System.nanoTime();
        for (int i = 0; i < objectCount; ++i) {
            String key = Integer.toString(i);
            cache.remove((Serializable)((Object)key));
            key = Integer.toString(i + objectCount);
            Integer value = new Integer(i + objectCount);
            cache.put((Serializable)((Object)key), (Object)value);
        }
        long stop = System.nanoTime();
        return stop - start;
    }

    public void testPerformance() throws Exception {
        for (int i = 0; i < 6; ++i) {
            int count = (int)Math.pow(10.0, i);
            long timePlain = this.runPerformanceTestOnCache(this.standaloneCache, count);
            TransactionService transactionService = this.serviceRegistry.getTransactionService();
            UserTransaction txn = transactionService.getUserTransaction();
            txn.begin();
            long timeTxn = this.runPerformanceTestOnCache(this.transactionalCache, count);
            long commitStart = System.nanoTime();
            txn.commit();
            long commitEnd = System.nanoTime();
            long commitTime = commitEnd - commitStart;
            System.out.println("Cache performance test: \n   count: " + count + "\n" + "   direct: " + timePlain / (long)count + " ns\\count \n" + "   transaction: " + (timeTxn += commitTime) / (long)count + " ns\\count");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitializationPerformance() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        long start = System.nanoTime();
        int count = 10000;
        for (int i = 0; i < count; ++i) {
            Throwable ee2;
            Object var8_7;
            UserTransaction txn = transactionService.getUserTransaction();
            try {
                txn.begin();
                this.transactionalCache.contains(COMMON_KEY);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                try {
                    txn.rollback();
                }
                catch (Throwable ee2) {
                    ee2.printStackTrace();
                }
                throw throwable;
            }
            try {
                txn.rollback();
            }
            catch (Throwable ee2) {
                ee2.printStackTrace();
            }
        }
        long end = System.nanoTime();
        System.out.println("Cache initialization performance test: \n   count:       " + count + "\n" + "   transaction: " + (end - start) / (long)count + " ns\\count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String ... args) {
        try {
            try {
                CacheTest test = new CacheTest();
                test.setUp();
                System.out.println("Press any key to run initialization test ...");
                System.in.read();
                test.testInitializationPerformance();
                System.out.println("Press any key to run performance test ...");
                System.in.read();
                test.testPerformance();
                System.out.println("Press any key to shutdown ...");
                System.in.read();
                test.tearDown();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Object var3_4 = null;
                ApplicationContextHelper.closeApplicationContext();
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ApplicationContextHelper.closeApplicationContext();
            throw throwable;
        }
        ApplicationContextHelper.closeApplicationContext();
    }

    public void testNullValue() throws Throwable {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        txn.begin();
        this.backingCache.put((Serializable)((Object)COMMON_KEY), null);
        this.transactionalCache.put(COMMON_KEY, "AAA");
        try {
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxSizeOverrun() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            Integer startValue = new Integer(-1);
            String startKey = ((Object)startValue).toString();
            this.transactionalCache.put(startKey, startValue);
            CacheTest.assertEquals((String)"The start value isn't correct", (Object)startValue, (Object)this.transactionalCache.get(startKey));
            for (int i = 0; i < 205000; ++i) {
                Integer value = i;
                String key = ((Object)value).toString();
                this.transactionalCache.put(key, value);
            }
            Object checkStartValue = this.transactionalCache.get(startKey);
            CacheTest.assertNull((String)"The start value didn't drop out of the cache", (Object)checkStartValue);
            txn.commit();
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable ee) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndCheck(RetryingTransactionHelper.RetryingTransactionCallback<Object> callback, boolean readOnly, String key, Object expectedValue) throws Throwable {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction(readOnly);
        try {
            txn.begin();
            callback.execute();
            txn.commit();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable ee) {}
        Object actualValue = this.backingCache.get((Serializable)((Object)key));
        CacheTest.assertEquals((String)"Backing cache value was not correct", (Object)expectedValue, (Object)actualValue);
        this.backingCache.clear();
    }

    public void testConcurrentAddAgainstAdd() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_A);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentAddAgainstAddSame() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_A);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
    }

    public void testConcurrentAddAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_A);
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_A);
    }

    public void testConcurrentUpdateAgainstUpdate() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_B);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_TWO_A);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_TWO_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_TWO_A);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_TWO_A);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_TWO_A);
    }

    public void testConcurrentUpdateAgainstUpdateNull() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_B);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), null);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentUpdateNullAgainstUpdate() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, null);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentUpdateAgainstRemove() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_B);
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentUpdateAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_B);
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentRemoveAgainstUpdate_NoPreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.transactionalCache.remove(CacheTest.COMMON_KEY);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
    }

    public void testConcurrentAddAgainstAdd_NoPreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                CacheTest.this.transactionalCache.put(CacheTest.COMMON_KEY, VALUE_ONE_A);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, VALUE_ONE_B);
        this.executeAndCheck(callback, true, COMMON_KEY, VALUE_ONE_B);
    }

    public void testConcurrentRemoveAgainstUpdate_PreExisting() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.remove(CacheTest.COMMON_KEY);
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_B);
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
    }

    public void testConcurrentRemoveAgainstRemove() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.remove(CacheTest.COMMON_KEY);
                CacheTest.this.backingCache.remove((Serializable)((Object)CacheTest.COMMON_KEY));
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
    }

    public void testConcurrentRemoveAgainstClear() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                CacheTest.this.backingCache.put((Serializable)((Object)CacheTest.COMMON_KEY), (Object)VALUE_ONE_A);
                CacheTest.this.transactionalCache.remove(CacheTest.COMMON_KEY);
                CacheTest.this.backingCache.clear();
                return null;
            }
        };
        this.transactionalCache.setAllowEqualsChecks(false);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setAllowEqualsChecks(true);
        this.transactionalCache.setMutable(true);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
        this.transactionalCache.setMutable(false);
        this.executeAndCheck(callback, false, COMMON_KEY, null);
        this.executeAndCheck(callback, true, COMMON_KEY, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostCommitCacheWriter
    extends TransactionListenerAdapter {
        private final SimpleCache<String, Object> transactionalCache;
        private final String key;
        private final Object value;
        private Throwable e;

        private PostCommitCacheWriter(SimpleCache<String, Object> transactionalCache, String key, Object value) {
            this.transactionalCache = transactionalCache;
            this.key = key;
            this.value = value;
        }

        @Override
        public void afterCommit() {
            try {
                this.transactionalCache.put((Serializable)((Object)this.key), this.value);
                this.transactionalCache.remove((Serializable)((Object)this.key));
                this.transactionalCache.clear();
            }
            catch (Throwable e) {
                this.e = e;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostCommitCacheReader
    extends TransactionListenerAdapter {
        private final SimpleCache<String, Object> transactionalCache;
        private final String key;
        private Throwable e;

        private PostCommitCacheReader(SimpleCache<String, Object> transactionalCache, String key) {
            this.transactionalCache = transactionalCache;
            this.key = key;
        }

        @Override
        public void afterCommit() {
            try {
                this.transactionalCache.get((Serializable)((Object)this.key));
            }
            catch (Throwable e) {
                this.e = e;
                return;
            }
        }
    }
}

