/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.Collection;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheAdapter<K extends Serializable, V>
implements SimpleCache<K, V> {
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean contains(K key) {
        try {
            return this.cache.getQuiet(key) != null;
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("contains failed", (Throwable)e);
        }
    }

    public Collection<K> getKeys() {
        return this.cache.getKeys();
    }

    public V get(K key) {
        try {
            Element element = this.cache.get(key);
            if (element != null) {
                return (V)element.getObjectValue();
            }
            return null;
        }
        catch (IllegalStateException ie) {
            throw new AlfrescoRuntimeException("Failed to get from EhCache as state invalid: \n  state: " + this.cache.getStatus() + "\n" + "   key: " + key, (Throwable)ie);
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("Failed to get from EhCache: \n   key: " + key, (Throwable)e);
        }
    }

    public void put(K key, V value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }
}

